#ifndef FIT_COMMAND
#define FIT_COMMAND

//#ifdef SWIGPYTHON
//class AdvFitCommand;
//#else // SWIGPYTHON

#define USE_PTHREAD

#ifdef USE_PTHREAD
#include <pthread.h>
#endif // USE_PTHREAD

#include <bitset>

#include "Header.hh"

#include "AdvMessage.hh"

class AdvFitCommand : public AdvMessage {
    private:
        static const std::string className; // =std::string("AdvFitCommand");

    private:
#ifdef USE_PTHREAD
        pthread_mutex_t mutex;
        pthread_cond_t  guard;
#endif // USE_PTHREAD
        enum bitPos {
            CONTINUE_BIT, // =0;
            SUSPEND_BIT,  // =1;
            STOP_BIT,     // =2;
        };

        std::bitset<3> commandBit;
        Bool writeFlag;
        Bool readFlag;
   
    public:
        AdvFitCommand();
        ~AdvFitCommand();

        void setContinue();
        void setSuspend();
        void setStop();

        Bool checkStop();
        Bool checkSuspend();
        Bool checkContinue();
};

//#endif // SWIGPYTHON

#endif // FIT_COMMAND

