#ifndef EXT_VECTOR_TOOL
#define EXT_VECTOR_TOOL

#include "Header.hh"
#include "VectorTool.hh"

class AdvExtVectorTool : public VectorTool {

    public:
        AdvExtVectorTool();
        virtual ~AdvExtVectorTool();

        /** transform Double array to std::vector<Double> */
        std::vector<Double> *arrayToVectorP(const Double *array, const UInt4 n);

        /** transform Double array (1d) to std::vector< std::vector<Double> ) */
        std::vector< std::vector<Double> > *arrayToMatrixP(const Double *attay, const UInt4 rN, const UInt4 cN);

        /** transform Double array (1d) to std::vector< std::vector<Double> ) */
        std::vector< std::vector<Double> > ArrayToMatrix(const Double *attay, const UInt4 rN, const UInt4 cN);

        /** transform std::vector< std::vector<Double> > to Double array (1d) */
        Double *MatrixTo1DArray(const std::vector< std::vector<Double> > &m);

};
#endif // EXT_VECTOR_TOOL
