#include "AdvExtVectorTool.hh"

/**
 * constructor
 */
AdvExtVectorTool::AdvExtVectorTool() : VectorTool() {
}

/**
 * constructor
 */
AdvExtVectorTool::~AdvExtVectorTool() {
}

std::vector<Double> *AdvExtVectorTool::arrayToVectorP(const Double *array, const UInt4 n) {
    std::vector<Double> *retval = NULL;
    if ( array != NULL ) {
        retval=new std::vector<Double>(n);
        for (UInt4 i=0; i<n; ++i) {
            retval->at(i)=array[i];
        }
    }
    return retval;
}


/**
 *  transform an array to an matrix (std::vector< std::vector<Double> >)
 *
 *  \param[in]  a   an Double type array
 *  \param[in]  rN  the number of the row
 *  \param[in]  cN  the number of the column
 *  \return the pointer to the array, if a != NULL
 *  \return NULL,                     if a == NULL
 */
std::vector< std::vector<Double> > *AdvExtVectorTool::arrayToMatrixP(const Double *a, const UInt4 rN, const UInt4 cN) {

    std::vector< std::vector<Double> > *retval = NULL;
    if ( a != NULL ) {
        retval = new std::vector< std::vector<Double> >(rN);
        for (UInt4 i=0; i<rN; ++i) {
            retval->at(i)=*(new std::vector<Double>(cN));
        }
        for (UInt4 i=0; i<rN; ++i) {
            for (UInt4 j=0; j<cN; ++j) {
                retval->at(i).at(j) = a[i*cN+j];
            }
        }
    }
    return retval;
}

/**
 *  transform an array to an matrix (std::vector< std::vector<Double> >)
 *
 *  \param[in]  a   an Double type array
 *  \param[in]  rN  the number of the row
 *  \param[in]  cN  the number of the column
 *  \return the pointer to the array, if a != NULL
 *  \return NULL,                     if a == NULL
 */
std::vector< std::vector<Double> > AdvExtVectorTool::ArrayToMatrix(const Double *a, const UInt4 rN, const UInt4 cN) {
    return a == static_cast<Double*>(NULL) ? *(new std::vector< std::vector<Double> >()): *arrayToMatrixP(a, rN, cN);
}


/**
 *  transform std::vector<Double> to (the pointer to) an array
 *
 *  \param[in]  v  an vecto<Double> std::vector
 */
Double *AdvExtVectorTool::MatrixTo1DArray(const std::vector< std::vector<Double> > &v) {

    UInt4 nElements=0;
    for (UInt4 i=0; i<v.size(); ++i) {
        nElements += v.at(i).size();
    }
    Double *retval = new Double[nElements];
    UInt4 ct=0;
    for (UInt4 i=0; i<v.size(); ++i) {
        for (UInt4 j=0; j<v.at(i).size(); ++j) {
            retval[ct]=v.at(i).at(j);
            ++ct;
        }
    }
    return retval;;
}
