#include "AdvExponential.hh"

#define NumberOfParamForExponential 2

AdvExponential::AdvExponential() : AdvFuncBase(std::string("exponential"), std::string("e"), NumberOfParamForExponential)  {
}

AdvExponential::~AdvExponential() {
}

#ifdef USE_POINTER
Double AdvExponential::eval(const Double x, const Double *p) {
    return p[0]*exp(p[1]*x);
}

#ifdef HAVE_DIFFERENTIAL_MEMBER
Double AdvExponential::der1st(const Double x, const Double *p) {
    return p[0]*p[1]*exp(p[1]*x);
}

Double AdvExponential::der2nd(const Double x, const Double *p) {
    return p[0]*p[1]*p[1]*exp(p[1]*x);
}

Double *AdvExponential::gradient(const Double x, const Double *p) {
    Double *v=new Double[NumberOfParamForExponential];
    v[0]=exp(p[1]*x);
    v[1]=p[0]*x*exp(p[1]*x);
    return *v;
}
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_POINTER

#ifdef USE_VECTOR
Double AdvExponential::eval(const Double x, const std::vector<Double> &p) {
    return p.at(0)*exp(p.at(1)*x);
}

#ifdef HAVE_DIFFERENTIAL_MEMBER
Double AdvExponential::der1st(const Double x, const std::vector<Double> &p) {
    return p.at(0)*p.at(1)*exp(p.at(1)*x);
}

Double AdvExponential::der2nd(const Double x, const std::vector<Double> &p) {
    return p.at(0)*p.at(1)*p.at(1)*exp(p.at(1)*x);
}

std::vector<Double> AdvExponential::gradient(const Double x, const std::vector<Double> &p) {
    std::vector<Double> *v=new std::vector<Double>(1);
    v->at(0)=exp(p.at(1)*x);
    v->at(1)=p.at(0)*x*exp(p.at(1)*x);
    return *v;
}
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_VECTOR

