#! /usr/bin/env python
# -*- coding:utf-8 -*-
import tkinter
import os

class App(tkinter.Frame):
    def __init__(self, master = None):
        tkinter.Frame.__init__(self, master)
        self.master.title("SQW Launch")

        self.errorstr = tkinter.StringVar()
        self.errorstr.set("SQW Reduction.")
        display = tkinter.Label(self, textvariable = self.errorstr,
                              font = ('Helvetica', '14', 'bold'))
        display.pack( side = tkinter.TOP)

        lf_frame = tkinter.LabelFrame( self, text="Resolution", padx=2)

        f = tkinter.Button(lf_frame, text = "High Resolution Mode", width=22, height=2, command = self.launch_high)
        f.pack( side=tkinter.TOP, padx=2, pady=4)
        f = tkinter.Button(lf_frame, text = "Low Resolution Mode",  width=22, height=2, command = self.launch_low)
        f.pack( side=tkinter.TOP, padx=2, pady=4)

        lf_frame.pack( side=tkinter.TOP, expand=1,pady=6, padx=6)

        button2 = tkinter.Button(self, text = "Exit", command = self.master.destroy)
        button2.pack(padx = 6, pady = 3, side = tkinter.RIGHT)
        self.pack()

    def launch_high(self):
        os.system('xterm -e "source /opt/mlfsoft/python-utsusemi/utsusemi/DNA/bashrc.py3.DNA; export FastChopperUse=True ; python3 ~/SQW/SQW.py " &')
        self.master.destroy()

    def launch_low(self):
        os.system('xterm -e "source /opt/mlfsoft/python-utsusemi/utsusemi/DNA/bashrc.py3.DNA; export FastChopperUse=False ; python3 ~/SQW/SQW.py " &')
        self.master.destroy()


if __name__ == "__main__":
    app = App()
    app.mainloop()
