# Original ColorMap by Inamura
'''
COLOR Map
- DEFAULT_MAP
- GMT_HAXBY_MAP
- TURBO_MAP
'''
# カラーマップの定義
COLOR_MAPS = ['Default', 'autumn', 'winter',
              'gray', 'haxby', 'terrain', 'turbo']
# Title of ColorMap
COLOR_MAPS_TITLE = ["Default", "Red Scale", "Blue Scale",
                    "Gray Scale", "GMT Haxby", "Terrain", "Turbo"]

DEFAULT_MAP = {'blue': ((0.0, 0.0, 0.0),
                        (0.16, 1, 1),
                        (0.377, 1, 1),
                        (0.67, 0, 0),
                        (1, 0,0)),
               'green': ((0.0, 0, 0),
                         (0.174, 0, 0),
                         (0.410, 1, 1),
                         (0.66, 1, 1),
                         (0.915, 0, 0),
                         (1, 0, 0)),
               'red':   ((0.0, 0, 0),
                         (0.387, 0, 0),
                         (0.680, 1, 1),
                         (0.896, 1, 1),
                         (1, 0.5, 0.5))
               }
GMT_HAXBY_MAP = {'blue': [(0.0, 0.474509805441, 0.474509805441), (0.0322580635548, 0.588235318661, 0.588235318661),
                          (0.0645161271095, 0.686274528503, 0.686274528503), (0.0967741906643, 0.784313738346, 0.784313738346),
                          (0.129032254219, 0.831372559071, 0.831372559071), (0.161290317774, 0.878431379795, 0.878431379795),
                          (0.193548381329, 0.941176474094, 0.941176474094), (0.225806444883, 0.972549021244, 0.972549021244),
                          (0.258064508438, 1.0, 1.0), (0.290322571993, 1.0, 1.0),
                          (0.322580635548, 1.0, 1.0), (0.354838699102, 0.941176474094, 0.941176474094),
                          (0.387096762657, 0.882352948189, 0.882352948189), (0.419354826212, 0.784313738346, 0.784313738346),
                          (0.451612889767, 0.68235296011, 0.68235296011), (0.483870953321, 0.658823549747, 0.658823549747),
                          (0.516129016876, 0.635294139385, 0.635294139385), (0.548387110233, 0.552941203117, 0.552941203117),
                          (0.580645143986, 0.474509805441, 0.474509805441), (0.612903237343, 0.407843142748, 0.407843142748),
                          (0.645161271095, 0.341176480055, 0.341176480055), (0.677419364452, 0.270588248968, 0.270588248968),
                          (0.709677398205, 0.29411765933, 0.29411765933), (0.741935491562, 0.305882364511, 0.305882364511),
                          (0.774193525314, 0.352941185236, 0.352941185236), (0.806451618671, 0.486274510622, 0.486274510622),
                          (0.838709652424, 0.61960786581, 0.61960786581), (0.870967745781, 0.68235296011, 0.68235296011),
                          (0.903225779533, 0.768627464771, 0.768627464771), (0.93548387289, 0.843137264252, 0.843137264252),
                          (0.967741906643, 0.921568632126, 0.921568632126), (1.0, 1.0, 1.0)],
                 'green': [(0.0, 0.0, 0.0), (0.0322580635548, 0.0, 0.0),
                           (0.0645161271095, 0.0196078438312, 0.0196078438312), (0.0967741906643, 0.0392156876624, 0.0392156876624),
                           (0.129032254219, 0.0980392172933, 0.0980392172933), (0.161290317774, 0.156862750649, 0.156862750649),
                           (0.193548381329, 0.40000000596, 0.40000000596), (0.225806444883, 0.505882382393, 0.505882382393),
                           (0.258064508438, 0.686274528503, 0.686274528503), (0.290322571993, 0.745098054409, 0.745098054409),
                           (0.322580635548, 0.792156875134, 0.792156875134), (0.354838699102, 0.882352948189, 0.882352948189),
                           (0.387096762657, 0.921568632126, 0.921568632126), (0.419354826212, 0.921568632126, 0.921568632126),
                           (0.451612889767, 0.92549020052, 0.92549020052), (0.483870953321, 0.960784316063, 0.960784316063),
                           (0.516129016876, 1.0, 1.0), (0.548387110233, 0.960784316063, 0.960784316063),
                           (0.580645143986, 0.92549020052, 0.92549020052), (0.612903237343, 0.843137264252, 0.843137264252),
                           (0.645161271095, 0.741176486015, 0.741176486015), (0.677419364452, 0.627451002598, 0.627451002598),
                           (0.709677398205, 0.458823531866, 0.458823531866), (0.741935491562, 0.313725501299, 0.313725501299),
                           (0.774193525314, 0.352941185236, 0.352941185236), (0.806451618671, 0.486274510622, 0.486274510622),
                           (0.838709652424, 0.61960786581, 0.61960786581), (0.870967745781, 0.701960802078, 0.701960802078),
                           (0.903225779533, 0.768627464771, 0.768627464771), (0.93548387289, 0.843137264252, 0.843137264252),
                           (0.967741906643, 0.921568632126, 0.921568632126), (1.0, 1.0, 1.0)],
                 'red': [(0.0, 0.0392156876624, 0.0392156876624), (0.0322580635548, 0.156862750649, 0.156862750649),
                         (0.0645161271095, 0.0784313753247, 0.0784313753247), (0.0967741906643, 0.0, 0.0),
                         (0.129032254219, 0.0, 0.0), (0.161290317774, 0.0, 0.0),
                         (0.193548381329, 0.101960785687, 0.101960785687), (0.225806444883, 0.0509803928435, 0.0509803928435),
                         (0.258064508438, 0.0980392172933, 0.0980392172933), (0.290322571993, 0.196078434587, 0.196078434587),
                         (0.322580635548, 0.266666680574, 0.266666680574), (0.354838699102, 0.380392163992, 0.380392163992),
                         (0.387096762657, 0.415686279535, 0.415686279535), (0.419354826212, 0.486274510622, 0.486274510622),
                         (0.451612889767, 0.541176497936, 0.541176497936), (0.483870953321, 0.674509823322, 0.674509823322),
                         (0.516129016876, 0.803921580315, 0.803921580315), (0.548387110233, 0.874509811401, 0.874509811401),
                         (0.580645143986, 0.941176474094, 0.941176474094), (0.612903237343, 0.96862745285, 0.96862745285),
                         (0.645161271095, 1.0, 1.0), (0.677419364452, 1.0, 1.0),
                         (0.709677398205, 0.956862747669, 0.956862747669), (0.741935491562, 0.933333337307, 0.933333337307),
                         (0.774193525314, 1.0, 1.0), (0.806451618671, 1.0, 1.0),
                         (0.838709652424, 1.0, 1.0), (0.870967745781, 0.960784316063, 0.960784316063),
                         (0.903225779533, 1.0, 1.0), (0.93548387289, 1.0, 1.0),
                         (0.967741906643, 1.0, 1.0), (1.0, 1.0, 1.0)]
                 }
TURBO_MAP = {'blue':[(0.0, 0.23217, 0.23217), (0.00392156862745098, 0.26149, 0.26149),
                     (0.00784313725490196, 0.29024, 0.29024), (0.011764705882352941, 0.31844, 0.31844),
                     (0.01568627450980392, 0.34607, 0.34607), (0.0196078431372549, 0.37314, 0.37314),
                     (0.023529411764705882, 0.39964, 0.39964), (0.027450980392156862, 0.42558, 0.42558),
                     (0.03137254901960784, 0.45096, 0.45096), (0.03529411764705882, 0.47578, 0.47578),
                     (0.0392156862745098, 0.50004, 0.50004), (0.043137254901960784, 0.52373, 0.52373),
                     (0.047058823529411764, 0.54686, 0.54686), (0.050980392156862744, 0.56942, 0.56942),
                     (0.054901960784313725, 0.59142, 0.59142), (0.058823529411764705, 0.61286, 0.61286),
                     (0.06274509803921569, 0.63374, 0.63374), (0.06666666666666667, 0.65406, 0.65406),
                     (0.07058823529411765, 0.67381, 0.67381), (0.07450980392156863, 0.693, 0.693),
                     (0.0784313725490196, 0.71162, 0.71162), (0.08235294117647059, 0.72968, 0.72968),
                     (0.08627450980392157, 0.74718, 0.74718), (0.09019607843137255, 0.76412, 0.76412),
                     (0.09411764705882353, 0.7805, 0.7805), (0.09803921568627451, 0.79631, 0.79631),
                     (0.10196078431372549, 0.81156, 0.81156), (0.10588235294117647, 0.82624, 0.82624),
                     (0.10980392156862745, 0.84037, 0.84037), (0.11372549019607843, 0.85393, 0.85393),
                     (0.11764705882352941, 0.86692, 0.86692), (0.12156862745098039, 0.87936, 0.87936),
                     (0.12549019607843137, 0.89123, 0.89123), (0.12941176470588234, 0.90254, 0.90254),
                     (0.13333333333333333, 0.91328, 0.91328), (0.13725490196078433, 0.92347, 0.92347),
                     (0.1411764705882353, 0.93309, 0.93309), (0.14509803921568626, 0.94214, 0.94214),
                     (0.14901960784313725, 0.95064, 0.95064), (0.15294117647058825, 0.95857, 0.95857),
                     (0.1568627450980392, 0.96594, 0.96594), (0.16078431372549018, 0.97275, 0.97275),
                     (0.16470588235294117, 0.97899, 0.97899), (0.16862745098039217, 0.98461, 0.98461),
                     (0.17254901960784313, 0.9893, 0.9893), (0.1764705882352941, 0.99303, 0.99303),
                     (0.1803921568627451, 0.99583, 0.99583), (0.1843137254901961, 0.99773, 0.99773),
                     (0.18823529411764706, 0.99876, 0.99876), (0.19215686274509802, 0.99896, 0.99896),
                     (0.19607843137254902, 0.99835, 0.99835), (0.2, 0.99697, 0.99697),
                     (0.20392156862745098, 0.99485, 0.99485), (0.20784313725490194, 0.99202, 0.99202),
                     (0.21176470588235294, 0.98851, 0.98851), (0.21568627450980393, 0.98436, 0.98436),
                     (0.2196078431372549, 0.97959, 0.97959), (0.22352941176470587, 0.97423, 0.97423),
                     (0.22745098039215686, 0.96833, 0.96833), (0.23137254901960785, 0.9619, 0.9619),
                     (0.23529411764705882, 0.95498, 0.95498), (0.2392156862745098, 0.94761, 0.94761),
                     (0.24313725490196078, 0.93981, 0.93981), (0.24705882352941178, 0.93161, 0.93161),
                     (0.25098039215686274, 0.92305, 0.92305), (0.2549019607843137, 0.91416, 0.91416),
                     (0.2588235294117647, 0.90496, 0.90496), (0.2627450980392157, 0.8955, 0.8955),
                     (0.26666666666666666, 0.8858, 0.8858), (0.27058823529411763, 0.8759, 0.8759),
                     (0.27450980392156865, 0.86581, 0.86581), (0.2784313725490196, 0.85559, 0.85559),
                     (0.2823529411764706, 0.84525, 0.84525), (0.28627450980392155, 0.83484, 0.83484),
                     (0.2901960784313725, 0.82437, 0.82437), (0.29411764705882354, 0.81389, 0.81389),
                     (0.2980392156862745, 0.80342, 0.80342), (0.30196078431372547, 0.79299, 0.79299),
                     (0.3058823529411765, 0.78264, 0.78264), (0.30980392156862746, 0.7724, 0.7724),
                     (0.3137254901960784, 0.7623, 0.7623), (0.3176470588235294, 0.75237, 0.75237),
                     (0.32156862745098036, 0.74265, 0.74265), (0.3254901960784314, 0.73316, 0.73316),
                     (0.32941176470588235, 0.72393, 0.72393), (0.3333333333333333, 0.715, 0.715),
                     (0.33725490196078434, 0.70599, 0.70599), (0.3411764705882353, 0.69651, 0.69651),
                     (0.34509803921568627, 0.6866, 0.6866), (0.34901960784313724, 0.67627, 0.67627),
                     (0.3529411764705882, 0.66556, 0.66556), (0.3568627450980392, 0.65448, 0.65448),
                     (0.3607843137254902, 0.64308, 0.64308), (0.36470588235294116, 0.63137, 0.63137),
                     (0.3686274509803922, 0.61938, 0.61938), (0.37254901960784315, 0.60713, 0.60713),
                     (0.3764705882352941, 0.59466, 0.59466), (0.3803921568627451, 0.58199, 0.58199),
                     (0.38431372549019605, 0.56914, 0.56914), (0.38823529411764707, 0.55614, 0.55614),
                     (0.39215686274509803, 0.54303, 0.54303), (0.396078431372549, 0.52981, 0.52981),
                     (0.4, 0.51653, 0.51653), (0.403921568627451, 0.50321, 0.50321),
                     (0.40784313725490196, 0.48987, 0.48987), (0.4117647058823529, 0.47654, 0.47654),
                     (0.4156862745098039, 0.46325, 0.46325), (0.4196078431372549, 0.45002, 0.45002),
                     (0.4235294117647059, 0.43688, 0.43688), (0.42745098039215684, 0.42386, 0.42386),
                     (0.43137254901960786, 0.41098, 0.41098), (0.43529411764705883, 0.39826, 0.39826),
                     (0.4392156862745098, 0.38575, 0.38575), (0.44313725490196076, 0.37345, 0.37345),
                     (0.44705882352941173, 0.3614, 0.3614), (0.45098039215686275, 0.34963, 0.34963),
                     (0.4549019607843137, 0.33816, 0.33816), (0.4588235294117647, 0.32701, 0.32701),
                     (0.4627450980392157, 0.31622, 0.31622), (0.4666666666666667, 0.30581, 0.30581),
                     (0.47058823529411764, 0.29581, 0.29581), (0.4745098039215686, 0.28623, 0.28623),
                     (0.4784313725490196, 0.27712, 0.27712), (0.4823529411764706, 0.26849, 0.26849),
                     (0.48627450980392156, 0.26038, 0.26038), (0.49019607843137253, 0.2528, 0.2528),
                     (0.49411764705882355, 0.24579, 0.24579), (0.4980392156862745, 0.23937, 0.23937),
                     (0.5019607843137255, 0.23356, 0.23356), (0.5058823529411764, 0.22835, 0.22835),
                     (0.5098039215686274, 0.2237, 0.2237), (0.5137254901960784, 0.2196, 0.2196),
                     (0.5176470588235293, 0.21602, 0.21602), (0.5215686274509804, 0.21294, 0.21294),
                     (0.5254901960784314, 0.21032, 0.21032), (0.5294117647058824, 0.20815, 0.20815),
                     (0.5333333333333333, 0.2064, 0.2064), (0.5372549019607843, 0.20504, 0.20504),
                     (0.5411764705882353, 0.20406, 0.20406), (0.5450980392156862, 0.20343, 0.20343),
                     (0.5490196078431373, 0.20311, 0.20311), (0.5529411764705883, 0.2031, 0.2031),
                     (0.5568627450980392, 0.20336, 0.20336), (0.5607843137254902, 0.20386, 0.20386),
                     (0.5647058823529412, 0.20459, 0.20459), (0.5686274509803921, 0.20552, 0.20552),
                     (0.5725490196078431, 0.20663, 0.20663), (0.5764705882352941, 0.20788, 0.20788),
                     (0.580392156862745, 0.20926, 0.20926), (0.5843137254901961, 0.21074, 0.21074),
                     (0.5882352941176471, 0.2123, 0.2123), (0.592156862745098, 0.21391, 0.21391),
                     (0.596078431372549, 0.21555, 0.21555), (0.6, 0.21719, 0.21719),
                     (0.6039215686274509, 0.2188, 0.2188), (0.6078431372549019, 0.22038, 0.22038),
                     (0.611764705882353, 0.22188, 0.22188), (0.615686274509804, 0.22328, 0.22328),
                     (0.6196078431372549, 0.22456, 0.22456), (0.6235294117647059, 0.2257, 0.2257),
                     (0.6274509803921569, 0.22667, 0.22667), (0.6313725490196078, 0.22744, 0.22744),
                     (0.6352941176470588, 0.228, 0.228), (0.6392156862745098, 0.22831, 0.22831),
                     (0.6431372549019607, 0.22836, 0.22836), (0.6470588235294118, 0.22811, 0.22811),
                     (0.6509803921568628, 0.22754, 0.22754), (0.6549019607843137, 0.22663, 0.22663),
                     (0.6588235294117647, 0.22536, 0.22536), (0.6627450980392157, 0.22369, 0.22369),
                     (0.6666666666666666, 0.22161, 0.22161), (0.6705882352941176, 0.21918, 0.21918),
                     (0.6745098039215687, 0.2165, 0.2165), (0.6784313725490196, 0.21358, 0.21358),
                     (0.6823529411764706, 0.21043, 0.21043), (0.6862745098039216, 0.20706, 0.20706),
                     (0.6901960784313725, 0.20348, 0.20348), (0.6941176470588235, 0.19971, 0.19971),
                     (0.6980392156862745, 0.19577, 0.19577), (0.7019607843137254, 0.19165, 0.19165),
                     (0.7058823529411764, 0.18738, 0.18738), (0.7098039215686275, 0.18297, 0.18297),
                     (0.7137254901960784, 0.17842, 0.17842), (0.7176470588235294, 0.17376, 0.17376),
                     (0.7215686274509804, 0.16899, 0.16899), (0.7254901960784313, 0.16412, 0.16412),
                     (0.7294117647058823, 0.15918, 0.15918), (0.7333333333333333, 0.15417, 0.15417),
                     (0.7372549019607844, 0.1491, 0.1491), (0.7411764705882353, 0.14398, 0.14398),
                     (0.7450980392156863, 0.13883, 0.13883), (0.7490196078431373, 0.13367, 0.13367),
                     (0.7529411764705882, 0.12849, 0.12849), (0.7568627450980392, 0.12332, 0.12332),
                     (0.7607843137254902, 0.11817, 0.11817), (0.7647058823529411, 0.11305, 0.11305),
                     (0.7686274509803921, 0.10797, 0.10797), (0.7725490196078432, 0.10294, 0.10294),
                     (0.7764705882352941, 0.09798, 0.09798), (0.7803921568627451, 0.0931, 0.0931),
                     (0.7843137254901961, 0.08831, 0.08831), (0.788235294117647, 0.08362, 0.08362),
                     (0.792156862745098, 0.07905, 0.07905), (0.796078431372549, 0.07461, 0.07461),
                     (0.8, 0.07031, 0.07031), (0.803921568627451, 0.06616, 0.06616),
                     (0.807843137254902, 0.06218, 0.06218), (0.8117647058823529, 0.05837, 0.05837),
                     (0.8156862745098039, 0.05475, 0.05475), (0.8196078431372549, 0.05134, 0.05134),
                     (0.8235294117647058, 0.04814, 0.04814), (0.8274509803921568, 0.04516, 0.04516),
                     (0.8313725490196078, 0.04243, 0.04243), (0.8352941176470589, 0.03993, 0.03993),
                     (0.8392156862745098, 0.03753, 0.03753), (0.8431372549019608, 0.03521, 0.03521),
                     (0.8470588235294118, 0.03297, 0.03297), (0.8509803921568627, 0.03082, 0.03082),
                     (0.8549019607843137, 0.02875, 0.02875), (0.8588235294117647, 0.02677, 0.02677),
                     (0.8627450980392157, 0.02487, 0.02487), (0.8666666666666667, 0.02305, 0.02305),
                     (0.8705882352941177, 0.02131, 0.02131), (0.8745098039215686, 0.01966, 0.01966),
                     (0.8784313725490196, 0.01809, 0.01809), (0.8823529411764706, 0.0166, 0.0166),
                     (0.8862745098039215, 0.0152, 0.0152), (0.8901960784313725, 0.01387, 0.01387),
                     (0.8941176470588235, 0.01264, 0.01264), (0.8980392156862745, 0.01148, 0.01148),
                     (0.9019607843137255, 0.01041, 0.01041), (0.9058823529411765, 0.00942, 0.00942),
                     (0.9098039215686274, 0.00851, 0.00851), (0.9137254901960784, 0.00769, 0.00769),
                     (0.9176470588235294, 0.00695, 0.00695), (0.9215686274509803, 0.00629, 0.00629),
                     (0.9254901960784314, 0.00571, 0.00571), (0.9294117647058824, 0.00522, 0.00522),
                     (0.9333333333333333, 0.00481, 0.00481), (0.9372549019607843, 0.00449, 0.00449),
                     (0.9411764705882353, 0.00424, 0.00424), (0.9450980392156862, 0.00408, 0.00408),
                     (0.9490196078431372, 0.00401, 0.00401), (0.9529411764705882, 0.00401, 0.00401),
                     (0.9568627450980391, 0.0041, 0.0041), (0.9607843137254902, 0.00427, 0.00427),
                     (0.9647058823529412, 0.00453, 0.00453), (0.9686274509803922, 0.00486, 0.00486),
                     (0.9725490196078431, 0.00529, 0.00529), (0.9764705882352941, 0.00579, 0.00579),
                     (0.9803921568627451, 0.00638, 0.00638), (0.984313725490196, 0.00705, 0.00705),
                     (0.9882352941176471, 0.0078, 0.0078), (0.9921568627450981, 0.00863, 0.00863),
                     (0.996078431372549, 0.00955, 0.00955), (1.0, 0.01055, 0.01055)],
             'green':[(0.0, 0.07176, 0.07176), (0.00392156862745098, 0.08339, 0.08339),
                      (0.00784313725490196, 0.09498, 0.09498), (0.011764705882352941, 0.10652, 0.10652),
                      (0.01568627450980392, 0.11802, 0.11802), (0.0196078431372549, 0.12947, 0.12947),
                      (0.023529411764705882, 0.14087, 0.14087), (0.027450980392156862, 0.15223, 0.15223),
                      (0.03137254901960784, 0.16354, 0.16354), (0.03529411764705882, 0.17481, 0.17481),
                      (0.0392156862745098, 0.18603, 0.18603), (0.043137254901960784, 0.1972, 0.1972),
                      (0.047058823529411764, 0.20833, 0.20833), (0.050980392156862744, 0.21941, 0.21941),
                      (0.054901960784313725, 0.23044, 0.23044), (0.058823529411764705, 0.24143, 0.24143),
                      (0.06274509803921569, 0.25237, 0.25237), (0.06666666666666667, 0.26327, 0.26327),
                      (0.07058823529411765, 0.27412, 0.27412), (0.07450980392156863, 0.28492, 0.28492),
                      (0.0784313725490196, 0.29568, 0.29568), (0.08235294117647059, 0.30639, 0.30639),
                      (0.08627450980392157, 0.31706, 0.31706), (0.09019607843137255, 0.32768, 0.32768),
                      (0.09411764705882353, 0.33825, 0.33825), (0.09803921568627451, 0.34878, 0.34878),
                      (0.10196078431372549, 0.35926, 0.35926), (0.10588235294117647, 0.3697, 0.3697),
                      (0.10980392156862745, 0.38008, 0.38008), (0.11372549019607843, 0.39043, 0.39043),
                      (0.11764705882352941, 0.40072, 0.40072), (0.12156862745098039, 0.41097, 0.41097),
                      (0.12549019607843137, 0.42118, 0.42118), (0.12941176470588234, 0.43134, 0.43134),
                      (0.13333333333333333, 0.44145, 0.44145), (0.13725490196078433, 0.45152, 0.45152),
                      (0.1411764705882353, 0.46153, 0.46153), (0.14509803921568626, 0.47151, 0.47151),
                      (0.14901960784313725, 0.48144, 0.48144), (0.15294117647058825, 0.49132, 0.49132),
                      (0.1568627450980392, 0.50115, 0.50115), (0.16078431372549018, 0.51094, 0.51094),
                      (0.16470588235294117, 0.52069, 0.52069), (0.16862745098039217, 0.5304, 0.5304),
                      (0.17254901960784313, 0.54015, 0.54015), (0.1764705882352941, 0.54995, 0.54995),
                      (0.1803921568627451, 0.55979, 0.55979), (0.1843137254901961, 0.56967, 0.56967),
                      (0.18823529411764706, 0.57958, 0.57958), (0.19215686274509802, 0.5895, 0.5895),
                      (0.19607843137254902, 0.59943, 0.59943), (0.2, 0.60937, 0.60937),
                      (0.20392156862745098, 0.61931, 0.61931), (0.20784313725490194, 0.62923, 0.62923),
                      (0.21176470588235294, 0.63913, 0.63913), (0.21568627450980393, 0.64901, 0.64901),
                      (0.2196078431372549, 0.65886, 0.65886), (0.22352941176470587, 0.66866, 0.66866),
                      (0.22745098039215686, 0.67842, 0.67842), (0.23137254901960785, 0.68812, 0.68812),
                      (0.23529411764705882, 0.69775, 0.69775), (0.2392156862745098, 0.70732, 0.70732),
                      (0.24313725490196078, 0.7168, 0.7168), (0.24705882352941178, 0.7262, 0.7262),
                      (0.25098039215686274, 0.73551, 0.73551), (0.2549019607843137, 0.74472, 0.74472),
                      (0.2588235294117647, 0.75381, 0.75381), (0.2627450980392157, 0.76279, 0.76279),
                      (0.26666666666666666, 0.77165, 0.77165), (0.27058823529411763, 0.78037, 0.78037),
                      (0.27450980392156865, 0.78896, 0.78896), (0.2784313725490196, 0.7974, 0.7974),
                      (0.2823529411764706, 0.80569, 0.80569), (0.28627450980392155, 0.81381, 0.81381),
                      (0.2901960784313725, 0.82177, 0.82177), (0.29411764705882354, 0.82955, 0.82955),
                      (0.2980392156862745, 0.83714, 0.83714), (0.30196078431372547, 0.84455, 0.84455),
                      (0.3058823529411765, 0.85175, 0.85175), (0.30980392156862746, 0.85875, 0.85875),
                      (0.3137254901960784, 0.86554, 0.86554), (0.3176470588235294, 0.87211, 0.87211),
                      (0.32156862745098036, 0.87844, 0.87844), (0.3254901960784314, 0.88454, 0.88454),
                      (0.32941176470588235, 0.8904, 0.8904), (0.3333333333333333, 0.896, 0.896),
                      (0.33725490196078434, 0.90142, 0.90142), (0.3411764705882353, 0.90673, 0.90673),
                      (0.34509803921568627, 0.91193, 0.91193), (0.34901960784313724, 0.91701, 0.91701),
                      (0.3529411764705882, 0.92197, 0.92197), (0.3568627450980392, 0.9268, 0.9268),
                      (0.3607843137254902, 0.93151, 0.93151), (0.36470588235294116, 0.93609, 0.93609),
                      (0.3686274509803922, 0.94053, 0.94053), (0.37254901960784315, 0.94484, 0.94484),
                      (0.3764705882352941, 0.94901, 0.94901), (0.3803921568627451, 0.95304, 0.95304),
                      (0.38431372549019605, 0.95692, 0.95692), (0.38823529411764707, 0.96065, 0.96065),
                      (0.39215686274509803, 0.96423, 0.96423), (0.396078431372549, 0.96765, 0.96765),
                      (0.4, 0.97092, 0.97092), (0.403921568627451, 0.97403, 0.97403),
                      (0.40784313725490196, 0.97697, 0.97697), (0.4117647058823529, 0.97974, 0.97974),
                      (0.4156862745098039, 0.98234, 0.98234), (0.4196078431372549, 0.98477, 0.98477),
                      (0.4235294117647059, 0.98702, 0.98702), (0.42745098039215684, 0.98909, 0.98909),
                      (0.43137254901960786, 0.99098, 0.99098), (0.43529411764705883, 0.99268, 0.99268),
                      (0.4392156862745098, 0.99419, 0.99419), (0.44313725490196076, 0.99551, 0.99551),
                      (0.44705882352941173, 0.99663, 0.99663), (0.45098039215686275, 0.99755, 0.99755),
                      (0.4549019607843137, 0.99828, 0.99828), (0.4588235294117647, 0.99879, 0.99879),
                      (0.4627450980392157, 0.9991, 0.9991), (0.4666666666666667, 0.99919, 0.99919),
                      (0.47058823529411764, 0.99907, 0.99907), (0.4745098039215686, 0.99873, 0.99873),
                      (0.4784313725490196, 0.99817, 0.99817), (0.4823529411764706, 0.99739, 0.99739),
                      (0.48627450980392156, 0.99638, 0.99638), (0.49019607843137253, 0.99514, 0.99514),
                      (0.49411764705882355, 0.99366, 0.99366), (0.4980392156862745, 0.99195, 0.99195),
                      (0.5019607843137255, 0.98999, 0.98999), (0.5058823529411764, 0.98775, 0.98775),
                      (0.5098039215686274, 0.98524, 0.98524), (0.5137254901960784, 0.98246, 0.98246),
                      (0.5176470588235293, 0.97941, 0.97941), (0.5215686274509804, 0.9761, 0.9761),
                      (0.5254901960784314, 0.97255, 0.97255), (0.5294117647058824, 0.96875, 0.96875),
                      (0.5333333333333333, 0.9647, 0.9647), (0.5372549019607843, 0.96043, 0.96043),
                      (0.5411764705882353, 0.95593, 0.95593), (0.5450980392156862, 0.95121, 0.95121),
                      (0.5490196078431373, 0.94627, 0.94627), (0.5529411764705883, 0.94113, 0.94113),
                      (0.5568627450980392, 0.93579, 0.93579), (0.5607843137254902, 0.93025, 0.93025),
                      (0.5647058823529412, 0.92452, 0.92452), (0.5686274509803921, 0.91861, 0.91861),
                      (0.5725490196078431, 0.91253, 0.91253), (0.5764705882352941, 0.90627, 0.90627),
                      (0.580392156862745, 0.89986, 0.89986), (0.5843137254901961, 0.89328, 0.89328),
                      (0.5882352941176471, 0.88655, 0.88655), (0.592156862745098, 0.87968, 0.87968),
                      (0.596078431372549, 0.87267, 0.87267), (0.6, 0.86553, 0.86553),
                      (0.6039215686274509, 0.85826, 0.85826), (0.6078431372549019, 0.85087, 0.85087),
                      (0.611764705882353, 0.84337, 0.84337), (0.615686274509804, 0.83576, 0.83576),
                      (0.6196078431372549, 0.82806, 0.82806), (0.6235294117647059, 0.82025, 0.82025),
                      (0.6274509803921569, 0.81236, 0.81236), (0.6313725490196078, 0.80439, 0.80439),
                      (0.6352941176470588, 0.79634, 0.79634), (0.6392156862745098, 0.78823, 0.78823),
                      (0.6431372549019607, 0.78005, 0.78005), (0.6470588235294118, 0.77181, 0.77181),
                      (0.6509803921568628, 0.76352, 0.76352), (0.6549019607843137, 0.75519, 0.75519),
                      (0.6588235294117647, 0.74682, 0.74682), (0.6627450980392157, 0.73842, 0.73842),
                      (0.6666666666666666, 0.73, 0.73), (0.6705882352941176, 0.7214, 0.7214),
                      (0.6745098039215687, 0.7125, 0.7125), (0.6784313725490196, 0.7033, 0.7033),
                      (0.6823529411764706, 0.69382, 0.69382), (0.6862745098039216, 0.68408, 0.68408),
                      (0.6901960784313725, 0.67408, 0.67408), (0.6941176470588235, 0.66386, 0.66386),
                      (0.6980392156862745, 0.65341, 0.65341), (0.7019607843137254, 0.64277, 0.64277),
                      (0.7058823529411764, 0.63193, 0.63193), (0.7098039215686275, 0.62093, 0.62093),
                      (0.7137254901960784, 0.60977, 0.60977), (0.7176470588235294, 0.59846, 0.59846),
                      (0.7215686274509804, 0.58703, 0.58703), (0.7254901960784313, 0.57549, 0.57549),
                      (0.7294117647058823, 0.56386, 0.56386), (0.7333333333333333, 0.55214, 0.55214),
                      (0.7372549019607844, 0.54036, 0.54036), (0.7411764705882353, 0.52854, 0.52854),
                      (0.7450980392156863, 0.51667, 0.51667), (0.7490196078431373, 0.50479, 0.50479),
                      (0.7529411764705882, 0.49291, 0.49291), (0.7568627450980392, 0.48104, 0.48104),
                      (0.7607843137254902, 0.4692, 0.4692), (0.7647058823529411, 0.4574, 0.4574),
                      (0.7686274509803921, 0.44565, 0.44565), (0.7725490196078432, 0.43399, 0.43399),
                      (0.7764705882352941, 0.42241, 0.42241), (0.7803921568627451, 0.41093, 0.41093),
                      (0.7843137254901961, 0.39958, 0.39958), (0.788235294117647, 0.38836, 0.38836),
                      (0.792156862745098, 0.37729, 0.37729), (0.796078431372549, 0.36638, 0.36638),
                      (0.8, 0.35566, 0.35566), (0.803921568627451, 0.34513, 0.34513),
                      (0.807843137254902, 0.33482, 0.33482), (0.8117647058823529, 0.32473, 0.32473),
                      (0.8156862745098039, 0.31489, 0.31489), (0.8196078431372549, 0.3053, 0.3053),
                      (0.8235294117647058, 0.29599, 0.29599), (0.8274509803921568, 0.28696, 0.28696),
                      (0.8313725490196078, 0.27824, 0.27824), (0.8352941176470589, 0.26981, 0.26981),
                      (0.8392156862745098, 0.26152, 0.26152), (0.8431372549019608, 0.25334, 0.25334),
                      (0.8470588235294118, 0.24526, 0.24526), (0.8509803921568627, 0.2373, 0.2373),
                      (0.8549019607843137, 0.22945, 0.22945), (0.8588235294117647, 0.2217, 0.2217),
                      (0.8627450980392157, 0.21407, 0.21407), (0.8666666666666667, 0.20654, 0.20654),
                      (0.8705882352941177, 0.19912, 0.19912), (0.8745098039215686, 0.19182, 0.19182),
                      (0.8784313725490196, 0.18462, 0.18462), (0.8823529411764706, 0.17753, 0.17753),
                      (0.8862745098039215, 0.17055, 0.17055), (0.8901960784313725, 0.16368, 0.16368),
                      (0.8941176470588235, 0.15693, 0.15693), (0.8980392156862745, 0.15028, 0.15028),
                      (0.9019607843137255, 0.14374, 0.14374), (0.9058823529411765, 0.13731, 0.13731),
                      (0.9098039215686274, 0.13098, 0.13098), (0.9137254901960784, 0.12477, 0.12477),
                      (0.9176470588235294, 0.11867, 0.11867), (0.9215686274509803, 0.11268, 0.11268),
                      (0.9254901960784314, 0.1068, 0.1068), (0.9294117647058824, 0.10102, 0.10102),
                      (0.9333333333333333, 0.09536, 0.09536), (0.9372549019607843, 0.0898, 0.0898),
                      (0.9411764705882353, 0.08436, 0.08436), (0.9450980392156862, 0.07902, 0.07902),
                      (0.9490196078431372, 0.0738, 0.0738), (0.9529411764705882, 0.06868, 0.06868),
                      (0.9568627450980391, 0.06367, 0.06367), (0.9607843137254902, 0.05878, 0.05878),
                      (0.9647058823529412, 0.05399, 0.05399), (0.9686274509803922, 0.04931, 0.04931),
                      (0.9725490196078431, 0.04474, 0.04474), (0.9764705882352941, 0.04028, 0.04028),
                      (0.9803921568627451, 0.03593, 0.03593), (0.984313725490196, 0.03169, 0.03169),
                      (0.9882352941176471, 0.02756, 0.02756), (0.9921568627450981, 0.02354, 0.02354),
                      (0.996078431372549, 0.01963, 0.01963), (1.0, 0.01583, 0.01583)],
             'red':[(0.0, 0.18995, 0.18995), (0.00392156862745098, 0.19483, 0.19483),
                    (0.00784313725490196, 0.19956, 0.19956), (0.011764705882352941, 0.20415, 0.20415),
                    (0.01568627450980392, 0.2086, 0.2086), (0.0196078431372549, 0.21291, 0.21291),
                    (0.023529411764705882, 0.21708, 0.21708), (0.027450980392156862, 0.22111, 0.22111),
                    (0.03137254901960784, 0.225, 0.225), (0.03529411764705882, 0.22875, 0.22875),
                    (0.0392156862745098, 0.23236, 0.23236), (0.043137254901960784, 0.23582, 0.23582),
                    (0.047058823529411764, 0.23915, 0.23915), (0.050980392156862744, 0.24234, 0.24234),
                    (0.054901960784313725, 0.24539, 0.24539), (0.058823529411764705, 0.2483, 0.2483),
                    (0.06274509803921569, 0.25107, 0.25107), (0.06666666666666667, 0.25369, 0.25369),
                    (0.07058823529411765, 0.25618, 0.25618), (0.07450980392156863, 0.25853, 0.25853),
                    (0.0784313725490196, 0.26074, 0.26074), (0.08235294117647059, 0.2628, 0.2628),
                    (0.08627450980392157, 0.26473, 0.26473), (0.09019607843137255, 0.26652, 0.26652),
                    (0.09411764705882353, 0.26816, 0.26816), (0.09803921568627451, 0.26967, 0.26967),
                    (0.10196078431372549, 0.27103, 0.27103), (0.10588235294117647, 0.27226, 0.27226),
                    (0.10980392156862745, 0.27334, 0.27334), (0.11372549019607843, 0.27429, 0.27429),
                    (0.11764705882352941, 0.27509, 0.27509), (0.12156862745098039, 0.27576, 0.27576),
                    (0.12549019607843137, 0.27628, 0.27628), (0.12941176470588234, 0.27667, 0.27667),
                    (0.13333333333333333, 0.27691, 0.27691), (0.13725490196078433, 0.27701, 0.27701),
                    (0.1411764705882353, 0.27698, 0.27698), (0.14509803921568626, 0.2768, 0.2768),
                    (0.14901960784313725, 0.27648, 0.27648), (0.15294117647058825, 0.27603, 0.27603),
                    (0.1568627450980392, 0.27543, 0.27543), (0.16078431372549018, 0.27469, 0.27469),
                    (0.16470588235294117, 0.27381, 0.27381), (0.16862745098039217, 0.27273, 0.27273),
                    (0.17254901960784313, 0.27106, 0.27106), (0.1764705882352941, 0.26878, 0.26878),
                    (0.1803921568627451, 0.26592, 0.26592), (0.1843137254901961, 0.26252, 0.26252),
                    (0.18823529411764706, 0.25862, 0.25862), (0.19215686274509802, 0.25425, 0.25425),
                    (0.19607843137254902, 0.24946, 0.24946), (0.2, 0.24427, 0.24427),
                    (0.20392156862745098, 0.23874, 0.23874), (0.20784313725490194, 0.23288, 0.23288),
                    (0.21176470588235294, 0.22676, 0.22676), (0.21568627450980393, 0.22039, 0.22039),
                    (0.2196078431372549, 0.21382, 0.21382), (0.22352941176470587, 0.20708, 0.20708),
                    (0.22745098039215686, 0.20021, 0.20021), (0.23137254901960785, 0.19326, 0.19326),
                    (0.23529411764705882, 0.18625, 0.18625), (0.2392156862745098, 0.17923, 0.17923),
                    (0.24313725490196078, 0.17223, 0.17223), (0.24705882352941178, 0.16529, 0.16529),
                    (0.25098039215686274, 0.15844, 0.15844), (0.2549019607843137, 0.15173, 0.15173),
                    (0.2588235294117647, 0.14519, 0.14519), (0.2627450980392157, 0.13886, 0.13886),
                    (0.26666666666666666, 0.13278, 0.13278), (0.27058823529411763, 0.12698, 0.12698),
                    (0.27450980392156865, 0.12151, 0.12151), (0.2784313725490196, 0.11639, 0.11639),
                    (0.2823529411764706, 0.11167, 0.11167), (0.28627450980392155, 0.10738, 0.10738),
                    (0.2901960784313725, 0.10357, 0.10357), (0.29411764705882354, 0.10026, 0.10026),
                    (0.2980392156862745, 0.0975, 0.0975), (0.30196078431372547, 0.09532, 0.09532),
                    (0.3058823529411765, 0.09377, 0.09377), (0.30980392156862746, 0.09287, 0.09287),
                    (0.3137254901960784, 0.09267, 0.09267), (0.3176470588235294, 0.0932, 0.0932),
                    (0.32156862745098036, 0.09451, 0.09451), (0.3254901960784314, 0.09662, 0.09662),
                    (0.32941176470588235, 0.09958, 0.09958), (0.3333333333333333, 0.10342, 0.10342),
                    (0.33725490196078434, 0.10815, 0.10815), (0.3411764705882353, 0.11374, 0.11374),
                    (0.34509803921568627, 0.12014, 0.12014), (0.34901960784313724, 0.12733, 0.12733),
                    (0.3529411764705882, 0.13526, 0.13526), (0.3568627450980392, 0.14391, 0.14391),
                    (0.3607843137254902, 0.15323, 0.15323), (0.36470588235294116, 0.16319, 0.16319),
                    (0.3686274509803922, 0.17377, 0.17377), (0.37254901960784315, 0.18491, 0.18491),
                    (0.3764705882352941, 0.19659, 0.19659), (0.3803921568627451, 0.20877, 0.20877),
                    (0.38431372549019605, 0.22142, 0.22142), (0.38823529411764707, 0.23449, 0.23449),
                    (0.39215686274509803, 0.24797, 0.24797), (0.396078431372549, 0.2618, 0.2618),
                    (0.4, 0.27597, 0.27597), (0.403921568627451, 0.29042, 0.29042),
                    (0.40784313725490196, 0.30513, 0.30513), (0.4117647058823529, 0.32006, 0.32006),
                    (0.4156862745098039, 0.33517, 0.33517), (0.4196078431372549, 0.35043, 0.35043),
                    (0.4235294117647059, 0.36581, 0.36581), (0.42745098039215684, 0.38127, 0.38127),
                    (0.43137254901960786, 0.39678, 0.39678), (0.43529411764705883, 0.41229, 0.41229),
                    (0.4392156862745098, 0.42778, 0.42778), (0.44313725490196076, 0.44321, 0.44321),
                    (0.44705882352941173, 0.45854, 0.45854), (0.45098039215686275, 0.47375, 0.47375),
                    (0.4549019607843137, 0.48879, 0.48879), (0.4588235294117647, 0.50362, 0.50362),
                    (0.4627450980392157, 0.51822, 0.51822), (0.4666666666666667, 0.53255, 0.53255),
                    (0.47058823529411764, 0.54658, 0.54658), (0.4745098039215686, 0.56026, 0.56026),
                    (0.4784313725490196, 0.57357, 0.57357), (0.4823529411764706, 0.58646, 0.58646),
                    (0.48627450980392156, 0.59891, 0.59891), (0.49019607843137253, 0.61088, 0.61088),
                    (0.49411764705882355, 0.62233, 0.62233), (0.4980392156862745, 0.63323, 0.63323),
                    (0.5019607843137255, 0.64362, 0.64362), (0.5058823529411764, 0.65394, 0.65394),
                    (0.5098039215686274, 0.66428, 0.66428), (0.5137254901960784, 0.67462, 0.67462),
                    (0.5176470588235293, 0.68494, 0.68494), (0.5215686274509804, 0.69525, 0.69525),
                    (0.5254901960784314, 0.70553, 0.70553), (0.5294117647058824, 0.71577, 0.71577),
                    (0.5333333333333333, 0.72596, 0.72596), (0.5372549019607843, 0.7361, 0.7361),
                    (0.5411764705882353, 0.74617, 0.74617), (0.5450980392156862, 0.75617, 0.75617),
                    (0.5490196078431373, 0.76608, 0.76608), (0.5529411764705883, 0.77591, 0.77591),
                    (0.5568627450980392, 0.78563, 0.78563), (0.5607843137254902, 0.79524, 0.79524),
                    (0.5647058823529412, 0.80473, 0.80473), (0.5686274509803921, 0.8141, 0.8141),
                    (0.5725490196078431, 0.82333, 0.82333), (0.5764705882352941, 0.83241, 0.83241),
                    (0.580392156862745, 0.84133, 0.84133), (0.5843137254901961, 0.8501, 0.8501),
                    (0.5882352941176471, 0.85868, 0.85868), (0.592156862745098, 0.86709, 0.86709),
                    (0.596078431372549, 0.8753, 0.8753), (0.6, 0.88331, 0.88331),
                    (0.6039215686274509, 0.89112, 0.89112), (0.6078431372549019, 0.8987, 0.8987),
                    (0.611764705882353, 0.90605, 0.90605), (0.615686274509804, 0.91317, 0.91317),
                    (0.6196078431372549, 0.92004, 0.92004), (0.6235294117647059, 0.92666, 0.92666),
                    (0.6274509803921569, 0.93301, 0.93301), (0.6313725490196078, 0.93909, 0.93909),
                    (0.6352941176470588, 0.94489, 0.94489), (0.6392156862745098, 0.95039, 0.95039),
                    (0.6431372549019607, 0.9556, 0.9556), (0.6470588235294118, 0.96049, 0.96049),
                    (0.6509803921568628, 0.96507, 0.96507), (0.6549019607843137, 0.96931, 0.96931),
                    (0.6588235294117647, 0.97323, 0.97323), (0.6627450980392157, 0.97679, 0.97679),
                    (0.6666666666666666, 0.98, 0.98), (0.6705882352941176, 0.98289, 0.98289),
                    (0.6745098039215687, 0.98549, 0.98549), (0.6784313725490196, 0.98781, 0.98781),
                    (0.6823529411764706, 0.98986, 0.98986), (0.6862745098039216, 0.99163, 0.99163),
                    (0.6901960784313725, 0.99314, 0.99314), (0.6941176470588235, 0.99438, 0.99438),
                    (0.6980392156862745, 0.99535, 0.99535), (0.7019607843137254, 0.99607, 0.99607),
                    (0.7058823529411764, 0.99654, 0.99654), (0.7098039215686275, 0.99675, 0.99675),
                    (0.7137254901960784, 0.99672, 0.99672), (0.7176470588235294, 0.99644, 0.99644),
                    (0.7215686274509804, 0.99593, 0.99593), (0.7254901960784313, 0.99517, 0.99517),
                    (0.7294117647058823, 0.99419, 0.99419), (0.7333333333333333, 0.99297, 0.99297),
                    (0.7372549019607844, 0.99153, 0.99153), (0.7411764705882353, 0.98987, 0.98987),
                    (0.7450980392156863, 0.98799, 0.98799), (0.7490196078431373, 0.9859, 0.9859),
                    (0.7529411764705882, 0.9836, 0.9836), (0.7568627450980392, 0.98108, 0.98108),
                    (0.7607843137254902, 0.97837, 0.97837), (0.7647058823529411, 0.97545, 0.97545),
                    (0.7686274509803921, 0.97234, 0.97234), (0.7725490196078432, 0.96904, 0.96904),
                    (0.7764705882352941, 0.96555, 0.96555), (0.7803921568627451, 0.96187, 0.96187),
                    (0.7843137254901961, 0.95801, 0.95801), (0.788235294117647, 0.95398, 0.95398),
                    (0.792156862745098, 0.94977, 0.94977), (0.796078431372549, 0.94538, 0.94538),
                    (0.8, 0.94084, 0.94084), (0.803921568627451, 0.93612, 0.93612),
                    (0.807843137254902, 0.93125, 0.93125), (0.8117647058823529, 0.92623, 0.92623),
                    (0.8156862745098039, 0.92105, 0.92105), (0.8196078431372549, 0.91572, 0.91572),
                    (0.8235294117647058, 0.91024, 0.91024), (0.8274509803921568, 0.90463, 0.90463),
                    (0.8313725490196078, 0.89888, 0.89888), (0.8352941176470589, 0.89298, 0.89298),
                    (0.8392156862745098, 0.88691, 0.88691), (0.8431372549019608, 0.88066, 0.88066),
                    (0.8470588235294118, 0.87422, 0.87422), (0.8509803921568627, 0.8676, 0.8676),
                    (0.8549019607843137, 0.86079, 0.86079), (0.8588235294117647, 0.8538, 0.8538),
                    (0.8627450980392157, 0.84662, 0.84662), (0.8666666666666667, 0.83926, 0.83926),
                    (0.8705882352941177, 0.83172, 0.83172), (0.8745098039215686, 0.82399, 0.82399),
                    (0.8784313725490196, 0.81608, 0.81608), (0.8823529411764706, 0.80799, 0.80799),
                    (0.8862745098039215, 0.79971, 0.79971), (0.8901960784313725, 0.79125, 0.79125),
                    (0.8941176470588235, 0.7826, 0.7826), (0.8980392156862745, 0.77377, 0.77377),
                    (0.9019607843137255, 0.76476, 0.76476), (0.9058823529411765, 0.75556, 0.75556),
                    (0.9098039215686274, 0.74617, 0.74617), (0.9137254901960784, 0.73661, 0.73661),
                    (0.9176470588235294, 0.72686, 0.72686), (0.9215686274509803, 0.71692, 0.71692),
                    (0.9254901960784314, 0.7068, 0.7068), (0.9294117647058824, 0.6965, 0.6965),
                    (0.9333333333333333, 0.68602, 0.68602), (0.9372549019607843, 0.67535, 0.67535),
                    (0.9411764705882353, 0.66449, 0.66449), (0.9450980392156862, 0.65345, 0.65345),
                    (0.9490196078431372, 0.64223, 0.64223), (0.9529411764705882, 0.63082, 0.63082),
                    (0.9568627450980391, 0.61923, 0.61923), (0.9607843137254902, 0.60746, 0.60746),
                    (0.9647058823529412, 0.5955, 0.5955), (0.9686274509803922, 0.58336, 0.58336),
                    (0.9725490196078431, 0.57103, 0.57103), (0.9764705882352941, 0.55852, 0.55852),
                    (0.9803921568627451, 0.54583, 0.54583), (0.984313725490196, 0.53295, 0.53295),
                    (0.9882352941176471, 0.51989, 0.51989), (0.9921568627450981, 0.50664, 0.50664),
                    (0.996078431372549, 0.49321, 0.49321), (1.0, 0.4796, 0.4796)]
             }
