# -*- coding: utf-8 -*-

import sys
import os
sys.path.append(os.path.dirname(os.path.abspath(__file__)) + '/Tool')
import ExtMath
import numpy as np
import math

class FreeSliceData:
    def  __init__(self):
         self.visible = True
         self.org = [0.0, 0.0, 0.0]
         self.x   = [0.0, 0.0, 0.0]
         self.y   = [0.0, 0.0, 0.0]
         self.xbin = 0.0
         self.ybin = 0.0
         self.rangex = [0.0, 0.0]
         self.rangey = [0.0, 0.0]
         self.thickness = 0.0
         self.xdiff = 0.0
         self.ydiff = 0.0
         self.zdiff = 1.0

         # test for ***short
         self.org = [-2.0, -2.0, 10.0]
         self.x   = [13.0, -2.0, -5.0]
         self.y   = [13.0, 13.0, 25.0]

         self.xbin = 0.04
         self.ybin = 0.04
         self.rangex = [0, 10]
         self.rangey = [0, 10]
         self.thickness = 1.5

         self.extMath = ExtMath.ExtMath()

    def getNormalVector(self):
        vecX = np.array(self.x) - np.array(self.org)
        vecY = np.array(self.y) - np.array(self.org)

        normal = np.cross(vecX, vecY)
        len = math.sqrt(normal[0]*normal[0] + normal[1]*normal[1] + normal[2]*normal[2])
        normal /= len

        return normal

    def shiftPlaneAlongNormalVector(self, len, roundFlag, roundPos):
        normal = self.getNormalVector()
        vec = normal * len
        self.shiftPlane(vec[0], vec[1], vec[2], roundFlag, roundPos)

    def shiftPlane(self, xdiff, ydiff, zdiff, roundFlag, roundPos):
        self.org[0] += xdiff
        self.org[1] += ydiff
        self.org[2] += zdiff

        self.x[0] += xdiff
        self.x[1] += ydiff
        self.x[2] += zdiff

        self.y[0] += xdiff
        self.y[1] += ydiff
        self.y[2] += zdiff

        if roundFlag:
            self.org[0] = round(self.org[0], roundPos)
            self.org[1] = round(self.org[1], roundPos)
            self.org[2] = round(self.org[2], roundPos)
            self.x[0] = round(self.x[0], roundPos)
            self.x[1] = round(self.x[1], roundPos)
            self.x[2] = round(self.x[2], roundPos)
            self.y[0] = round(self.y[0], roundPos)
            self.y[1] = round(self.y[1], roundPos)
            self.y[2] = round(self.y[2], roundPos)


    def getPlaneAngle(self):
        vecX = np.array(self.x) - np.array(self.org)
        vecY = np.array(self.y) - np.array(self.org)

        ang = (self.extMath.getAngle(vecX, vecY).item())
        return ang

    def checkPlaneAngle(self):
        vecX = np.array(self.x) - np.array(self.org)
        vecY = np.array(self.y) - np.array(self.org)

        ang = self.getPlaneAngle()
        delta = ang - math.pi/2.0
        eps = 1e-6
        if eps < math.fabs(delta):
            return False
        else:
            return True



