# SliceViewer3D

## 動作確認環境
2023/8/2現在での動作確認した環境を記す。

### Ubuntu 22.04
PySide6(6.5.2, pip) + pyqtgraph(0.13.x, pip)環境でのみ使用できた。

```
$ sudo apt install python3-opengl
$ python3 -m pip install PySide6
$ python3 -m pip install pyqtgraph
```

### Ubuntu 20.04
PySide2(5.14.0, deb)環境では、インストールするpyqtgraphのバージョンを選べば(0.12.3)使用できた。

```
$ sudo apt install python3-opengl
$ python3 -m pip install pyqtgraph==0.12.3
```

## 起動
ターミナルから直接起動する場合。

```
$ python3 /path/to/SliceViewer3D.py
```

Pythonインタプリタから起動する場合。

```
$ python3
>>> import uGao.SliceViewer3D as SV3
>>> p = SV3.SliceViewer()
```


## 開発者向け情報

### 動作しなかった環境
2023/8/2現在での動作確認して問題のあった環境を記す。

- Ubuntu 22.04
    - PySide6とpyqtgraphをpipでインストールすると動作する。
    - PySide2(5.15.2, deb) + pyqtgraph(0.12.3, pip)では、GUIのレイアウトが崩れてしまい使えない。
    - PySide2(5.15.2, deb) + pyqtgraph(0.13.x, pip)では、下記のエラーで起動しない。

```
libshiboken6.abi3.so.6.5: cannot open shared object file: No such file or directory
```

- Ubuntu 20.04
    - pyqtgraphの新しいバージョン(0.13.x)ではnumpy(deb)とのバージョン衝突が起きるので空蝉とは共存しにくい。
    - pyqtgraphのバージョンが0.12.4だと、Z軸方向のデータプロットが上下さかさまになる現象が発生した。0.12.3であれば大丈夫。
