# Writing and reading binary file with Boost C++ library.
# This sample script will create a file, "test.bin".

import Manyo

# Preparing Manyo-Lib data container 
e1 = Manyo.ElementContainer()
m1 = Manyo.ElementContainerMatrix()
vec = Manyo.MakeDoubleVector( 100 )
for i in range( 100 ):
    e1.Add( "x"+str(i), vec )
# Preparing data container finished


# Making the class object of the wrapper of file I/O. 
Mout = Manyo.WriteSerializationFileBinary( "test.bin" )

# writing data containers.
# You can write many data objects into a file,
# but you shoud read the file in the correct sequence.
Mout.Save( e1 )
Mout.Save( m1 )
# close data file.
del( Mout )


# Reading the data file wrote in above lines.

# Making the class object of the wrapper of file I/O.
Min = Manyo.ReadSerializationFileBinary( "test.bin" )

# Making data objects for reading data file.
e1r = Manyo.ElementContainer()
m1r = Manyo.ElementContainerMatrix()

# Reading data files.
Min.Load( e1r )
Min.Load( m1r )
del( Min )

# show the contants in the data container.
e1r.Dump()

