/*
$Id: UInt4ContainerMatrix.hh 2182 2010-09-30 07:56:20Z jisuzuki $
*/


#ifndef UINT4CONTAINERMATRIX
#define UINT4CONTAINERMATRIX

#include "Header.hh"
#include "NeutronVector.hh"
#include "UInt4Container.hh"
#include "UInt4ContainerArray.hh"
#include "ElementContainerMatrix.hh"

//! Data container for a set of UInt4ContainerArray-s and HeaderBase.
/*! This class is data container class like "ElementContainerMatrix".
  Functionalities of class methods in this class is similar to
  the methods of "ElementContainerMatrix". See the manual of "ElementContainerMatrix".
 */

class UInt4ContainerMatrix
  : public NeutronVector< UInt4ContainerArray, HeaderBase >
{
public:
  using NeutronVector< UInt4ContainerArray, HeaderBase >::operator();

  UInt4ContainerMatrix();
  UInt4ContainerMatrix( HeaderBase pheader );
  UInt4ContainerMatrix( const NeutronVector< UInt4ContainerArray, HeaderBase > &ob );

  UInt4ContainerArray* operator[]( UInt4 index );
  UInt4Container*      operator()( UInt4 Mindex, UInt4 Aindex );
  std::vector<UInt4>*       operator()( UInt4 Mindex, UInt4 Aindex, UInt4 Cindex );
  std::vector<UInt4>*       operator()( UInt4 Mindex, UInt4 Aindex, std::string Key );

  ElementContainerMatrix ConvertIntoElementContainerMatrix();
};

#endif
