/*
$Id: UInt4ContainerMatrix.cc 2256 2011-05-30 04:43:47Z jisuzuki $
*/


#include "UInt4ContainerMatrix.hh"
////////////////////////////////////
UInt4ContainerMatrix::
UInt4ContainerMatrix()
{
}
////////////////////////////////////
UInt4ContainerMatrix::
UInt4ContainerMatrix( HeaderBase pheader )
  :  NeutronVector<UInt4ContainerArray,HeaderBase>( pheader )
     //  :: NeutronVector<UInt4ContainerArray,HeaderBase>( pheader )
{
}
////////////////////////////////////
UInt4ContainerMatrix::
UInt4ContainerMatrix( const NeutronVector< UInt4ContainerArray, HeaderBase > &ob )
  :  NeutronVector<UInt4ContainerArray,HeaderBase>( ob )
     //  :: NeutronVector<UInt4ContainerArray,HeaderBase>( ob )
{
}
////////////////////////////////////
UInt4ContainerArray*
UInt4ContainerMatrix::
operator[]( UInt4 index )
{
  return PutPointer( index );
}
////////////////////////////////////
UInt4Container*
UInt4ContainerMatrix::
operator()( UInt4 Mindex, UInt4 Aindex )
{
  return PutPointer( Mindex ) -> PutPointer( Aindex );
}
////////////////////////////////////
std::vector<UInt4>*
UInt4ContainerMatrix::
operator()( UInt4 Mindex, UInt4 Aindex, UInt4 Cindex )
{
  return ( *( PutPointer( Mindex ) -> PutPointer( Aindex ) ) )[ Cindex ];
}
////////////////////////////////////
std::vector<UInt4>*
UInt4ContainerMatrix::
operator()( UInt4 Mindex, UInt4 Aindex, std::string Key )
{
  return ( *( PutPointer( Mindex ) -> PutPointer( Aindex ) ) )[ Key ];
}
////////////////////////////////////
ElementContainerMatrix
UInt4ContainerMatrix::
ConvertIntoElementContainerMatrix()
{
  ElementContainerMatrix m;
  m.InputHeader( PutHeader() );

  UInt4 Usize = PutSize();
  for( UInt4 i=0; i<Usize; i++ ){
    m.Add( PutPointer( i ) -> ConvertIntoElementContainerArray() );
  }
  return m;
}
////////////////////////////////////
