%include "NeutronVector.hh"
%include "OperatorBase.hh"
%include "ManipulatorBase.hh"
%include "NeutronReadBinaryData.hh"
%include "HeaderBase.hh"
%include "ElementContainer.hh"
%include "Map.hh"
%include "NeutronWriteBinaryData.hh"
%include "GslHistogram.hh"
%include "ReadSerializationFile.hh"
%include "WriteSerializationFile.hh"
%include "WriteNeXusFile.hh"


%template (EleConArr)  NeutronVector< ElementContainer, HeaderBase >;
%template (EleConMat)  NeutronVector< ElementContainerArray, HeaderBase >;
%template (UIntConArr)  NeutronVector< UInt4Container, HeaderBase >;
%template (UIntConMat)  NeutronVector< UInt4ContainerArray, HeaderBase >;

%template (MapString) Map< std::string >;
%template (MapUInt4)  Map< UInt4 >;
%template (MapInt4)   Map< Int4 >;
%template (MapDouble) Map< Double >;

%template (MapStringVector) Map< std::vector<std::string> >;
%template (MapUInt4Vector)  Map< std::vector<UInt4> >;
%template (MapInt4Vector)   Map< std::vector<Int4> >;
%template (MapDoubleVector) Map< std::vector<Double> >;

%template (OperatorBaseElementContainerElementContainer) OperatorBase< ElementContainer, ElementContainer >;
%template (OperatorBaseElementContainerDoubleVector) OperatorBase< ElementContainer, std::vector<Double> >;
%template (OperatorBaseDoubleVectorDoubleVector) OperatorBase< std::vector<Double>, std::vector<Double> >;
%template (ManipulatorBaseElementContainer)       ManipulatorBase< ElementContainer >;
%template (ManipulatorBaseElementContainerArray)  ManipulatorBase< ElementContainerArray >;
%template (ManipulatorBaseElementContainerMatrix) ManipulatorBase< ElementContainerMatrix >;
%template (OperatorBaseElementContainerMatrixElementContainerArray) OperatorBase< ElementContainerMatrix, ElementContainerArray >;
%template (OperatorBaseMatrixContainer) OperatorBase<ElementContainerMatrix,ElementContainer>;
%template (OperaterBaseElementContainerArrayElementContainerArray) OperatorBase<ElementContainerArray,ElementContainerArray>;
%template (OperaterBaseElementContainerMatrixElementContainerMatrix) OperatorBase<ElementContainerMatrix,ElementContainerMatrix>;

%template (NeutronWriteBinaryDataUInt4) NeutronWriteBinaryData<UInt4>;
%template (NeutronWriteBinaryDataDouble) NeutronWriteBinaryData<Double>;



##
## binary/text/xml format for Read/Write serialization classes
##
%template (WriteSerializationFileBinary)   WriteSerializationFile<boost::archive::binary_oarchive> ;
%template (ReadSerializationFileBinary)   ReadSerializationFile<boost::archive::binary_iarchive> ;
%template (WriteSerializationFileText)   WriteSerializationFile<boost::archive::text_oarchive> ;
%template (ReadSerializationFileText)   ReadSerializationFile<boost::archive::text_iarchive> ;
%template (WriteSerializationFileXml)   WriteSerializationFile<boost::archive::xml_oarchive> ;
%template (ReadSerializationFileXml)   ReadSerializationFile<boost::archive::xml_iarchive> ;


##
## WriteNeXusFile::WriteData(string, T) template method
##
%extend WriteNeXusFile {
	%template(WriteHeaderBase)				WriteData<HeaderBase>;
	%template(WriteElementContainer)		WriteData<ElementContainer>;
	%template(WriteElementContainerArray)	WriteData<ElementContainerArray>;
	%template(WriteElementContainerMatrix)	WriteData<ElementContainerMatrix>;
	%template(WriteUInt4Container)			WriteData<UInt4Container>;
	%template(WriteUInt4ContainerArray)		WriteData<UInt4ContainerArray>;
	%template(WriteUInt4ContainerMatrix)	WriteData<UInt4ContainerMatrix>;
};

%template(pairdd) std::pair<Double,Double>;

