/*
$Id: SwapBytes.hh 1562 2006-06-08 10:27:20Z suzuki $
*/


#ifndef SWAPBYTES_HH
#define SWAPBYTES_HH
#include "Header.hh"
//!Converter for binary data into Intel CPU format.
/*!
If you use Intel CPU or compatible,
the binary data array read from disks should be convert
by this class.
Because the converted data array
overwrites the source array,
You can delete the object of this class just after
calling swap().

When you use this class, you must define data type
as following,
\code
SwapBytes<UInt4>    *converter1 = new SwapBytes<UInt4>    //for integer
\endcode
*/
template <class T>
class SwapBytes
{
private:
  UChar *u;
public:
  SwapBytes();
  /*!<Constructor. You should define data type handled
    in this class as above example.*/
  ~SwapBytes();
  /*!<Destructor.*/
  void swap( T * pBuffer, UInt8 BufferLength );
  /*!<Execute the conversion.
    The argument of "pBuffer" is the pointer
    of array converted in this function,
    and "BufferLength" is the size of the array.
    The converted data array overwrites the old data.
  */
};

#include "SwapBytes.cc"

#endif

