/*
$Id: SplitString.hh 1562 2006-06-08 10:27:20Z suzuki $
*/


#ifndef SPLITSTRING
#define SPLITSTRING
#include "Header.hh"

//! Split a string with the delimiter std::string key into an array.
/*! An input string of "Source" is splited by "SplitKey".
  "SplitKey" is used as the delimiter string.
  The "PutSize()" should be called just after getting
  the array to get its size.

  Dynamic arrays produced in this class should
  be delete in the user functions, because
  this class does not have the delete function.
  In most cases, the arrays will be installed into
  data containers, and they have already possessed
  the delete functions.
 */

class SplitString
{
private:
  //std::string *list;
  //UInt4 ListSize;
  //void MakeTemp(  std::string Source, std::string SplitKey );
protected:

public:
  SplitString();
  /*!<Constructor, this method does not have the argument.
   */
 ~SplitString();
  /*!< Destructor. This method should be called
    at the end of  using this class.
   */

  std::vector<std::string> Split( std::string Source, std::string SplitKey )
  { return PutStringArray( Source, SplitKey ); }

  std::vector<UInt4> PutUInt4( std::string Source, std::string SplitKey )
  { return PutUInt4Array( Source,SplitKey ); }

  std::vector<Double> PutDouble( std::string Source, std::string SplitKey )
  { return PutDoubleArray( Source,SplitKey );}

  std::vector<std::string> PutStringArray( std::string Source, std::string SplitKey );
  /*!<Split the std::string of the first argument and return
    an string type array. "SplitKey" is used as a delimiter string.
    The size of the array can be gotton from "PutSize()",
    it should be called just after executing of this method.
    If spaces exist at the ends of the each std::string,
    this method will delete them.
    */
  std::vector<std::string> PutStringArrayWithSpace( std::string Source, std::string SplitKey );

  std::vector<Int2> PutInt2Array( std::string Source, std::string SplitKey );
  /*!<Split the std::string of the first argument and return
    an Int2 type array. "SplitKey" is used as a delimiter string.
    The size of the array can be gotton from "PutSize()",
    it should be called just after executing of this method. */
  std::vector<Int4> PutInt4Array(   std::string Source, std::string SplitKey );
  /*!<Split the std::string of the first argument and return
    an Int4 type array. "SplitKey" is used as a delimiter string.
    The size of the array can be gotton from "PutSize()",
    it should be called just after executing of this method. */
  std::vector<UInt2> PutUInt2Array(  std::string Source, std::string SplitKey );
  /*!<Split the std::string of the first argument and return
    an UInt2 type array. "SplitKey" is used as a delimiter string.
    The size of the array can be gotton from "PutSize()",
    it should be called just after executing of this method. */
  std::vector<UInt4> PutUInt4Array(  std::string Source, std::string SplitKey );
  /*!<Split the std::string of the first argument and return
    an UInt4 type array. "SplitKey" is used as a delimiter string.
    The size of the array can be gotton from "PutSize()",
    it should be called just after executing of this method. */
  std::vector<Float> PutFloatArray(  std::string Source, std::string SplitKey );
  /*!<Split the std::string of the first argument and return
    an Float type array. "SplitKey" is used as a delimiter string.
    The size of the array can be gotton from "PutSize()",
    it should be called just after executing of this method. */
  std::vector<Double> PutDoubleArray( std::string Source, std::string SplitKey );
  /*!<Split the std::string of the first argument and return
    an Double type array. "SplitKey" is used as a delimiter string.
    The size of the array can be gotton from "PutSize()",
    it should be called just after executing of this method. */
};

#endif
