#ifndef SIMPLEIOVECTORTOTEXTFILE
#define SIMPLEIOVECTORTOTEXTFILE

#include <iomanip>
#include "Header.hh"
#include "HeaderBase.hh"
#include "StringTools.hh"
/////////////////////////////////////
// SimpleIOVectorToTextFile
////////////////////////////////////
//! Convert Header and 3 double vectors into a text file.
/*!
 * This writes a text file from header information
 * and 3 double vectors.
 * This is normaly used as one of methods on ElementContainer.
 */
class SimpleIOVectorToTextFile
{
private:
  int flag_target;     /**<0:no SetTarget, 1:3 vectors are given, 2: header+3std::vectors
                           3:4 vectors are given, 4: header+4std::vectors*/
  std::vector<Double> Avec; /**< Additional std::vector */
  std::vector<Double> Xvec; /**< X-kye std::vector */
  std::vector<Double> Yvec; /**< Y-kye std::vector */
  std::vector<Double> Evec; /**< E-kye std::vector */
  HeaderBase HB;       /**< HeaderBase information */
  StringTools *ST;     /**< Tools to treat String */
  Int4 DefNumOfFigures;  /**< default of the number of figures to output  */

public:
  SimpleIOVectorToTextFile();
    //!< Constructor
    /*!<
     */
  ~SimpleIOVectorToTextFile();
    //!< Destructor
    /*!<
     */
  void SetTarget( HeaderBase hh, std::vector<Double> xvec, std::vector<Double> yvec, std::vector<Double> evec, bool isHist=false );
    //!< Set information to be written to a text file
    /*!<
     *   @param hh   (HeaderBase)
     *   @param xvec (std::vector<Double>)
     *   @param yvec (std::vector<Double>)
     *   @param evec (std::vector<Double>)
     *   @param isHist (bool)
     *   @retval None
     */
  void SetTarget( std::vector<Double> xvec, std::vector<Double> yvec, std::vector<Double> evec, bool isHist=false );
    //!< Set information to be written to a text file
    /*!<
     *   @param xvec (std::vector<Double>)
     *   @param yvec (std::vector<Double>)
     *   @param evec (std::vector<Double>)
     *   @param isHist (bool)
     *   @retval None
     */
  void SetTarget( std::vector<Double> avec, std::vector<Double> xvec, std::vector<Double> yvec, std::vector<Double> evec );
    //!< Set information to be written to a text file
    /*!<
     *   @param avec (std::vector<Double>)
     *   @param xvec (std::vector<Double>)
     *   @param yvec (std::vector<Double>)
     *   @param evec (std::vector<Double>)
     *   @retval None
     */
  void SetTarget( HeaderBase hh, std::vector<Double> avec, std::vector<Double> xvec, std::vector<Double> yvec, std::vector<Double> evec );
    //!< Set information to be written to a text file
    /*!<
     *   @param hh   (HeaderBase)
     *   @param avec (std::vector<Double>)
     *   @param xvec (std::vector<Double>)
     *   @param yvec (std::vector<Double>)
     *   @param evec (std::vector<Double>)
     *   @retval None
     */
  void SetTarget( Double a, std::vector<Double> xvec, std::vector<Double> yvec, std::vector<Double> evec );
    //!< Set information to be written to a text file
    /*!<
     *   @param a    (Double)
     *   @param xvec (std::vector<Double>)
     *   @param yvec (std::vector<Double>)
     *   @param evec (std::vector<Double>)
     *   @retval None
     */
  void SetTarget( HeaderBase hh, Double a, std::vector<Double> xvec, std::vector<Double> yvec, std::vector<Double> evec );
    //!< Set information to be written to a text file
    /*!<
     *   @param hh   (HeaderBase)
     *   @param a    (Double)
     *   @param xvec (std::vector<Double>)
     *   @param yvec (std::vector<Double>)
     *   @param evec (std::vector<Double>)
     *   @retval None
     */

  void SaveFile( std::string _filename );
  void SaveFile( std::string _filename, Int4 _prec );
  void SaveFile( std::string _filename, Char _deli );
  void SaveFile( std::string _filename, Int4 _prec, Char _deli );
    //!< Save a text file named _filename
    /*!<
     *   @param _filename (std::string)
     *   @param _prec (Int4)
     *   @param _deli (Char)
     *   @retval None
     */
  void LoadFile( std::string _filename );
    //!< Load data from a text file named _filename
    /*!<
     *   @param _filename (std::string)
     *   @retval None
     */
  std::vector<Double> PutX(){ return Xvec; }
    //!< Put X-key double std::vector
    /*!<
     *   @retval std::vector<Double>
     */
  std::vector<Double> PutY(){ return Yvec; }
    //!< Put Y-key double std::vector
    /*!<
     *   @retval std::vector<Double>
     */
  std::vector<Double> PutE(){ return Evec; }
    //!< Put E-key double std::vector
    /*!<
     *   @retval std::vector<Double>
     */

};
#endif
