/*
$Id: NeutronWriteBinaryData.cc 1562 2006-06-08 10:27:20Z suzuki $
*/


#include "NeutronWriteBinaryData.hh"

#ifndef  NEUTRONWRITEBINARYDATA_CC
#define  NEUTRONWRITEBINARYDATA_CC

///////////////////////////////////////////////////
template <class T>
NeutronWriteBinaryData<T>::
NeutronWriteBinaryData()
{
}
///////////////////////////////////////////////////
template <class T>
NeutronWriteBinaryData<T>::
~NeutronWriteBinaryData()
{
}
///////////////////////////////////////////////////
template <class T>
void NeutronWriteBinaryData<T>::
Write( T* array, UInt4 size, std::string FileName )
{
  FILE *fin;
  if( ( fin = fopen( FileName.c_str(), "w" ) ) == NULL ){
    std::cout << "Can not open the output-file." << std::endl;
    return;
  }
  else{
    size_t s = std::fwrite( array, sizeof(T), size, fin );
    if( (UInt4)(s) != size ){
      std::cout << "NeutronWriteBinaryData::Write(T*,UInt4,std::string)" << std::endl;
      std::cout << "Failed to write in std::fwrite(......)" << std::endl;
    }
    fclose( fin );
  }
}
///////////////////////////////////////////////////
template <class T>
void NeutronWriteBinaryData<T>::
Write( std::vector<T> v, std::string FileName )
{
  UInt4 size = (UInt4)(v.size());
  T* array = new T[size];

  for( UInt4 i=0; i<size; i++ ){
    array[i] = v[i];
  }

  Write( array, size, FileName );
  delete [] array;
}
///////////////////////////////////////////////////
#endif
