/*
$Id: ElementContainerAppendError.cc 1562 2006-06-08 10:27:20Z suzuki $
*/


#include "ElementContainerAppendError.hh"
////////////////////////////////////////////
ElementContainerAppendError::
ElementContainerAppendError( Double _ErrorValue )
{
  ErrorValue = _ErrorValue;
}
////////////////////////////////////////////
ElementContainerAppendError::
~ElementContainerAppendError()
{
}
////////////////////////////////////////////
void ElementContainerAppendError::
Append( ElementContainer *_target, std::string _CountsKey, std::string _ErrorKey )
{
  SetTarget( _target );
  CountsKey  = _CountsKey;
  ErrorKey   = _ErrorKey;

  if( Target -> CheckKey( CountsKey ) !=1 ){
    return;
  }

  std::vector<Double> Counts = Target -> Put( CountsKey );
  UInt4 size = (UInt4)(Counts.size());
  std::vector<Double> Error( size );

  for( UInt4 i=0; i<size; i++ ){
    if( Counts[i] <= 0.0 ){
      Error[i] = ErrorValue;
    }
    else{
      Error[i] = sqrt( Counts[i] );
    }
  }
  Target -> Add( ErrorKey, Error );
}
////////////////////////////////////////////
