/*
$Id: CppToPython.hh 2350 2012-03-11 02:27:01Z tito $
*/


#ifndef CPPTOPYTHON
#define CPPTOPYTHON

#include "Header.hh"

//! Connector between Python and C++ environment.
/*!
  This class is applied to data-converter between Python
  and C++ environment. "PyObject*", Python-list, tuple,
  double, int etc, can be accessed
  on C++ environment.
  The access speed to Python-Object in C++ environment
  is faster than that in Python environment.
  If you want to pass large Python-object from C++ to Python,
  it should be manipulated in C++ environment with this class.
 */

class CppToPython
{
public:
  CppToPython();
  /*!< Constructor.*/
 ~CppToPython();
  /*!< Destructor.*/

  PyObject *MakeIntList( UInt4 size=0 );
  /*!< Returns a python list object,
   and its each value is integer. */

  PyObject *VectorUInt4ToList( std::vector<UInt4> v );
  /*!< This method converts from a vector<UInt4> object into a python
   list object.*/
  std::vector<UInt4> ListToUInt4Vector( PyObject *List );
  /*!< This method converts from a python list object into
   a vector<UInt4> object.*/
  std::vector<UInt4> *ListToUInt4VectorP( PyObject *List );
  /*!< This method converts from a python list object
   into a vector<UInt4> dynamically-object.*/

  PyObject *VectorInt4ToList( std::vector<Int4> v );
  /*!< This method converts from a vector<Int4> object into a python
   list object.*/
  std::vector<Int4> ListToInt4Vector( PyObject *List );
  /*!< This method converts from a python list object into
   a vector<Int4> object.*/
  std::vector<Int4> *ListToInt4VectorP( PyObject *List );
  /*!< This method converts from a python list object
   into a vector<UInt4> dynamically-object.*/

  PyObject *VectorStringToList( std::vector<std::string> v );
  /*!< This method converts from a vector<std::string> object into a python
   list object.*/
  std::vector<std::string> ListToStringVector( PyObject *List );
  /*!< This method converts from a python list object into
   a vector<std::string> object.*/
  std::vector<std::string> *ListToStringVectorP( PyObject *List );
  /*!< This method converts from a python list object
   into a vector<std::string> dynamically-object.*/

  PyObject *VectorToList( std::vector<UInt4>  v ){ return VectorUInt4ToList(v); }
  /*!< Alias of VectorUInt4ToList(v).*/
  PyObject *VectorToList( std::vector<Int4>   v ){ return VectorInt4ToList(v); }
  /*!< Alias of VectorInt4ToList(v).*/
  PyObject *VectorToList( std::vector<Double> v ){ return VectorDoubleToList(v); }
  /*!< Alias of VectorDoubleToList(v).*/

  PyObject *MakeDoubleList( UInt4 size=0 );
  /*!<
    This method returns a Python-List
    whose element data-type is double.
    The argument of the integer is
    the size of the Python-list produced in this method.
    The value of each element is set as zero.
   */

  PyObject *VectorDoubleToList( std::vector<Double> v );
  /*!<
    Converts from a STL-vector to a Python-List.
    The data-type of the vector- and list-elements are "Double".
  */

  std::vector<Double> ListToDoubleVector( PyObject *List );
  /*!<
    This method returns "std::vector<Double>" converted from
    the argument of a Python-List.
    The type of the argument of this method is PyObject*.
    If the type of it is not Python-list, the warning message
    is sent to the standard-output, and a STL-vector whose size is zero
    will be returned to avoid problems.
  */

  std::vector<Double> *ListToDoubleVectorP( PyObject *List );
  /*!<
    This method returns "std::vector<Double>*" converted from
    the argument of a Python-List.
    The type of the argument of this method is PyObject*.
    If the type of it is not Python-list, the warning message
    is sent to the standard-output, and a STL-vector whose size is zero
    will be returned to avoid problems.
  */

  std::vector< std::vector<Int4> > ListToInt4VectorVector( PyObject *List ); //<-> Ito,T [20120311]
  /*!< This method converts from a python list object into
   a vector< std::vector<Int4> > object.*/
};

static CppToPython  __gCppToPython;
/*!< global object */

#endif
