/*
$Id: OnLineGnuPlot.cc 1925 2008-04-17 02:39:14Z jisuzuki $
 */

#include "OnLineGnuPlot.hh"
/////////////////////////////////////////////////////////////
OnLineGnuPlot::
OnLineGnuPlot( std::string command ){
  gi = new GnuplotInterface( command );
  dat = new std::vector< std::vector<GslHistogram*>*>();
  st = new StringTools();
}
/////////////////////////////////////////////////////////////
OnLineGnuPlot::
~OnLineGnuPlot(){
  delete gi;
  for( UInt4 i=0; i<dat->size(); i++ ){
    delete ( *dat )[i];
  }
  delete st;
}
/////////////////////////////////////////////////////////////
void OnLineGnuPlot::
SetGrayColor(){
  gi->e( "set palette gray" );
}
/////////////////////////////////////////
void OnLineGnuPlot::
SetDataObj( std::vector<GslHistogram*> *data,
            std::vector< std::vector< UInt4 > > dim ){
  for( UInt4 i=0; i<dim.size(); i++ ){
    std::vector<UInt4> v = dim[i];
    std::vector<GslHistogram*> *g = new std::vector<GslHistogram*>();
    for( UInt4 j=0; j<v.size(); j++ ){
      UInt4 target = v[j];
      GslHistogram *gh = ( *data )[target];
      g->push_back( gh );
    }
    dat->push_back( g );
  }
}
/////////////////////////////////////////////////////////////
void OnLineGnuPlot::
SetDataObj( std::vector<GslHistogram*> *data,
            UInt4 x, UInt4 y ){
  UInt4 Counter = 0;
  std::vector< std::vector< UInt4 > > dim;
  for( UInt4 i=0; i<x; i++ ){
    std::vector<UInt4> v;
    for( UInt4 j=0; j<y; j++ ){
      v.push_back( Counter++ );
    }
    dim.push_back( v );
  }
  SetDataObj( data, dim );
}
/////////////////////////////////////////////////////////////
void OnLineGnuPlot::
MapPlot(){
  mplot();
  for( UInt4 i=0; i<dat->size(); i++ ){
    std::vector<GslHistogram*> *a = ( *dat )[i];

    for( UInt4 j=0; j<a->size(); j++ ){
      GslHistogram *el = ( *a )[j];
      double value = el->PutHistogramSum();
      gi->e( st->UInt4ToString(j) + " " +
             st->UInt4ToString(i) + " " +
             st->DoubleToString( value ) );
      gi->e( st->UInt4ToString(j+1) + " " +
             st->UInt4ToString(i) + " " +
             st->DoubleToString( value ) );
    }
    gi->e( "" );
    for( UInt4 j=0; j<a->size(); j++ ){
      GslHistogram *el = ( *a )[j];
      double value = el->PutHistogramSum();
      gi->e( st->UInt4ToString(j) + " " +
             st->UInt4ToString(i+1) + " " +
             st->DoubleToString( value ) );
      gi->e( st->UInt4ToString(j+1) + " " +
             st->UInt4ToString(i+1) + " " +
             st->DoubleToString( value ) );
    }
    gi->e( "" );
  }
  gi->e( "e" );
}
/////////////////////////////////////////////////////////////
void OnLineGnuPlot::
SurfacePlot(){
  splot();
  for( UInt4 i=0; i<dat->size(); i++ ){
    std::vector<GslHistogram*> *a = ( *dat )[i];

    for( UInt4 j=0; j<a->size(); j++ ){
      GslHistogram *el = ( *a )[j];
      double value = el->PutHistogramSum();
      gi->e( st->UInt4ToString(j) + " " +
             st->UInt4ToString(i) + " " +
             st->DoubleToString( value ) );
      gi->e( st->UInt4ToString(j+1) + " " +
             st->UInt4ToString(i) + " " +
             st->DoubleToString( value ) );
    }
    gi->e( "" );
    for( UInt4 j=0; j<a->size(); j++ ){
      GslHistogram *el = ( *a )[j];
      double value = el->PutHistogramSum();
      gi->e( st->UInt4ToString(j) + " " +
             st->UInt4ToString(i+1) + " " +
             st->DoubleToString( value ) );
      gi->e( st->UInt4ToString(j+1) + " " +
             st->UInt4ToString(i+1) + " " +
             st->DoubleToString( value ) );
    }
    gi->e( "" );
  }
  gi->e( "e" );
}
/////////////////////////////////////////////////////////////
void OnLineGnuPlot::
MapPlot( UInt4 tof ){
  mplot();
  for( UInt4 i=0; i<dat->size(); i++ ){
    std::vector<GslHistogram*> *a = ( *dat )[i];

    for( UInt4 j=0; j<a->size(); j++ ){
      GslHistogram *el = ( *a )[j];
      double value = ( el->PutHistogram() )[tof];
      gi->e( st->UInt4ToString(j) + " " +
             st->UInt4ToString(i) + " " +
             st->DoubleToString( value ) );
      gi->e( st->UInt4ToString(j+1) + " " +
             st->UInt4ToString(i) + " " +
             st->DoubleToString( value ) );
    }
    gi->e( "" );
    for( UInt4 j=0; j<a->size(); j++ ){
      GslHistogram *el = ( *a )[j];
      double value = ( el->PutHistogram() )[tof];
      gi->e( st->UInt4ToString(j) + " " +
             st->UInt4ToString(i+1) + " " +
             st->DoubleToString( value ) );
      gi->e( st->UInt4ToString(j+1) + " " +
             st->UInt4ToString(i+1) + " " +
             st->DoubleToString( value ) );
    }
    gi->e( "" );
  }
  gi->e( "e" );
}
/////////////////////////////////////////////////////////////
void OnLineGnuPlot::
SurfacePlot( UInt4 tof ){
  splot();
  for( UInt4 i=0; i<dat->size(); i++ ){
    std::vector<GslHistogram*> *a = ( *dat )[i];

    for( UInt4 j=0; j<a->size(); j++ ){
      GslHistogram *el = ( *a )[j];
      double value = ( el->PutHistogram() )[tof];
      gi->e( st->UInt4ToString(j) + " " +
             st->UInt4ToString(i) + " " +
             st->DoubleToString( value ) );
      gi->e( st->UInt4ToString(j+1) + " " +
             st->UInt4ToString(i) + " " +
             st->DoubleToString( value ) );
    }
    gi->e( "" );
    for( UInt4 j=0; j<a->size(); j++ ){
      GslHistogram *el = ( *a )[j];
      double value = ( el->PutHistogram() )[tof];
      gi->e( st->UInt4ToString(j) + " " +
             st->UInt4ToString(i+1) + " " +
             st->DoubleToString( value ) );
      gi->e( st->UInt4ToString(j+1) + " " +
             st->UInt4ToString(i+1) + " " +
             st->DoubleToString( value ) );
    }
    gi->e( "" );
  }
  gi->e( "e" );
}
/////////////////////////////////////////////////////////////
void OnLineGnuPlot::
TofVsCounts( UInt4 Psd ){
  std::vector<GslHistogram*> *TargetPsd = ( *dat )[Psd];
  UInt4 TofBinNum=0;

  for( UInt4 i=0; i<TargetPsd->size(); i++ ){
    GslHistogram *TargetHist = ( *TargetPsd )[ i ];
    if( TofBinNum <= TargetHist->PutHistSize() ){
      TofBinNum = TargetHist->PutHistSize();
    }
  }

  std::vector<Double> *Sum = new std::vector<Double>( TofBinNum );
  for( UInt4 i=0; i<Sum->size(); i++ ){
    ( *Sum )[i] = 0.0;
  }

  for( UInt4 i=0; i<TargetPsd->size(); i++ ){
    GslHistogram *TargetHist = ( *TargetPsd )[ i ];
    std::vector<Double> CountValue = TargetHist->PutHistogram();

    for( UInt4 j=0; j<CountValue.size(); j++ ){
      Double t = (*Sum)[j];
      (*Sum)[j] = t + CountValue[j];
    }
  }

  gi->e( "set mouse" );
  gi->e( "plot '-' with impulse" );
  for( UInt4 i=0; i<Sum->size(); i++ ){
    gi->e( st->DoubleToString( ( *Sum )[i] ) );
  }

  gi->e( "e" );

  delete Sum;
}
/////////////////////////////////////////////////////////////
void OnLineGnuPlot::
mplot(){
  gi->e( "set mouse" );
  gi->e( "set pm3d map" );
  gi->e( "splot '-'" );
}
/////////////////////////////////////////
void OnLineGnuPlot::
splot(){
  gi->e( "set mouse" );
  gi->e( "set pm3d" );
  gi->e( "splot '-' with pm3d" );
}
/////////////////////////////////////////
