#include "MlfPhysicalConstants.hh"

const Double MLF_PI=abs(atan2(0.0, -1.0));
/*!<  neutron mass [kg]
 *    ref. NIST http://physics.nist.gov/cgi-bin/cuu/Value?mn
 */
const Double MLF_MASS_NEUTRON=1.674927471e-27;
const Double MLF_Mn=MLF_MASS_NEUTRON;
const std::string MLF_MASS_NEUTRON_UNIT="kg";
const std::string MLF_Mn_UNIT="kg";

/*!<  Planck constant h [Js]
 *    ref. NIST http://physics.nist.gov/cgi-bin/cuu/Value?h
 */
const Double MLF_PLANCK = 6.626070040e-34;
const std::string MLF_PLANCK_UNIT = "Js";

/*!<  h/2*Pi [Js]
 *    ref. NIST http://physics.nist.gov/cgi-bin/cuu/Value?hbar
 */
const Double MLF_HBAR=1.054571800e-34;
const std::string MLF_HBAR_UNIT="Js";

/*!<  Avogadro constant. [1/mol]
 *    ref. NIST http://physics.nist.gov/cgi-bin/cuu/Value?na
 */
const Double MLF_NA=6.022140857e23;
const std::string MLF_NA_UNIT="1/mol";

/*!<  Boltzmann constant [J/K].
 *    ref. NIST http://physics.nist.gov/cgi-bin/cuu/Value?k
 */
const Double MLF_kB=1.38064852e-23;
const std::string MLF_kB_UNIT="J/K";

/**** Unit Exchange ******/
//// mass ////
/** 1 [kg]=1000[g] */
const Double MLF_KG2G=1.0e+03;

//// length ////
/** 1 [mm] = 0.001 [m] */
const Double MLF_MM2M=1.0e-03;
/** 1 [m] = 1000[mm] */
const Double MLF_M2MM=1.0/MLF_MM2M;
/** 1 [Angstrom] = 1.0*10e-10[m] */
const Double MLF_ANGSTROM2M=1.0e-10;
/** 1 [m] = 1.0*10e+10 [Angstrom] */
const Double MLF_M2ANGSTROM=1.0/MLF_ANGSTROM2M;
/** 1 [fm] = 1.0*10e-15 [m] */
const Double MLF_FM2M=1.0e-15;
/** 1 [m] = 1.0*10e+15 [fm] */
const Double MLF_M2FM=1.0/MLF_FM2M;

//// time ////
/** 1[sec]=1.e+06[microsec] */
const Double MLF_SEC2MICROSEC=1.0e+06;
/** 1 [microsec] = 1.0e-6 [sec] */
const Double MLF_MICROSEC2SEC=1.0/MLF_SEC2MICROSEC;

//// energy ////

/*!<  1 [eV] = 1.60[j]
 *    ref. NIST http://physics.nist.gov/cgi-bin/cuu/Value?evj
 */
const Double MLF_EV2J=1.6021766208e-19;

const Double MLF_J2EV=1.0/MLF_EV2J;
/** 1 [meV] = 0.001 [eV] */
const Double MLF_MEV2J=MLF_EV2J*1.0e-03;
/** 1 [J] =  1.0/1.602 176 565(35) *1e+22 [eV] */
const Double MLF_J2MEV=1.0/MLF_MEV2J;

//// cross section ////
/** 1[b]=1.e-24[cm^2]=1.e-28[m^2].
 *  @see gsl/gsl_const_mksa.h GSL_CONST_MKSA_BARN
 */
const Double MLF_BARN2M2=GSL_CONST_MKSA_BARN;
/** 1 [m^2] = 1.0*10e+28 [b] */
const Double MLF_M22BARN=1.0/MLF_BARN2M2;

//// pressure ////
/** 1[atm] = 101325 [Pa].
 *  @see gsl/gsl_const_mksa.h GSL_CONST_MKSA_STD_ATMOSPHERE
 */
const Double MLF_ATM2PA=GSL_CONST_MKSA_STD_ATMOSPHERE;
/** 1[Pa] = 1.0/101325 [atom]. */
const Double MLF_PA2ATM=1.0/MLF_ATM2PA;

//// angle ////
/** 1 [degree] = PI/180 [radian] */
const Double MLF_DEGREE2RADIAN=MLF_PI/180.0;
/** 1 [rad] = 180/PI [degree] */
const Double MLF_RADIAN2DEGREE=1.0/MLF_DEGREE2RADIAN;


const Double MLF_MASKVALUE=1.0e+100;
