#include "EventDataMonitorBase.hh"
//////////////////////////////////////////
EventDataMonitorBase::
EventDataMonitorBase( size_t _ElementSize ){
  //CurrentPosition = 0;
  ElementSize = _ElementSize;
}
/////////////////////////////////////////
EventDataMonitorBase::
~EventDataMonitorBase(){
}
/////////////////////////////////////////
void EventDataMonitorBase::
ParameterSet( std::string _WireingFile,
              std::string _DetectorInfoFile )
{
  WireingFile = _WireingFile;
  DetectorInfoFile = _DetectorInfoFile;
}
/////////////////////////////////////////
Int8 EventDataMonitorBase::
Read( std::string TargetBinFile,
      Int8 FromBegin, Int8 SizeOfData, void *buf ){

  BinDataFileSectionReader *bf =
    new BinDataFileSectionReader( TargetBinFile, ElementSize );

  Int8 r = bf -> Read( FromBegin, SizeOfData, buf );
  delete bf;
  return r;
}
/////////////////////////////////////////
Int8 EventDataMonitorBase::
Read( std::string TargetBinFile, std::vector<UInt8> table, UChar *buf ){

  BinDataFileSectionReader *bf =
    new BinDataFileSectionReader( TargetBinFile, ElementSize );

  Int8 LastIndexOfTable=0;
  UInt8 IndexOfBuf=0;
  for (UInt4 i=1;i<table.size();i++){
      UInt8 SizeOfRead = table[i]-table[i-1];

      UChar* tmp = new UChar[ SizeOfRead*ElementSize ];
      Int8 r1 = bf -> Read( table[i-1], SizeOfRead, tmp );
      if (r1!=SizeOfRead){
          break;
      }
      for (UInt4 j=0;j<r1*ElementSize;j++) buf[IndexOfBuf+j]=tmp[j];
      IndexOfBuf += SizeOfRead*ElementSize;
      LastIndexOfTable=i;
      delete [] tmp;
  }

  delete bf;
  return LastIndexOfTable;
}
/////////////////////////////////////////
Int8 EventDataMonitorBase::
Read( std::vector<std::string> TargetBinFiles, std::vector<UInt8> table, UChar *buf ){
    Int8 LastIndexOfTable=0;
    UInt8 IndexOfBuf=0;
    UInt4 current_index =0;
    UInt4 offset = 0;
    bool isFinish = false;
    for (UInt4 i=0; i<TargetBinFiles.size(); i++){
        BinDataFileSectionReader *bf =
            new BinDataFileSectionReader( TargetBinFiles[i], ElementSize );
        //std::cout << "##### TargetBinFiles[i] = " << TargetBinFiles[i] << std::endl;
        //std::cout << "##### Read table[0],table[last]="<< table[0] << "," << table.back() << std::endl;
        while(true){
            UInt8 SizeOfRead = table[current_index+1]-table[current_index];
            UChar* tmp = new UChar[ SizeOfRead*ElementSize ];
            //std::cout << "##### Read table[current_index], offset="<< table[current_index] << "," << offset <<  std::endl;
            Int8 r1 = bf -> Read( table[current_index]-offset, SizeOfRead, tmp );
            if (r1==SizeOfRead){
                for (UInt4 j=0;j<r1*ElementSize;j++) buf[IndexOfBuf+j]=tmp[j];
                delete [] tmp;
                IndexOfBuf += SizeOfRead*(UInt8)ElementSize;

                current_index++;

                LastIndexOfTable=current_index;

            }else{
                for (UInt4 j=0;j<r1*ElementSize;j++) buf[IndexOfBuf+j]=tmp[j];
                delete [] tmp;
                IndexOfBuf += r1*(Int8)ElementSize;

                //table[current_index] += r1;
                //offset = table[current_index];
                offset += (UInt4)r1;

                isFinish = false;
                break;
            }
            if ((current_index+1)>=table.size()){
                isFinish = true;
                break;
            }
        }
        delete bf;
        if (isFinish) break;

    }

  return LastIndexOfTable;
}
/////////////////////////////////////////
void EventDataMonitorBase::
ClearDataFileSets(){
  TargetT0EvnetFileSet.clear();
  TargetEventFileSet.clear();
  DaqIdSet.clear();
  CurrentPosition.clear();
}
/////////////////////////////////////////
void EventDataMonitorBase::
AddDataFiles( std::string TargetT0EventFilePath,
              std::string TargetEventDataFilePath,
              UInt4 DaqID){
  TargetT0EvnetFileSet.push_back( TargetT0EventFilePath );
  TargetEventFileSet.push_back( TargetEventDataFilePath );
  DaqIdSet.push_back( DaqID );
  CurrentPosition.push_back( 0 );
}
/////////////////////////////////////////
void EventDataMonitorBase::
AddDataFiles( std::vector<std::string> TargetT0EventFilePath,
              std::vector<std::string> TargetEventDataFilePath,
              std::vector<UInt4> DaqID){
  for( UInt4 i=0; i<TargetT0EventFilePath.size(); i++ ){
    AddDataFiles( TargetT0EventFilePath[i],
                  TargetEventDataFilePath[i],
                  DaqID[i] );
  }
}
/////////////////////////////////////////
