#ifndef ACQUIRENEUTRONSOURCEIMAGEINFORMATION
#define ACQUIRENEUTRONSOURCEIMAGEINFORMATION

#define HOST_NAME    "www-cont.j-parc.jp"
//#define HOST_PROTCOL http
//#define HOST_PORT    80
//#define USER_AGENT   "target Information API/1.00"

/* File path and File name of Signal Keys */
#define IMAGE_PATH           "/MLF/Image/"
#define BEAM_POWER_FNAME     "BP.png"
#define CT_01_FNAME          "CT01.png"
#define MODERATOR_FNAME      "H2.png"
#define JPARC_STATUS_FNAME   "JP.png"
#define SHUTTER_STATUS_FNAME "ST.png"
#define CT_3HOUR_FNAME       "CT3H.png"
#define CT_1DAY_FNAME        "CT01LD.png"

#define CT_PATH              "/MLF/cgi/image/"
#define CT_FNAME             "CT.jpg"
#define MODERATOR_TMP_PATH   "/MLF/cgi/image/"
#define MODERATOR_TMP_FNAME  "H2tmp.jpg"

//#include <iostream>                                    /* for cout */
//#include <sstream>                                     /* for ostringstream */
//#include <fstream>                                     /* for ofstream */
//#include <iomanip>                                     /* manipulator */
#include "AcquireNeutronSourceInformationControlBase.hh"
//////////////////////////////////////////////////
class AcquireNeutronSourceImageInformation
  : public AcquireNeutronSourceInformationControlBase
{
private:
    std::string FileSavePath;        /* Image save path */
//  UInt2  Port;                /* The port number to connect */
    Bool   DebugFlag;           /* Debug mode OFF = false or 0; ON = true or not zero */
protected:
public:
    AcquireNeutronSourceImageInformation();
        //!< Constructor
        /*!<
         */
    AcquireNeutronSourceImageInformation( std::string host_name, Bool debug_flag = false );
        //!< Constructor
        /*!<
         *   @param host_name    The server name which is the information Web page of neutron source.
         *   @param debug_flag   The flag to show some parameters under running.
         *                       ( OFF:false/0, ON:true/1 )
         */
    AcquireNeutronSourceImageInformation( Bool debug_flag );
        //!< Constructor
        /*!<
         *   @param debug_flag   The flag to show some parameters under running.
         *                       ( OFF:false/0, ON:true/1 )
         */
    virtual ~AcquireNeutronSourceImageInformation();
        //!< Destructor
        /*!<
         */

    Int4 SetSavePath( const std::string save_path );

    void GetImageInformation( const std::string Key );
    void GetImageInformation( const std::string Key, const std::string Start );
    void GetImageInformation( const std::string Key, const std::string Start, const std::string End );

    std::string PutImagePath( const std::string Key );
    std::string PutImagePath( const std::string Key, const UInt4 year, const UInt4 month, const UInt4 day, const UInt4 hour );

    std::string PutImageFilename( const std::string Key );
    std::string PutImageFilename( const std::string Key, const UInt4 year, const UInt4 month, const UInt4 day, const UInt4 hour );
};

#endif
