# -*- coding: utf-8 -*-
#
# $Date: 2012-07-23 19:56:22 +0900 (月, 23 7 2012) $
# $Rev: 17 $
#
import math

def GetNorm(x):
    return math.sqrt(x[0] * x[0] + x[1] * x[1] + x[2] * x[2])

def GetMultiplyVector(x, scalar):
    return [x[0] * scalar, x[1] * scalar, x[2] * scalar]

def GetCross(x, y, fac=1.0):
    return [(x[1] * y[2] - x[2] * y[1]) * fac,
            (x[2] * y[0] - x[0] * y[2]) * fac,
            (x[0] * y[1] - x[1] * y[0]) * fac]

def GetNormalizedVector(x):
    norm = GetNorm(x)

    y = list(x)

    if norm > GEOM_TINY_VALUE:
        y[0] /= norm
        y[1] /= norm
        y[2] /= norm
        return y
    else:
        return None

def GetVectorByIndex(a, b, c, i, j, k):
    return [i * a[0] + j * b[0] + k * c[0],
            i * a[1] + j * b[1] + k * c[1],
            i * a[2] + j * b[2] + k * c[2]]

def GetDot(a, b):
    return a[0] * b[0] + a[1] * b[1] + a[2] * b[2]
