# -*- coding: utf-8 -*-
"""

"""

import time
import uGao.MPlot as mp
import uGao.M2PlotPlusCui as mp2
import utsusemi.vis.VisualContQ as vctm
import Manyo
import Manyo.Utsusemi as mu
import utsusemi.vis.DetectMap as dp

# 予約語の定義
ret = None
vp1 = None
vp2 = None
vp3 = None
vc = None
vc2 = None
vc3 = None
ec = None
earray = None
DAT = None
ECM = None
ECA = None
vcm = None

###################################################


def DetectMap(matrix=DAT):
    """
    Display Detector Map
    @param  matrix [Def:DAT] ElementContainerMatrix Object
    @retval vp3
    """
    dp.MapFrame(None, matrix)

###################################################


def DetectMap2(matrix=DAT):
    """
    Display Detector Map
    @param  matrix [Def:DAT] ElementContainerMatrix Object
    @retval vp3
    """
    hh = matrix.PutHeaderPointer()
    runNo_s = hh.PutString(mu.UTSUSEMI_KEY_HEAD_RUNNUMBER)
    Ei = None
    if hh.CheckKey(mu.UTSUSEMI_KEY_HEAD_EI) == 1:
        Ei = hh.PutDouble(mu.UTSUSEMI_KEY_HEAD_EI)
    window_title = "DetectMap ( {} )".format(runNo_s)
    main_title = "-"
    if Ei is None:
        comments = "Run No. = {}".format(runNo_s)
    else:
        comments = "Run No. = {} \n Ei = {} meV".format(runNo_s, Ei)
    vp3 = mp2.M2PlotPlusCui(matrix)
    vp3.SetDetectMapMode()
    vp3.ShowData()
    num_x = matrix.PutSize()
    num_y = matrix(0).PutSize()
    width = int(1000)
    height = int(float(width) * float(num_y) / float(num_x))
    vp3.SetWindowSize(width, height)
    vp3.SetWindowTitle(window_title)
    vp3.SetTitles(main_title, comments)
    vp3.SetYaxisInversion(True)
    return vp3

###################################################


def DetectMapChangeData(vp3=vp3, matrix=DAT):
    """
    Display Detector Map
    @param  matrix [Def:DAT] ElementContainerMatrix Object
    @retval vp3
    """
    vp3.ChangeData(matrix)


###################################################
def MPlot(ec=ec):
    """
    Create 1D Plotter and Draw EC
    @param  ec [Def:EC]  ElementContainer
    @param  psd      PSD No.
    @param  pixel    Pixel No.
    @retval vp1    Instance of Plotter
    """
    # 親プロセス終了時に、プロッタを終了
    return mp.MPlot(ec, True)

###################################################


def AddToMPlot(vp1=vp1, ec=ec):
    """
    Add EC to 1D Plotter
    @param  vp1 [Def:vp1]     Instance of 1D Plotter
    @param  ec [Def:EC]      ElementContainer
    @retval None
    """
    vp1.AddData(ec)

###################################################


def M2PlotPlus(matrix=ECA):
    """
    Create 2D Plotter and display 2D Map
    @param  matrix [Def:ECA]  ElementContainerArray
    @retval vp2 [Def:vp2]  Instance of 2D Plotter
    """
    hh = matrix.PutHeaderPointer()
    runNo_s = hh.PutString(mu.UTSUSEMI_KEY_HEAD_RUNNUMBER)
    Ei = None
    if hh.CheckKey(mu.UTSUSEMI_KEY_HEAD_EI) == 1:
        Ei = hh.PutDouble(mu.UTSUSEMI_KEY_HEAD_EI)
    window_title = "M2Plot+ from Sequencer ( {} )".format(runNo_s)
    main_title = "Run No. = {}".format(runNo_s)
    if Ei is None:
        comments = "Ei = None"
    else:
        comments = "Ei = {} meV".format(Ei)

    vp2 = mp2.M2PlotPlusCui(matrix)
    vp2.ShowData()
    vp2.SetWindowTitle(window_title)
    vp2.SetTitles(main_title, comments)
    return vp2

###################################################


def ChangeDataM2Plot(vp2=vp2, matrix=ECA):
    """
    Change 2D Map of M2Plot
    @param  vp2 [Def:vp2]     Instance of 2D Plotter
    @param  matrix [Def:ECA]  ElementContainerArray
    @retval None
    """
    hh = matrix.PutHeaderPointer()
    runNo_s = hh.PutString(mu.UTSUSEMI_KEY_HEAD_RUNNUMBER)
    Ei = None
    if hh.CheckKey(mu.UTSUSEMI_KEY_HEAD_EI) == 1:
        Ei = hh.PutDouble(mu.UTSUSEMI_KEY_HEAD_EI)
    window_title = "M2Plot+ from Sequencer ( {} )".format(runNo_s)
    main_title = "Run No. = {}".format(runNo_s)
    if Ei is None:
        comments = "Ei = None"
    else:
        comments = "Ei = {} meV".format(Ei)

    # Map データの変更
    try:
        vp2.ChangeData(matrix)
        vp2.ShowData()
        vp2.SetWindowTitle(window_title)
        vp2.SetTitles(main_title, comments)
    except:
        raise UserWarning("Not found the plotter")
    return

###################################################


def EmptyM2PlotPlus():
    """
    Create 2D Plotter and display 2D Map without data
    @param  None
    @retval vp2 [Def:vp2]  Instance of 2D Plotter
    """
    vp2 = mp2.M2PlotPlusCui()
    return vp2

###################################################


def VisCont(matrix=DAT):
    """
    Visualize Controller
    @param  matrix [Def:DAT] ElementContainerMatrix
    @retval vc   Instance of Controller
    """
    #
    vc = vct.VisContFrame(matrix)
    return vc

###################################################


def AddToVisCont(vc=vc, matrix=DAT):
    """
    Add Matrix to Visual Controller
    @param  vc [Def:vc] Instance of Visual Controller
    @param  matrix [Def:DAT] ElementContainerMatrix
    @retval None
    """
    vc.AddMatrix(matrix)

###################################################


def VisCont2(matrix=DAT):
    """
    Visualize Controller
    @param  matrix [Def:DAT] ElementContainerMatrix
    @retval vc2   Instance of Controller
    """
    #
    vc2 = vct2.VisContFrame(matrix)
    return vc2

###################################################


def AddToVisCont2(vc2=vc2, matrix=DAT, tab=""):
    """
    Add Matrix to Visual Controller
    @param  vc2 [Def:vc2] Instance of Visual Controller
    @param  matrix [Def:DAT] ElementContainerMatrix
    @param  tab     Tab ID
    @retval None
    """
    dic_Tab = {"A": 0, "B": 1, "C": 2, "D": 3, "E": 4,
               "F": 5, "G": 6, "H": 7, "I": 8, "J": 9}
    if tab != "":
        tab = tab.upper()
        if tab.strip() in dic_Tab:
            vc2.AddMatrix(matrix, dic_Tab[tab.strip()])
        else:
            vc2.AddMatrix(matrix)
    else:
        vc2.AddMatrix(matrix)
###################################################


def VisContM(matrix=DAT):
    """
    Visualize Controller
    @param  matrix [Def:DAT]  ElementContainerMatrix
    @retval vcm   Instance of Controller
    """
    #
    vcm = vctm.VisContMFrame(matrix)
    return vcm

###################################################


def AddToVisContM(vcm=vcm, matrix=DAT, tab=""):
    """
    Add Matrix to Visual Controller
    @param  vcm [Def:vcm]     Instance of Visual Controller
    @param  matrix [Def:DAT]  ElementContainerMatrix
    @param  tab     Tab ID
    @retval None
    """
    dic_Tab = {"A": 0, "B": 1, "C": 2, "D": 3, "E": 4,
               "F": 5, "G": 6, "H": 7, "I": 8, "J": 9}
    if tab != "":
        tab = tab.upper()
        if tab.strip() in dic_Tab:
            vcm.AddMatrix(matrix, dic_Tab[tab.strip()])
        else:
            vcm.AddMatrix(matrix)
    else:
        vcm.AddMatrix(matrix)


# 関数名登録ディクショナリ
_functions = {"DetectMap": DetectMap,
              "DetectMap2": DetectMap2,
              "DetectMapChangeData": DetectMapChangeData,
              "MPlot": MPlot,
              "AddToMPlot": AddToMPlot,
              "M2PlotPlus": M2PlotPlus,
              "ChangeDataM2Plot": ChangeDataM2Plot,
              "VisContM": VisContM,
              "AddToVisContM": AddToVisContM
              }

_functionsOrder = [
    "DetectMap",
    "DetectMapChangeData",
    "MPlot",
    "AddToMPlot",
    "M2PlotPlus",
    "ChangeDataM2Plot",
    "DetectMap2",
    "VisContM",
    "AddToVisContM"
]
