# -*- coding: utf-8 -*-

# [130304] update: add ReadECA and ReadEC by inamura
from __future__ import print_function
import os
import Manyo as mm


class NexusChopper(object):
    def __init__(self, filepath="./", filename="nx.nx", user=""):
        self.MessageTag = "NeXusChopper>>"
        self.filepath = filepath
        self.filename = filename
        self.fullpath = os.path.join(self.filepath, self.filename)
        self.username = user

    def _CheckFile(self, path, warningflag=True):
        if (not os.path.exists(path)):
            if warningflag:
                print(self.MessageTag + " Such file path or file name does not exist.")
            return False

        return True

    def SetFilePath(self, filepath):
        self.filepath = filepath
        self.fullpath = os.path.join(self.filepath, self.filename)

    def SetFileName(self, filename):
        self.filename = filename
        self.fullpath = os.path.join(self.filepath, self.filename)

    def WriteECM(self, dat, name="Data", filepath="", filename=""):
        # if type(dat)!=type(mm.ElementContainerMatrix()):
        #    print self.MessageTag + "Argument must be an ElmentContainerMatrix."
        #    return
        if (filepath != "") and (filename != ""):
            self.SetFilePath(filepath)
            self.SetFileName(filename)

        if self._CheckFile(self.fullpath, False):
            fullpath_org = self.fullpath + ".org"
            print(self.MessageTag + "This file has already existed.")
            print(self.MessageTag + "Old one will be saved by the other name. >> {}".format(fullpath_org))
            comm = "mv {} {}".format(self.fullpath, fullpath_org)
            os.system(comm)

        nexusIO = mm.NeXusFileIO()
        print(self.MessageTag + "Making NeXus file. >> {}".format(self.fullpath))
        nexusIO.Write(dat, self.fullpath, "BL01", 0)
        del nexusIO

        return

    def ReadECM(self, filepath="-", filename="-"):
        if (filepath != "-") and (filename != "-"):
            self.SetFilePath(filepath)
            self.SetFileName(filename)

        if not self._CheckFile(self.fullpath):
            return

        nexusIO = mm.NeXusFileIO()
        print(self.MessageTag + "Loading Nexus file ={}".format(self.fullpath))
        dat = nexusIO.ReadElementContainerMatrix(self.fullpath)
        del nexusIO

        return dat

    def ReadECA(self, filepath="-", filename="-"):
        if (filepath != "-") and (filename != "-"):
            self.SetFilePath(filepath)
            self.SetFileName(filename)

        if not self._CheckFile(self.fullpath):
            return

        nexusIO = mm.NeXusFileIO()
        print(self.MessageTag + "Loading Nexus file ={}".format(self.fullpath))
        dat = nexusIO.ReadElementContainerArray(self.fullpath)
        del nexusIO

        return dat

    def ReadEC(self, filepath="-", filename="-"):
        if (filepath != "-") and (filename != "-"):
            self.SetFilePath(filepath)
            self.SetFileName(filename)

        if not self._CheckFile(self.fullpath):
            return

        nexusIO = mm.NeXusFileIO()
        print(self.MessageTag + "Loading Nexus file ={}".format(self.fullpath))
        dat = nexusIO.ReadElementContainer(self.fullpath)
        del nexusIO

        return dat
