# -*- coding: utf-8 -*-
"""

"""
import vis.DetectMap as dp
import time
import vis.MPlot as mp
import vis.M2Plot as mp2
import vis.VisualContM as vctm

# 予約語の定義
ret = None 
vp1 = None
vp2 = None
vc = None
vc2 = None
vc3 = None
ec = None
earray = None
DAT = None
ECM = None
vcm = None
        
###################################################                            
def DetectMap(matrix=DAT):
        """
        Display Detector Map
        @param  matrix [Def:DAT] ElementContainerMatrix Object 
        @retval None
        """ 
        dp.MapFrame(None, matrix)    
        

###################################################                         
def MPlot(ec=ec):
        """
        Create 1D Plotter and Draw EC
        @param  ec [Def:EC]  ElementContainer
        @param  psd      PSD No.    
        @param  pixel    Pixel No.    
        @retval vp1    Instance of Plotter
        """ 
        # 親プロセス終了時に、プロッタを終了      
        return mp.MPlot(ec, True)
    
###################################################                            
def AddToMPlot(vp1=vp1, ec=ec):
        """
        Add EC to 1D Plotter
        @param  vp1 [Def:vp1]     Instance of 1D Plotter
        @param  ec [Def:EC]      ElementContainer
        @retval None
        """ 
        vp1.AddData(ec)  
        
###################################################                         
def M2Plot(matrix=ECM):
        """
        Create 2D Plotter and display 2D Map
        @param  matrix [Def:ECM]  ElementContainerArray
        @retval vp2 [Def:vp2]  Instance of 2D Plotter
        """ 
        # 親プロセス終了時に、プロッタを終了      
        return mp2.M2Plot(matrix, True)

###################################################
def ChangeMap(vp2=vp2, matrix=ECM):
        """
        Change 2D Map of M2Plot
	@param  vp2 [Def:vp2]     Instance of 2D Plotter
        @param  matrix [Def:ECM]  ElementContainerArray
        @retval None
        """ 
        # Map データの変更
        vp2.ChangeMap(matrix)	

###################################################                         
def VisCont(matrix=DAT):
        """
        Visualize Controller
        @param  matrix [Def:DAT] ElementContainerMatrix
        @retval vc   Instance of Controller
        """ 
        #       
        vc = vct.VisContFrame(matrix)
	return vc

###################################################                            
def AddToVisCont(vc=vc, matrix=DAT):
        """
        Add Matrix to Visual Controller
        @param  vc [Def:vc] Instance of Visual Controller
        @param  matrix [Def:DAT] ElementContainerMatrix
        @retval None
        """ 
        vc.AddMatrix(matrix)  

###################################################                         
def VisCont2(matrix=DAT):
        """
        Visualize Controller
        @param  matrix [Def:DAT] ElementContainerMatrix
        @retval vc2   Instance of Controller
        """ 
        #       
        vc2 = vct2.VisContFrame(matrix)
	return vc2

###################################################                            
def AddToVisCont2(vc2=vc2, matrix=DAT, tab=""):
        """
        Add Matrix to Visual Controller
        @param  vc2 [Def:vc2] Instance of Visual Controller
        @param  matrix [Def:DAT] ElementContainerMatrix
        @param  tab     Tab ID
        @retval None
        """ 
        dic_Tab = {"A":0,"B":1,"C":2,"D":3,"E":4,"F":5,"G":6,"H":7,"I":8,"J":9 }
        if tab!="":
		tab=tab.upper()
		if dic_Tab.has_key(tab.strip()):
			vc2.AddMatrix(matrix,dic_Tab[tab.strip()])  
		else:
			vc2.AddMatrix(matrix)
        else:
		vc2.AddMatrix(matrix)
###################################################                         
def VisContM(matrix=DAT):
        """
        Visualize Controller
        @param  matrix [Def:DAT]  ElementContainerMatrix
        @retval vcm   Instance of Controller
        """ 
        #       
        vcm = vctm.VisContMFrame(matrix)
	return vcm

###################################################                            
def AddToVisContM(vcm=vcm, matrix=DAT, tab=""):
        """
        Add Matrix to Visual Controller
        @param  vcm [Def:vcm]     Instance of Visual Controller
        @param  matrix [Def:DAT]  ElementContainerMatrix
        @param  tab     Tab ID
        @retval None
        """ 
        dic_Tab = {"A":0,"B":1,"C":2,"D":3,"E":4,"F":5,"G":6,"H":7,"I":8,"J":9 }
        if tab!="":
            tab = tab.upper()
            if dic_Tab.has_key(tab.strip()):
	        vcm.AddMatrix(matrix,dic_Tab[tab.strip()])  
            else:
		vcm.AddMatrix(matrix)
        else:
            vcm.AddMatrix(matrix)

           

# 関数名登録ディクショナリ
_functions = {"DetectMap":DetectMap,
              "MPlot":MPlot,
              "AddToMPlot":AddToMPlot,
              "M2Plot":M2Plot,
	      "ChangeMap":ChangeMap,
              "VisContM":VisContM,
              "AddToVisContM":AddToVisContM
	      }

_functionsOrder = [
	"DetectMap",
	"MPlot",
	"AddToMPlot",
	"M2Plot",
	"ChangeMap",
	"VisContM",
	"AddToVisContM"
	]
         
