#include "UtsusemiHistogramBinToPoint.hh"
//////////////////////////////////////////////////////////
UtsusemiHistogramBinToPoint::
UtsusemiHistogramBinToPoint()
{
    Initialize();
}

//////////////////////////////////////////////////////////
UtsusemiHistogramBinToPoint::
UtsusemiHistogramBinToPoint( ElementContainerMatrix *ecm )
{
    Initialize();
    SetTarget( ecm );
}

//////////////////////////////////////////////////////////
UtsusemiHistogramBinToPoint::
~UtsusemiHistogramBinToPoint()
{
    delete UCP;
}
//////////////////////////////////////////////////////////
void UtsusemiHistogramBinToPoint::
Initialize(){
    UCP = new UtsusemiCheckDataProcess();
    _MessageTag = "UtsusemiHistogramBinToPoint::";
    _ProcessTag = "UtsusemiHistogramBinToPoint";
}
//////////////////////////////////////////////////////////
void UtsusemiHistogramBinToPoint::
Execute( bool isReverse )
{
    ElementContainerMatrix* ecm = Put();
    
    if (isReverse){
        if (!(UCP->CheckProcess( ecm,_ProcessTag ))){
            UtsusemiError(_MessageTag + "Execute : never done UtsusemiHistogramBinToPoint or already reversed");
            return;
        }
    }else{
        if (UCP->CheckProcess( ecm,_ProcessTag )){
            UtsusemiError(_MessageTag + "Execute : already done UtsusemiHistogramBinToPoint");
            return;
        }
    }
    
    for (UInt4 i=0; i<ecm->PutSize(); i++){
        ElementContainerArray* eca = ecm->PutPointer(i);
        
        for (UInt4 j=0; j<eca->PutSize(); j++){
            ElementContainer* ec = eca->PutPointer(j);
            
            vector<Double> Xbin = ec->PutX();
            vector<Double> Intensity = ec->PutY();
            vector<Double> Errors = ec->PutE();
            string Xkey = ec->PutXKey();
            string Ykey = ec->PutYKey();
            string Ekey = ec->PutEKey();
            
            for (UInt4 k=0; k<Intensity.size(); k++){
                Double bin_width = Xbin[k+1]-Xbin[k];
                if (isReverse){
                    Intensity[k] = Intensity[k]*bin_width;
                    Errors[k] = Errors[k]*bin_width;
                }else{
                    Intensity[k] = Intensity[k]/bin_width;
                    Errors[k] = Errors[k]/bin_width;
                }
            }
            
            ec->Replace( Ykey, Intensity );
            ec->Replace( Ekey, Errors );
            ec->SetKeys( Xkey, Ykey, Ekey );
        }
    }
    
    if (isReverse){
        UCP->RemoveProcess( ecm, _ProcessTag );
    }else{
        UCP->AddProcess( ecm, _ProcessTag );
    }
}
