#ifndef PHICALCULATIONCHOPPER
#define PHICALCULATIONCHOPPER

#include "UtsusemiHeader.hh"
#include "StringTools.hh"

//////////////////////////////////
// Phi calculation
/////////////////////////////////

//! Function to calculate Phi from Pixel position
/*! 
 * 
 * 
 *  
 * 
 */
class PhiCalculation :
  public ManipulatorBase< ElementContainerMatrix >
{
private:
    double delta_px, delta_py, delta_pz;
    string commentHead;
    void Initialize();
    StringTools* st;
public:
    PhiCalculation();
        //!< Constructor
        /*!<
         */
    PhiCalculation(ElementContainerMatrix *ecm);
        //!< Constructor
        /*!<
         *  @param ecm ElementContainerMatrix for the target
         */
    PhiCalculation(ElementContainerMatrix *ecm, double d_px, double d_py, double d_pz);
        //!< Constructor
        /*!<
         *  @param ecm ElementContainerMatrix for the target
         *  @param d_px delta-x of volume of a pixel
         *  @param d_py delta-y of volume of a pixel
         *  @param d_pz delta-z of volume of a pixel
         */
    ~PhiCalculation();
        //!< Destructor
        /*!<
         */
    void CalcPhi();
        //!< executes calclulation of Phi
        /*!< 
         *   @return None
         */
    void SetPositionDeviationConstant(double d_px, double d_py, double d_pz);
        //!< Set Deviation of volume of a pixel
        /*!<
         *  @param d_px delta-x of volume of a pixel
         *  @param d_py delta-y of volume of a pixel
         *  @param d_pz delta-z of volume of a pixel
         */
};
#endif
