#ifndef WIRINGINFODATABASE
#define WIRINGINFODATABASE

#include "UtsusemiHeader.hh"

class WiringInfoTagDefineBase
{
public:
    WiringInfoTagDefineBase();
        //!< Constructor
        /*!<
         */
    ~WiringInfoTagDefineBase();
        //!< Destructor
        /*!<
         */
    static const std::string WINFO;
    static const std::string WINFO_AT_INST;
    static const std::string WINFO_AT_VER;
    static const std::string WINFO_AT_DATE;

    static const std::string WINFO_PIXELINFO;
    static const std::string WINFO_PIXELINFO_DAQ;
    static const std::string WINFO_PIXELINFO_DAQ_AT_ID;

    static const std::string WINFO_PIXELINFO_DAQ_MOD;
    static const std::string WINFO_PIXELINFO_DAQ_MOD_AT_NO;
    static const std::string WINFO_PIXELINFO_DAQ_MOD_AT_TYPE;
    static const std::string WINFO_PIXELINFO_DAQ_MOD_AT_TRIGINDEX;
    static const std::string WINFO_PIXELINFO_DAQ_MOD_AT_NUMBER_DET;

    static const std::string WINFO_PIXELINFO_DAQ_MOD_DET;
    static const std::string WINFO_PIXELINFO_DAQ_MOD_DET_AT_INDEX;
    static const std::string WINFO_PIXELINFO_DAQ_MOD_DET_AT_ID;
    static const std::string WINFO_PIXELINFO_DAQ_MOD_DET_AT_AXIS;
    static const std::string WINFO_PIXELINFO_DAQ_MOD_DET_AT_HEAD;
    static const std::string WINFO_PIXELINFO_DAQ_MOD_DET_AT_NUM;
    static const std::string WINFO_PIXELINFO_DAQ_MOD_DET_AXIS;
    static const std::string WINFO_PIXELINFO_DAQ_MOD_DET_AXIS_AT_SIZE;
    static const std::string WINFO_PIXELINFO_DAQ_MOD_DET_AXIS_AT_LABEL;
    static const std::string WINFO_PIXELINFO_DAQ_MOD_DET_AXIS_AT_START;

    static const std::string WINFO_TOFBININFO;
    static const std::string WINFO_TOFBININFO_TOFBIN;
    static const std::string WINFO_TOFBININFO_TOFBIN_AT_PAT;
    static const std::string WINFO_TOFBININFO_TOFBIN_AT_OFFSET;
    static const std::string WINFO_TOFBININFO_TOFBIN_AT_MASKID;
    static const std::string WINFO_TOFBINPATLIST;
    static const std::string WINFO_TOFBINPATLIST_PAT;
    static const std::string WINFO_TOFBINPATLIST_PAT_AT_ID;
    static const std::string WINFO_TOFBINPATLIST_PAT_AT_TYPE;
    static const std::string WINFO_TOFMASKPATLIST;
    static const std::string WINFO_TOFMASKPATLIST_PAT;
    static const std::string WINFO_TOFMASKPATLIST_PAT_AT_ID;

    static const std::string WINFO_TOFDOUBLEFRAME;

    static const std::string WINFO_FRAMEINFO;
    static const std::string WINFO_FRAMEINFO_AT_FRAMENO;
    static const std::string WINFO_FRAMEINFO_AT_BOUNDARY;
    static const std::string WINFO_FRAMEINFO_AT_TYPE; //[inamura 170410]

    static const std::string WINFO_TOFTIMEDEPNDBACKGROUND;       //[inamura 160809]
    static const std::string WINFO_TOFTIMEDEPNDBACKGROUND_REGION;//[inamura 160809]
};

class UtsusemiDetAxisInfo
{
public:
    UtsusemiDetAxisInfo();
        //!< Constructor
        /*!<
         */
    UtsusemiDetAxisInfo( const UtsusemiDetAxisInfo& obj );
        //!< Copy Constructor
        /*!<
         */
    ~UtsusemiDetAxisInfo();
        //!< Destructor
        /*!<
         */
    UInt4 size;
    std::string label;
    UInt4 start;

};
class UtsusemiDetInfo
{
public:
    UtsusemiDetInfo();
        //!< Constructor
        /*!<
         */
    UtsusemiDetInfo( const UtsusemiDetInfo& obj );
        //!< Copy Constructor
        /*!<
         */
    ~UtsusemiDetInfo();
        //!< Destructor
        /*!<
         */
    std::string detType;    /**< detector type PSD, SCIN2D, SCIN1D, TRIGNET  */
    bool isAlive;      /**< use or not */
    Int4 detId;
    Int4 headPixelId;
    Int4 numPixel;
    Int4 numAxis;
    //std::vector< std::pair<Int4,std::string> > multiAxes;/**< [numAxis]( std::pair.first:size, std::pair.second:label ) */
    std::vector< UtsusemiDetAxisInfo > multiAxes;

};
class UtsusemiModInfo
{
public:
    UtsusemiModInfo();
        //!< Constructor
        /*!<
         */
    UtsusemiModInfo( const UtsusemiModInfo& obj );
        //!< Copy Constructor
        /*!<
         */
    ~UtsusemiModInfo();
        //!< Destructor
        /*!<
         */
    void ClearList();
    std::vector<UInt4> PutAliveList();
        //!< Puts list of DetList index alived.
        /*!<
         *   @param None
         *   @return std::vector of index
         */
    bool isAlive;                        /**< use or not */
    std::string type;                         /**< Module type (PSD,TRIGNET,N2MON etc) */
    std::vector< UtsusemiDetInfo* > DetList;  /**< List of Detectors */
    std::vector< std::pair<std::string,std::string> > attributes;
};

class UtsusemiDaqInfo
{
public:
    UtsusemiDaqInfo();
        //!< Constructor
        /*!<
         */
    UtsusemiDaqInfo( const UtsusemiDaqInfo& obj );
        //!< Copy Constructor
        /*!<
         */
    ~UtsusemiDaqInfo();
        //!< Destructor
        /*!<
         */
    void ClearList();
    std::vector<UInt4> PutAliveList();
        //!< Puts list of ModList index alived.
        /*!<
         *   @param None
         *   @return std::vector of index
         */
    bool isAlive;                       /**< use or not */
    std::vector< UtsusemiModInfo* > ModList; /**< List of Modules */
};

class UtsusemiTofBinInfo
{
public:
    UtsusemiTofBinInfo();
        //!< Constructor
        /*!<
         */
    UtsusemiTofBinInfo( const UtsusemiTofBinInfo& obj );
        //!< Copy Constructor
        /*!<
         */
    ~UtsusemiTofBinInfo();
        //!< Destructor
        /*!<
         */
    UInt4 patternId;   /**< pattern ID  */
    Double offset;      /**< offset value  */
    Int4 maskPtnId;    /**<  mask pattern Id */
    std::string conts;      /**< parameters descriptions as text */
};

class UtsusemiTofBinPattern
{
public:
    UtsusemiTofBinPattern();
    UtsusemiTofBinPattern( const UtsusemiTofBinPattern& obj );
    ~UtsusemiTofBinPattern();
    UInt4 patternId;
    Int4 type;
    std::vector<Double>* PatternVect;

};

class UtsusemiTofMaskPattern
{
public:
    UtsusemiTofMaskPattern();
    UtsusemiTofMaskPattern( const UtsusemiTofMaskPattern& obj );
    ~UtsusemiTofMaskPattern();
    UInt4 patternId;
    std::vector< std::pair<Double,Double> > PatternVect;

};
class UtsusemiTimeDependBackGround
{
public:
    UtsusemiTimeDependBackGround();
    UtsusemiTimeDependBackGround( const UtsusemiTimeDependBackGround& obj );
    ~UtsusemiTimeDependBackGround();
    std::pair<Double,Double> TofRegion;
};
class UtsusemiFrameBoundaryInfo
{
public:
    UtsusemiFrameBoundaryInfo();
    UtsusemiFrameBoundaryInfo( const UtsusemiFrameBoundaryInfo& obj );
    ~UtsusemiFrameBoundaryInfo();
    UInt4 frameNo;
    Double boundaryValue;
    std::string boundaryType;
    static const std::string BOUNDARYTYPE_TOF;
    static const std::string BOUNDARYTYPE_ENERGY;
    static const std::string BOUNDARYTYPE_LAMBDA;
    static const std::string BOUNDARYTYPE_EI;
    bool SetParams( UInt4 fn, Double bv=0.0, std::string bt="" );
};
#endif
