#ifndef UTSUSEMIFILTERBASE
#define UTSUSEMIFILTERBASE

#include "Header.hh"
#include "UtsusemiHeader.hh"

//////////////////////////////////
// UtsusemiFilterBase
/////////////////////////////////

//! Filter used by UtsusemiEventCaseTemplate
/*!
 *
 */


class UtsusemiFilterBase
{
private:
protected:
    void InitializeBase();
    UInt4 _CaseAmbiguity;
    std::vector<Double> _CaseAmbiguity_params;

public:
    UtsusemiFilterBase();
        //!< Constructor
        /*!<
         */
    ~UtsusemiFilterBase();
        //!< Destructor
        /*!<
         */
    //////////////////////////////////////////////////////////////////////////
    // public instances
    //////////////////////////////////////////////////////////////////////////
    bool isFilterReady;  /**< true if all setting are finished */
    UInt4 numOfCases;    /**< the number of cases */
    std::vector< std::vector<UInt4>* >* filterCaseTable; /**< Case Table for filter */
    std::vector<UInt8> filterPulseIdList;           /**< PulseId list for filter */


    //////////////////////////////////////////////////////////////////////////
    // public functions
    //////////////////////////////////////////////////////////////////////////
    UInt4 PutNumOfCases();
        //!< Puts numOfCases
        /*!<
         *  @param None
         *  @return the number of cases
         */
    virtual std::vector<UInt4> PutListOfCases();
        //!< Puts list of cases
        /*!<
         *  @param None
         *  @return list of cases
         */
    void DumpCaseTable();
        //!< Dumps filterCaseTable on screen
        /*!<
         *  @param None
         *  @return None
         */
    void Clear();
        //!< Clears filterCaseTable and filterPulseIdList
        /*!<
         *  @param None
         *  @return None
         */
    virtual Int4 ReadCaseEvent( UInt4 index, std::vector<std::string> evt_files, std::vector<std::string> t0b_files );
        //!< Reads Case Event file(s).
        /*!< This method is called from UtsusemiEventCasesDecoderTemplate class
         *   and has a role of the interface to this->ReadTrigEvent method.
         *
         *  @param index     (UInt4) index of TrigNET event file
         *  @param evt_files (std::vector<std::string>) path to TrigNET event file(s). Given files are must be belong to same runnumber.
         *  @param t0b_files (std::vector<std::string>) T0 index table for the TrigNET event file
         *  @retval  0 : Succeeded to make filters
         *  @retval -1 : Failed to make filters
         */
    virtual void MakeFilterTables();
        //!< Makes filterCaseTable and filterPulseIdList
        /*!<
         *  @param None
         *  @return None
         */
    void CheckAmbiguousFrame();
        //!< Checks and changes ambiguous frames
        /*!< When a frame includes several 'cases', this function changes frame
         *   to include a case in a frame.
         *  @param None
         *  @return None
         */
    virtual UInt4 GetCaseFromTof( const UInt4 pixelId, Double* tof, std::vector<UInt4>* caseVec );
        //!< Returns CaseId from given pixel id and tof.
        /*!<
         *   This is used in original Increment function.
         *
         *   @param pixelId (UInt4*) given pixel id
         *   @param tof (Double*) tof
         *   @param caseVec (vecotr<UInt4>*) given std::vector of cases
         *   @return caseId (UInt4)  if 0, this tof will not be incremented to histogram.
         */
    virtual bool isTimeSlicing(){ return false; }
    virtual void MakeTimeSlicingCases( std::vector<UInt8> _pulseId, std::vector<double> _clocks ){ return; }
    virtual void SetTimeSlicing( std::vector<Double> tmp ){ return; }
    /*-----------  Obsoleted Methods -----------------------------------------*/
    virtual Int4 ReadCaseInfoFile( std::string caseInfoFile );
        //!< Reads Case Info file
        /*!<
         *  @param caseInfoFile (std::string) path to Case Info file
         *  @return None
         */
    virtual Int4 ReadCaseEventFiles( UInt4 index, std::vector<std::string> evt_files, std::vector< std::vector<UInt8> > t0b_index_list );
        //!< Reads Case Event Files
        /*!<
         *  @param list_dataFile (std::vector<std::string>) list of path to Case Event files
         *  @return None
         */

};

#endif
