#ifndef UTSUSEMIEVENTDATACONVERTERSIMPLENEUNET
#define UTSUSEMIEVENTDATACONVERTERSIMPLENEUNET

#include "UtsusemiHeader.hh"
#include "UtsusemiEventDataConverterTemplate.hh"
#include "UtsusemiEventCasesDecoderTemplate.hh"
#include "UtsusemiNeunetEventDecoderBase.hh"
#include "UtsusemiFilterTrignet.hh"
#include "UtsusemiReductionCommon.hh"
//////////////////////////////////////////
// UtsusemiEventDataConverterSimpleNeunet
//////////////////////////////////////////

//! Load single event data file to convert to histogram briefly
/*!
 *   tt=UtsusemiEventDataConverterSimpleNeunet()
 *   # Set the number of pixels in a PSD
 *   tt.SetNumOfPixel(100)
 *   # Set ABC parameters for each PSD
 *   A, B, C = ( 1100.000, 1.0, 65.00 )
 *   tt.SetPsdParam( A, B, C )
 *   # Set min LLD and max LLD
 *   tt.SetPsdPH( 512, 4096 )
 *   # Set parameters for histogram conversion
 *   tt.SetHistParams( "tof,0,40000,100" )
 *   # Read event data file(s) to create histogram
 *   modNo = 0
 *   tt.ReadEventData( modNo, "SIK000373_00_000_000.edb" )
 *   # Set histogram to ElementContainerMatrix
 *   ecm = ElementContainerMatrix()
 *   tt.SetElementContainerMatrix( ecm )
 *
 */

class UtsusemiEventDataConverterSimpleNeunet:
    public UtsusemiEventDataConverterTemplate< UtsusemiNeunetEventDecoderBase,
                                               UtsusemiEventCasesDecoderTemplate<T0TreatToolsNeunet,UtsusemiFilterTrignet>
                                               >
{
private:
    UtsusemiNeunetEventDecoderBase* _ED;
    UInt4 _NumOfMod;
    Double _Aval;
    Double _Bval;
    Double _Cval;
    Double _LLD;
    Double _HLD;
    UInt4 _NumOfPix;
    Double _deltaX;
    Double _offsetX;
    Double _L1;
    std::string _MessageTag;
    StringTools* _stools;
    bool _enableConv;
public:
    UtsusemiEventDataConverterSimpleNeunet();
        //!< Constructor
        /*!<
         */
    ~UtsusemiEventDataConverterSimpleNeunet();
        //!< Destructor
        /*!<
         */
    void SetL1( Double L1 );
    void SetNumOfMod( UInt4 n );
        //!< Sets the number of NEUNET modules
        /*!< This number is used to calculate detId (= n * 8)
         *   @param n (UInt4) the number of NEUNET modules
         *   @return None
         */
    void SetNumOfPixel( UInt4 _numPix );
        //!< Sets the number of pixels in a PSD
        /*!<
         *   @param _numPix (UInt4) the number of pixels in a PSD
         *   @return None
         */
    void SetPsdParam( Double _A, Double _B, Double _C );
        //!< Sets A B C parameters to all PSD
        /*!<
         *   @param _A (Double) parameter A
         *   @param _B (Double) parameter B
         *   @param _C (Double) parameter C
         *   @return None
         */
    bool SetPsdParam( UInt4 detId, Double _A, Double _B, Double _C );
        //!< Sets A B C parameters to a PSD of given detId
        /*!<
         *   @param detId (UInt4) target detector ID
         *   @param _A (Double) parameter A
         *   @param _B (Double) parameter B
         *   @param _C (Double) parameter C
         *   @retval true   setting is succeeded
         *   @retval false  failed setting
         */
    bool SetPsdPosition( UInt4 detId, std::vector<Double> det_info );
        //!< Sets psd position information for each PSD of given detId
        /*!< ( Under construction )
         */
    void SetPsdPH( Double _minPH, Double _maxPH=4096 );
        //!< Sets the limitation for the pulse height
        /*!<
         *   @param _minPH (Double) lower limit of pulse height
         *   @param _maxPH (Double) upper limit of pulse height
         *   @return None
         */
    void SetPsdInfo( Double deltaX, Double offsetX );
        //!< Sets PSD information for all PSD
        /*!<
         *   @param _minPH (Double) lower limit of pulse height
         *   @param _maxPH (Double) upper limit of pulse height
         *   @return None
         */
    bool SetHistParams( std::string _params );
        //!< Sets parameters to create histogram
        /*!<
         *   @param _params (String) histogram parameters
         *   @retval true   setting is succeeded
         *   @retval false  failed setting
         */
    bool ReadEventData( UInt4 modNo, std::string _file );
        //!< Load event data file
        /*!<
         *   @param modNo (UInt4) NEUNET module No
         *   @param _file (String) the path to event data file
         *   @retval true   setting is succeeded
         *   @retval false  failed setting
         */
    bool SetElementContainerMatrix( ElementContainerMatrix* _ecm );
        //!< Sets created histogram data into given ElementContainerMatrix
        /*!<
         *   @param _ecm (ElementContainerMatrix) container
         *   @retval true   setting is succeeded
         *   @retval false  failed setting
         */
    void Test(ElementContainerMatrix* _ecm, UInt4 modNo, std::string _filePath );

};
#endif
