#ifndef UTSUSEMIEVENTDATACONVERTERREADOUTTEMPLATE_HH
#define UTSUSEMIEVENTDATACONVERTERREADOUTTEMPLATE_HH

#include "Header.hh"
#include "UtsusemiHeader.hh"
#include "UtsusemiEventDataConverterTemplate.hh"
#include "T0TreatToolsReadout.hh"
#include "T0TreatToolsNeunet.hh"
#include "HeaderBase.hh"
#include "ElementContainer.hh"
#include "ElementContainerArray.hh"
#include "ElementContainerMatrix.hh"
#include "WiringInfoEditorReadout.hh"
#include "StringTools.hh"

////////////////////////////////////////////
// UtsusemiEventDataConverterReadoutTemplate
////////////////////////////////////////////

//! Expansion of Template class for Convesion of event data from Readout module
/*!
 *  - read EvnetDataFile
 *  - Decode Event data using Decode module
 *
 *
 *
 */

template <typename T1, typename T2>
class UtsusemiEventDataConverterReadoutTemplate:
    public UtsusemiEventDataConverterTemplate<T1,T2>
{
private:
    std::string _MessageTag;
    StringTools* _st;
public:
    T0TreatToolsReadout* _TTR;
    UtsusemiEventDataConverterReadoutTemplate();
        //!< Constructor
        /*!<
         *
         */
    virtual ~UtsusemiEventDataConverterReadoutTemplate();
        //!< Destructor
        /*!<
         */

    std::vector<Double> _ReadoutGate_Clocks;      /**< Clock info of ReadoutGate */
    std::vector<Double> _ReadoutGate_Clocks_diff; /**< Differency of Clocks of ReadoutGate */
    std::vector<UInt8> _ReadoutGate_PulseId;      /**< PulseId info of ReadoutGate */
    std::vector<UInt8> _Readout_T0Table;          /**< T0Index info of Readout */
    std::vector<UInt8> _Readout_PulseIdTable;     /**< PulseId of Readout */

    void ReadEventData( UInt4 daqId, UInt4 modNo );
        //!< Reads Event data file to make histograms
        /*!<
         *
         *   @param daqId (UInt4) DAQ id
         *   @param modNo (UInt4) module No
         *   @retval None
         */

    void CheckPulseIdTables();
        //!< Compares PulseId between ReadoutGate and Readout
        /*!< to make unified T0Index
         *
         *   @retval None
         */

    Int4 LoadEventDataFiles( UInt4 runNumber, std::string pathToData, std::string pathToT0data );
    Int4 LoadEventDataFiles( std::vector<UInt4> runNumbers, std::string pathToData, std::string pathToT0data );
        //!< Reads Event data file to make histograms
        /*!<
         *
         *   @param runNumber (UInt4) Run number
         *   @param runNumbers (std::vector<UInt4>) Run numbers
         *   @param pathToData (std::string) path to data folder like /data
         *   @param pathToT0Data (std::string) path to t0 index event data folder like /data
         *   @retval  0 : succeed
         *   @retval -1 : Not found data folder with given run numbers
         *   @retval -2 : Never loaded WiringInfo
         */

    void SetElementContainerReadout( UInt4 outer_pixel_id, ElementContainer* ec, UInt4 caseId );
        //!< Sets ElementContaienr from stored gsl_histogram
        /*!<
         *
         *   @param outer_pixel_id (UInt4) Pixel ID
         *   @param ec (ElementContainer) target ElementContainer
         *   @param caseId (UInt4) Case ID
         *   @retval None
         */
    bool LoadParamFiles( std::string w_file, std::string d_file, std::string c_file="" );
        //!< Loads parameter files
        /*!< This executes SetEventParams and SetCaseInfoParams of EventDataConverterTemplate.
         *
         *   @param w_file (std::string) Wiring Info file path
         *   @param d_file (std::string) Detector Info file path
         *   @param c_file (std::string) Case Info file path
         *   @retval true  : succeeded.
         *   @retval false : failed.
         */
    Int4 SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId=1 );
    Int4 SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 runNuber, std::string pathToData, std::string pathToT0data="", UInt4 caseId=1 );
    Int4 SetElementContainerMatrix( ElementContainerMatrix* ecm, std::vector<UInt4> runNuber, std::string pathToData, std::string pathToT0data="", UInt4 caseId=1 );
        //!< Sets Histogram into ElementContainerMatrix
        /*!<
         *     SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId=1 )
         *     SetElementContainerMatrix( ElementContainerMatrix* ecm, std::string instCode, UInt4 runNuber,
         *                                std::string pathToData="", std::string pathToT0data="", UInt4 caseId=1 )
         *
         *   @param ecm          (ElementContainerMatrix*)
         *   @param instCode     (std::string) Instrument code
         *   @param runNumber    (UInt4) run number
         *   @param pathToData   (std::string) path to root directory of instruments event data folders ("/data")
         *   @param pathToT0data (std::string) path to directory to store T0Index event data files
         *   @param caseId       (UInt4) case ID
         *   @retval  0 : succeed
         *   @retval -1 : Not found data folder with given run numbers
         *   @retval -2 : Never loaded WiringInfo
         *   @retval -3 : Wrong defined TOF binning info ( failed to load WiringInfo )
         */
    void LoadTrignetEventFile( UInt4 runno, std::string pathToData="", std::string pathToT0data="" );
    void ReadTrignetEventFile( std::string pathToTrigData, UInt4 index=0 );
        //!< Reads Trignet Event data file for cases
        /*!<
         *   @param pathToTrigData (std::string) path to TrigNET event data files
         *   @param index (UInt4) event file index
         *   @return None
         */
    std::vector<UInt4> DumpCaseTable(UInt4 i1, UInt4 i2, bool isI1Size, bool isI2Size );
        //!< Dumps table of cases
        /*!<
         *   @param i1 (UInt4)
         *   @param i2 (UInt4)
         *   @param isI1Size (bool)
         *   @param isI2Size (bool)
         *   @return None
         */
    Int4 SetElementContainerMatrixForPseudOnLineMon( ElementContainerMatrix* ecm, UInt4 caseId=1, UInt4 runNo=999999 );
        //!< Sets histograms to ElementContainermatrix as pseud on-line monitor
        /*!<
         *   @param ecm    (ElementContainerMatrix*)
         *   @param caseId (UInt4) case ID
         *   @param runNo  (UInt4) run number
         *   @param isI2Size (bool)
         *   @retval  0 : succeed
         *   @retval -1 : Not found data folder with given run numbers
         *   @retval -2 : Never loaded WiringInfo
         *   @retval -3 : Wrong defined TOF binning info ( failed to load WiringInfo )
         */
    Int4 SetDataPathTest( std::string dataPath, std::string t0Path, UInt4 runNo );
    std::vector<Double> PutListOfCounterConditions();

    bool SetTofOriginShift( UInt4 cType );
    bool SetTofOriginShift( UInt4 cType, std::vector<Double> params );

    virtual Int4 _SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId=1 )=0;
};
#include "UtsusemiEventDataConverterReadoutTemplate.cc"
#endif
