#include "UtsusemiCheckDataProcess.hh"
//////////////////////////////////////////////////////////
UtsusemiCheckDataProcess::
UtsusemiCheckDataProcess(){
    _ProcessTag = UTSUSEMI_KEY_HEAD_DATAPROCESSED;
}
//////////////////////////////////////////////////////////
UtsusemiCheckDataProcess::
~UtsusemiCheckDataProcess(){

}

//////////////////////////////////////////////////////////
bool UtsusemiCheckDataProcess::
_CheckProcess( HeaderBase *h, std::string process, bool isExact )
{
    if ((h->CheckKey( _ProcessTag ))==0){
        UtsusemiError("This ElementContainerMatrix has no "+_ProcessTag+" key.");
        return false;
        }

    std::vector<std::string> process_v = h->PutStringVector(_ProcessTag);

    bool ret = false;
    for (UInt4 i=0; i<process_v.size(); i++){
        if (isExact){
            if (process_v[process_v.size()-1-i]==process){
                ret = true;
                break;
            }
        }else{
            std::string::size_type index = process_v[process_v.size()-1-i].find( process );
            if (index != std::string::npos){
                ret = true;
                break;
            }
        }
    }
    return ret;

}

//////////////////////////////////////////////////////////
void UtsusemiCheckDataProcess::
_AddProcess( HeaderBase *h, std::string process )
{
    std::vector<std::string> process_v;
    if (h->CheckKey( _ProcessTag )==0){
        UtsusemiError("This ElementContainerMatrix has no DATAPROCESSED key in Header.");
        process_v.push_back( process );
        h->Add( _ProcessTag, process_v );
    }
    else{
        process_v = h->PutStringVector( _ProcessTag );
        process_v.push_back( process );
        h->OverWrite( _ProcessTag, process_v );
    }
}

//////////////////////////////////////////////////////////
void UtsusemiCheckDataProcess::
_RemoveProcess( HeaderBase *h, std::string process, bool isExact )
{
    std::vector<std::string> process_v;
    if (h->CheckKey( _ProcessTag )==0){
        UtsusemiError("This ElementContainerMatrix has no DATAPROCESSED key in Header.");
    }else{
        std::vector<std::string> p_org = h->PutStringVector( _ProcessTag );
        for (UInt4 i=0; i<p_org.size(); i++){
            if (isExact){
                if (p_org[i]!=process){
                    process_v.push_back( p_org[i] );
                }
            }else{
                std::string::size_type index = p_org[i].find( process );
                if (index == std::string::npos){
                    process_v.push_back( p_org[i] );
                }
            }
        }
    }
    h->OverWrite( _ProcessTag, process_v );
}
