#ifndef D4MATRIXCALCFUNCTION
#define D4MATRIXCALCFUNCTION

#include "UtsusemiD4Matrix.hh"
#include "UtsusemiHeader.hh"

//////////////////////
//  D4MatrixCalc
/////////////////////

//! Class for calculation between D4Matrix
/*!
 *
 *
 */

class D4MatrixCalc

{
private:
    UtsusemiD4Matrix *_D4Mat1;
    UtsusemiD4Matrix *_D4Mat2;
    UtsusemiD4Matrix *_D4Mat;
    float MASKVALUE;
    std::string MessageTag;

public:
    D4MatrixCalc();
        //!< Constructor
        /*!<
         */
    ~D4MatrixCalc();
        //!< Destructor
        /*!<
         */

    void OpenMat1( std::string datapath, std::string paramfile );
        //!< Opens the first D4Mat data file
        /*!<
         *   @param datapath (std::string) the path to the folder in which D4Mat data files are placed.
         *   @param paramfile (std::string) the file name of the parameter xml file of target D4Mat data
         *   @retval None
         */
    void OpenMat2( std::string datapath, std::string paramfile );
        //!< Opens the second D4Mat data file
        /*!<
         *   @param datapath (std::string) the path to the folder in which D4Mat data files are placed.
         *   @param paramfile (std::string) the file name of the parameter xml file of target D4Mat data
         *   @retval None
         */
    void CalcBetweenTwo( std::string ope, std::string outpath, std::string outparamfile );
        //!< Calculates between two D4Mat data opened by OpenMat1 and OpenMat2 with given operator.
        /*!<
         *   @param ope (std::string) the operator for the calculation "+", "-", "*" or "-"
         *   @param outpath (std::string) the path to the directory to save calculated D4Mat data
         *   @param outparamfile (std::string) the file name of the parameter xml file to be saved.
         *   @retval None
         */
    void CalcBetweenTwo( std::string ope, Double coef1, Double coef2, std::string outpath, std::string outparamfile );
        //!< Calculates between two D4Mat data opened by OpenMat1 and OpenMat2 with given operator and coeficiencies.
        /*!< calculate between <coef1> * D4Mat1 and <coef2> * D4Mat2.
         *
         *   @param ope (std::string) the operator for the calculation "+", "-", "*" or "-"
         *   @param coef1 (double) the coeficiency to the first D4Mat data
         *   @param coef2 (double) the coeficiency to the second D4Mat data
         *   @param outpath (std::string) the path to the directory to save calculated D4Mat data
         *   @param outparamfile (std::string) the file name of the parameter xml file to be saved.
         *   @retval None
         */

};
#endif
