%define mlfsoft_path /opt/mlfsoft
%define install_path %{mlfsoft_path}/manyo
%define depended_by manyo

Summary:      Miniature XML development library
Name:         %{depended_by}-deps-mxml
Version:      2.9
Release:      1%{?dist}
License:      LGPLv2+
Group:        System Environment/Libraries
URL:          http://www.msweet.org/blog.php?L+Z3
Source0:      https://www.msweet.org/files/project3/mxml-2.9.tar.gz
#
# fix CVE-2016-4570 and CVE-2016-4571
# From debian. Many thanks.
#
Patch0:       https://sources.debian.net/data/main/m/mxml/2.9-2/debian/patches/05_stack_recursion_fix.diff

#
# fix minor version that wasn't incremented for 2.9
#
Patch1:       https://sources.debian.net/data/main/m/mxml/2.9-2/debian/patches/04_minor_version.diff

# Fix rpath issues
Patch2:       https://sources.debian.net/data/main/m/mxml/2.9-2/debian/patches/01_remove_rpath.diff
Patch3:       https://sources.debian.net/data/main/m/mxml/2.9-2/debian/patches/02_link_with_pthread.diff
Patch4:       https://sources.debian.net/data/main/m/mxml/2.9-2/debian/patches/03_link_ldflags.diff

%description
Mini-XML is a small XML parsing library that you can use to read XML
and XML-like data files in your application without requiring large
non-standard libraries.

%package devel
Summary:  Libraries, includes, etc to develop mxml applications
Group:    Development/Libraries
Requires: %{depended_by}-deps-mxml = %{version}-%{release}
Requires: pkgconfig

%description devel
Libraries, include files, etc you can use to develop mxml
applications.

%prep
%setup -q -n mxml-2.9

%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

%build
# Run autoconf since we patched configure.in.
%configure --enable-shared \
  --prefix=%{install_path} --exec-prefix=%{install_path} \
  --bindir=%{install_path}/bin --includedir=%{install_path}/include \
  --libdir=%{install_path}/lib --mandir=%{install_path}/man
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
make BUILDROOT=%{buildroot} install

# Configuring with --disable-static doesn't work, so let's just delete
# the .a file by hand.
rm %{buildroot}%{install_path}/lib/libmxml.a

# remove extra docs
rm -rf %{buildroot}%{_datadir}/doc/mxml/

# remove rendered man pages
rm -f %{buildroot}%{_datadir}/man/cat*/*


%clean
rm -rf %{buildroot}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc COPYING README
%{install_path}/bin/*
%{install_path}/lib/libmxml.so.*

%files devel
%defattr(-,root,root,-)
%doc CHANGES doc/*.html doc/*.gif
%{install_path}/include/*.h
%{install_path}/lib/libmxml.so
%{install_path}/man/*/*
%{install_path}/lib/pkgconfig/mxml.pc

%changelog
* Wed Dec 21 2022 Nobuo Okazaki - manyo-deps-mxml-2.9-1
- Modify for Manyo

* Fri Dec 13 2019 Nobuo Okazaki - utsusemi-deps-mxml-2.9-1
- Modify for Utsusemi

* Fri Jul 19 2019 Nobuo Okazaki - manyo-deps-mxml-2.9-1
- Modify for Manyo

* Sat Jun 11 2016 Kevin Fenzi <kevin@scrye.com> - 2.9-1
- Update to 2.9
- Add patch from debian to fix CVE-2016-4570 and CVE-2016-4571. Bug #1334648 and #1334649
- Fix rpath usage

* Thu Feb 04 2016 Fedora Release Engineering <releng@fedoraproject.org> - 2.8-5
- Rebuilt for https://fedoraproject.org/wiki/Fedora_24_Mass_Rebuild

* Wed Jun 17 2015 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 2.8-4
- Rebuilt for https://fedoraproject.org/wiki/Fedora_23_Mass_Rebuild

* Sun Aug 17 2014 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 2.8-3
- Rebuilt for https://fedoraproject.org/wiki/Fedora_21_22_Mass_Rebuild

* Sat Jun 07 2014 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 2.8-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_21_Mass_Rebuild

* Sun Apr 06 2014 Brendan Jones <brendan.jones.it@gmail.com> 2.8-1
- Update to 2.8

* Tue Dec 03 2013 Brendan Jones <brendan.jones.it@gmail.com> 2.6-1
- Update to 2.7

* Sat Aug 03 2013 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 2.5-10
- Rebuilt for https://fedoraproject.org/wiki/Fedora_20_Mass_Rebuild

* Thu Feb 14 2013 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 2.5-9
- Rebuilt for https://fedoraproject.org/wiki/Fedora_19_Mass_Rebuild

* Fri Jul 20 2012 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 2.5-8
- Rebuilt for https://fedoraproject.org/wiki/Fedora_18_Mass_Rebuild

* Fri Jan 13 2012 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 2.5-7
- Rebuilt for https://fedoraproject.org/wiki/Fedora_17_Mass_Rebuild

* Tue Feb 08 2011 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 2.5-6
- Rebuilt for https://fedoraproject.org/wiki/Fedora_15_Mass_Rebuild

* Wed Oct 28 2009 Orcan Ogetbil <oget [DOT] fedora [AT] gmail [DOT] com> - 2.5-5
- Fix typo in the .pc file (RHBZ#503628). Patch by Robert Szalai

* Sat Jul 25 2009 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 2.5-4
- Rebuilt for https://fedoraproject.org/wiki/Fedora_12_Mass_Rebuild

* Wed Feb 25 2009 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 2.5-3
- Rebuilt for https://fedoraproject.org/wiki/Fedora_11_Mass_Rebuild

* Mon Aug 11 2008 Tom "spot" Callaway <tcallawa@redhat.com> 2.5-2
- fix license tag

* Tue Jul 08 2008 Anthony Green <green@redhat.com> 2.5
- Upgrade source.

* Mon Feb 18 2008 Fedora Release Engineering <rel-eng@fedoraproject.org> - 2.2.2-8
- Autorebuild for GCC 4.3

* Thu Oct 05 2006 Christian Iseli <Christian.Iseli@licr.org> 2.2.2-7
 - rebuilt for unwind info generation, broken in gcc-4.1.1-21

* Tue Sep 19 2006 Anthony Green <green@redhat.com> 2.2.2-6
- Fix release tag.

* Mon Sep 18 2006 Anthony Green <green@redhat.com> 2.2.2-5.1
- Rebuild.

* Mon Sep  4 2006 Anthony Green <green@redhat.com> 2.2.2-5
- devel package must Require pkgconfig.

* Wed Jul 19 2006 Anthony Green <green@redhat.com> 2.2.2-4
- Fix /usr/share references.

* Sat Jul 15 2006 Anthony Green <green@redhat.com> 2.2.2-3
- Fix /usr/lib reference when deleting libmxml.a.

* Sat Jul 15 2006 Anthony Green <green@redhat.com> 2.2.2-2
- Fix License (LGPL, not GPL).
- Move programming documentation to devel package.
- Build shared library, and no static library.
- Add %%post(un).
- Remove rpath with mxml-no-rpath.patch.
- First Fedora Extras build.

* Fri Sep 23 2005 Fernando Lopez-Lezcano <nando@ccrma.stanford.edu> 2.2.2-1
- updated to 2.2.2 (zynaddsubfx needs 2.2 at least)
* Mon Dec 27 2004 Fernando Lopez-Lezcano <nando@ccrma.stanford.edu> 
- spec file cleanup
* Wed Aug  4 2004 Fernando Lopez-Lezcano <nando@ccrma.stanford.edu> 2.0-1
- initial build.


