#! /bin/bash

export MLFDATA="${HOME}/mlfdata"
export MLFRUN="${HOME}/mlfrun"
export MLFINIT="${HOME}/mlfinit"
export MLFSRC="${HOME}/mlfsrc"
export MLFOUT="${HOME}/mlfout"
export MLFSCRIPTS="${HOME}/mlfscripts"

export BUILDMANYO="${MLFRUN}/build_manyo"
export BUILDUTSUSEMI="${MLFRUN}/build_utsusemi"
export SRCMANYO="${BUILDMANYO}/source_manyo"
export SRCUTSUSEMI="${BUILDUTSUSEMI}/source_utsusemi"
export LOGMANYO="${MLFRUN}/manyo.log"
export LOGUTSUSEMI="${MLFRUN}/utsusemi.log"

export TIMESTAMP=`date "+%y%m%d_%H%M%S"`
export DATESTAMP=`date "+%y%m%d"`
export SAVEPYTHON="${PYTHONPATH}"
export PyVer=3.7

export APPMANYO=/Applications/Manyo
export APPUTSUSEMI=/Applications/Utsusemi

export PYMANYO="${MLFDATA}/py_manyo"
export PYUTSUSEMI="${MLFDATA}/py_utsusemi"
export CPPLIB="${MLFDATA}/cpplibs"

export UTSUSEMIVERSION=${UTSUSEMI_VERSION:-0.0.0}
export MANYOVERSION=${MANYO_VERSION:-0.0.0}

export UTSUSEMIREVNAME="${UTSUSEMIVERSION}_${DATESTAMP}"
export MANYOREVNAME="${MANYOVERSION}_${DATESTAMP}"

export CC=clang-omp
export CXX=clang-omp++

mkdir -p "${MLFDATA}"
mkdir -p "${MLFRUN}"
mkdir -p "${MLFINIT}"
mkdir -p "${MLFSRC}"
mkdir -p "${MLFOUT}"

touch "${LOGMANYO}"
touch "${LOGUTSUSEMI}"
