#! /bin/bash

#source ${HOME}/mlfscripts/setup.sh
source ../mlf_build_env.sh

export OPT="${PYUTSUSEMI}/.opt"
export OPTLIB="${OPT}/lib/cpp"
export PYROOT="${OPT}/python"
export PYBIN="${PYROOT}/bin/python3.7"
export PYLIB="${PYROOT}/lib"
export PYPKG="${PYLIB}/python3.7"

export PY3LIB=${BUILDUTSUSEMI}/opt/mlfsoft/python${PyVer}
export MANYO_PATH=${PY3LIB}/manyo
export UGAO0_PATH=${PY3LIB}/python-ugao
export UTSU0_PATH=${PY3LIB}/python-utsusemi
export UGAO_PATH=${PY3LIB}/python-ugao/uGao
export UTSU_PATH=${PY3LIB}/python-utsusemi/utsusemi

#source "${MLFSCRIPTS}/pystart.sh"

#
# DIR LAYOUT
#

cd ${BUILDUTSUSEMI}
mkdir -p ${UGAO0_PATH}
mkdir -p ${UTSU0_PATH}

mv uGao ${UGAO_PATH}
mv Utsusemi/python-utsusemi ${UTSU_PATH}

for x in SIK VNR AMR HPN
do
    mv Utsusemi/python-utsusemi-${x} ${UTSU_PATH}/${x}
done

mkdir ${UTSU_PATH}/SIK/ana/tmp

for x in SAS ENG TKtools
do
    mv Utsusemi-${x}/python-utsusemi-${x} ${UTSU_PATH}/${x}
done

#
# installer
#

echo
echo "#"
echo "# set up installer > ${MLFOUT}/utsusemi_${UTSUSEMIREVNAME}.pkg"
echo "#"
echo

# fix directory hierachy

rm -rf "${BUILDUTSUSEMI}/AppRoot"
mkdir -p "${BUILDUTSUSEMI}/AppRoot/Applications"

export ROOT="${BUILDUTSUSEMI}/AppRoot/Applications/Utsusemi"

cp -a "${MLFDATA}/utsusemi_template" "${ROOT}"
cp -a "${MLFDATA}/py_utsusemi/.opt/python" "${ROOT}/.opt/"
cp -a "${PY3LIB}/manyo" "${ROOT}/.opt/manyo"
cp -a "${PY3LIB}/python-ugao" "${ROOT}/.opt/python-ugao"
cp -a "${PY3LIB}/python-utsusemi" "${ROOT}/.opt/python-utsusemi"

mkdir "${ROOT}/.opt/lib"
cp -a "${OPTLIB}" "${ROOT}/.opt/lib/cpp"

chmod ugo+rwX "${ROOT}/.opt/bin"
chmod ugo+rwX "${ROOT}/.opt/_first_launch"

# build package
#pkgbuild --identifier utsusemi --root "${BUILDUTSUSEMI}/AppRoot" "${MLFOUT}/Utsusemi_${UTSUSEMIREVNAME}.pkg"
LASTUPDATED=`cat ${MLFSRC}/LASTUPDATED`
UTSUSEMIREVNAME2="${UTSUSEMIVERSION}_${LASTUPDATED}"
pkgbuild --identifier utsusemi --root "${BUILDUTSUSEMI}/AppRoot" "${MLFOUT}/Utsusemi_${UTSUSEMIREVNAME2}.pkg"

echo
echo "INSTALLER READY: ${MLFOUT}/utsusemi_${UTSUSEMIREVNAME}.pkg"
echo
