#! /bin/bash

#source ${HOME}/mlfscripts/setup.sh
source ../mlf_build_env.sh

echo
echo "#"
echo "# setting up build environment"
echo "#"
echo

export BAK="${APPMANYO}_${TIMESTAMP}"
export OPT="${APPMANYO}/.opt"
export PYROOT="${OPT}/python"
export PYBIN="${PYROOT}/bin"
export PYLIB="${PYROOT}/lib"
export PYPKG="${PYLIB}/python3.7"
export PYINC="${PYROOT}/include/python3.7m"

export MANLIB="${OPT}/manyo/lib"
export OPTLIB="${OPT}/lib/cpp"

# check for /Applications/Manyo

if [[ -a "${APPMANYO}" ]]
then
    echo "backing up ${APPMANYO}"
    if [[ -w "${APPMANYO}" ]]
    then 
        mv "${APPMANYO}" "${BAK}"
    else
        echo "no write permission for ${APPMANYO}"
        exit
    fi
fi

ln -s ${PYMANYO} ${APPMANYO}
rm -rf ${MANLIB}
mkdir -p ${MANLIB}

export UTSUSEMI_REV=${DATESTAMP}
export NUM_MULTH=8

# paths
export PY3LIB=${BUILDMANYO}/opt/mlfsoft/python${PyVer}
export MANYO_PATH=${PY3LIB}/manyo





export INSTALL_PATH=${MANYO_PATH}

echo
echo "source:   ${MLFSRC}"
echo "build:    ${BUILDMANYO}"
echo "srcbuild: ${SRCMANYO}_${MANYOREVNAME}"
echo "logfile:  ${LOGMANYO}"
echo "python:   `which python3`"
echo

echo "start build ${TIMESTAMP}" >> "${LOGMANYO}"

rm -rf ${BUILDMANYO}

echo
echo copy source tree
echo

cp -a ${MLFSRC} ${BUILDMANYO}

# make file envs
export INC_EXT="Manyo MLF "
export C_INCLUDE_PATH=/usr/local/include/nexus:/usr/include/hdf5/serial:${MANYO_PATH}/include:/usr/local/include:${MANYO_PATH}/include/Manyo:${MANYO_PATH}/include/core:${MANYO_PATH}/include/MLF:${PYINC}:${PYPKG}/site-packages/numpy/core/include:${PYPKG}/numpy/core/include
export LIBRARY_PATH=${CPPLIB}:${PYLIB}:${MANYO_PATH}/lib:${INSTALL_PATH}:${MANLIB}:/usr/local/lib
export LD_LIBRARY_PATH=${LIBRARY_PATH}
export PATH=${PYBIN}:${MANYO_PATH}/bin:${PATH}
export CPLUS_INCLUDE_PATH=${C_INCLUDE_PATH}

echo
echo "#"
echo "# starting build using `which python3`"
echo "#"
echo

export TARDIR="${SRCMANYO}_${MANYOREVNAME}" 
export TARBASE=`basename ${TARDIR}`

mkdir -p "${TARDIR}" 
cp -a ${MLFSRC} ${TARDIR}/src >> ${LOGMANYO} 2>&1
cp -a ${MLFDATA}/manyo_template ${TARDIR} >> ${LOGMANYO} 2>&1
cp -a ${MLFSCRIPTS}/manyo_src/* ${TARDIR} >> ${LOGMANYO} 2>&1
cd "${BUILDMANYO}" 
tar czf "${MLFOUT}/manyo_${MANYOREVNAME}.tgz" ${TARBASE} >> ${LOGMANYO} 2>&1

# build
cd ${BUILDMANYO}/manyo
export
make clean
cd core; bash depend.mac; cd ../MLF; bash depend.mac; cd ..
#make  -f Makefile.py3.mac install -j #>> ${LOGMANYO} 2>&1
make  -f Makefile.py3.mac install -j2 #>> ${LOGMANYO} 2>&1

























# [inamura 200201] removed fix_imports_manyo.sh
#echo
#echo "#"
#echo "# fix imports"
#echo "#"
#echo
#
#/bin/bash ${MLFSCRIPTS}/fix_imports_manyo.sh ${MANYO_PATH}/Manyo >> ${LOGMANYO} 2>&1


echo
echo "BUILD COMPLETE: ${BUILDMANYO}"
echo

# rewrite library paths
cd ${MANYO_PATH}
cp ${MANYO_PATH}/lib/* ${MANLIB} 
find . -name \*.so -exec ${PYBIN}/python3 ${MLFSCRIPTS}/so_fix.py ${MANYO_PATH}/{} ${MANLIB} ${OPTLIB} \;
rm -rf ${MANLIB}

# tidyup
unlink "${APPMANYO}" 

if [[ -a "${BAK}" ]]
then
    mv "${BAK}" "${APPMANYO}" >> ${LOGMANYO} 2>&1
fi


