# ビルド方法（詳細）

AppleSiliconのmacOS上のHomebrew環境にて、万葉ライブラリのコンパイルに必要な最小限の環境を構築する方法を述べる。

## 動作検証環境

|Date|2025/2/16|
| --- | --- |
|macOS|Sonoma 14.7|
|CPU|AppleSilicon|
|Manyo ver.|250117|
|Utsusemi ver.|250129|

## 環境構築
### Homebrew環境
#### インストール
参照: https://docs.brew.sh/Installation

詳細は述べないが、下記のインストールスクリプトを実行し、表示される指示に従うこと。

```
% /bin/bash -c "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/HEAD/install.sh)"
% vi ~/.zprofile
eval "$(/opt/homebrew/bin/brew shellenv)"
```
#### 必要なツールやC++ライブラリのインストール

準備として、ビルドに必要なツールやライブラリをHomebrewから可能な限りインストールする。

以下のように行う。

```
brew tap brewsci/homebrew-science
brew tap brewsci/bio
brew install cmake doxygen python3 swig gsl libmxml openssl hiredis libevent llvm libomp hdf5 zlib
```

これらを実行した後、インストールしたpython3などを使えるようにするため、一度ターミナルを終了し再度起動すること。

なお、同等の処理を行うスクリプトも用意されているので、それを使用しても良い。

参考: Utsusemi/contrib/macos/AppleSilicon/00build_dep.sh

### そのほかのライブラリ
下記のライブラリはhomebrewでインストールされなかったり、新しすぎて対応していないため、別途導入する。

|ライブラリ名|理由|
| ---- | ---- |
|boost (C++)|現時点(2025/2/7)で万葉ライブラリはboostのバージョン1.86までしか対応しないが homebrewでは1.87以降がインストールされるため|
|Nexus format|homebrewではインストールできないため|

なおこれらのインストール先は万葉ライブラリと同じ場所にすることで、設定を減らすこととする。
このインストール先は `MANYO_PATH` という環境変数で指定しておく。

```
export MANYO_PATH=/path/to/install
```

以降の記述では、この `MANYO_PATH` を利用する。

#### boost C++ ライブラリ
万葉ライブラリが使用するboostライブラリをソースコードからインストールする。
homebrewでもインストールできるが、最新版の1.87になると万葉ライブラリのコンパイルに失敗するため、別途対応した1.86.0のソースコードをダウンロードしてライブラリをビルドする。

```
wget https://boostorg.jfrog.io/artifactory/main/release/1.79.0/source/boost_1_86_0.tar.gz
tar xzvf boost_1_86_0.tar.gz
cd boost_1_86_0
./bootstrap.sh --with-libraries=chrono,filesystem,program_options,serialization,system
./b2 install --prefix=${MANYO_PATH} threading=multi --layout=tagged
```

#### Nexus format ライブラリ
Nexus format APIを使用するためのライブラリをソースコードからインストールする。

まずダウンロードを行い、 *Utsusemi/contrib/macos/AppleSilicon/* フォルダにある *NXbrowse.diff* を使ってパッチを当てる。

```
git clone https://github.com/nexusformat/code
patch code/applications/NXbrowse/NXbrowse.c < Utsusemi/contrib/macos/AppleSilicon/NXbrowse.diff
```

その後下記のように、cmakeによりビルドとインストールを行う。

```
mkdir code/build
cd code/build
export ENABLE_CXX=yes;cmake -DENABLE_APPS=ON -DENABLE_HDF5=1 -DCMAKE_INSTALL_PREFIX:PATH=${MANYO_PATH} ..
make install
```

なお、同等の処理を行うスクリプトも準備されている。

参考: Utsusemi/contrib/macos/AppleSilicon/01build_nexus.sh

### 環境変数の設定

以降のライブラリ等のコンパイルに必要となる各種環境変数を設定する。

設定が必要な環境変数は以下となる。

|ビルド時に必要な環境変数|内容|
| ---- | ---- |
|MANYO_PATH|万葉ライブラリのインストール先、万葉ライブラリが必要とするライブラリもここへインストール|
|LIBRARY_PATH|Linkerに必要（これがないとlinkに失敗する）|
|CPLUS_INCLUDE_PATH|コンパイル時のinclude先として必要|
|INSTALL_PATH|(=${MANYO_PATH}) Makefileで使用|
|PyVer|一部のC++コードのプリプロセッサで使用|

|実行時に必要な環境変数|内容|
| ---- | ---- |
|MANYO_PATH|万葉ライブラリのインストール先、万葉ライブラリが必要とするライブラリもここへインストール|
|DYLD_LIBRARY_PATH|(=${LIBRARY_PATH}) 万葉ライブラリの動的リンクの設定（これがないとimport時にエラー）|


特にLIBRARY_PATHやCPLUS_INCLUDE_PATHに必要なライブラリパスは、homebrewでインストールされたバージョンなどに依存するので、環境に応じて適切なパスを指定する必要がある。

- Homebrewのデフォルト
- Python（バージョン指定）
- openssl
- zlib
- libomp （バージョン指定）

以下はあるhomebrew環境における環境変数設定の具体例である。

```
# Manyo Library Path like /opt/mlfsoft/manyo
export MANYO_PATH=/opt/mlfsoft/manyo

# LIBRARY_PATH for compile
export LIBRARY_PATH=${MANYO_PATH}/lib:\
/opt/homebrew/lib:\
/opt/homebrew/Cellar/python@3.13/3.13.1/Frameworks/Python.framework/Versions/Current/lib:\
/opt/homebrew/opt/openssl/lib:\
/opt/homebrew/opt/zlib/lib:\
/opt/homebrew/Cellar/libomp/18.1.8/lib

export DYLD_LIBRARY_PATH=${LIBRARY_PATH}

# INCLUDE_PATH for compile
export CPLUS_INCLUDE_PATH=${MANYO_PATH}/include:\
${MANYO_PATH}/include/boost:\
/opt/homebrew/include/:\
/opt/homebrew/Cellar/python@3.13/3.13.1/Frameworks/Python.framework/Versions/Current/include/python3.13:\
/opt/homebrew/opt/openssl/include:\
/opt/homebrew/Cellar/libomp/18.1.8/include:\
${MANYO_PATH}/include/nexus

# Installation path and Python version
export INSTALL_PATH=${MANYO_PATH}
export PyVer=3.13
```

ただし、これらを調査するのに利用できるスクリプト `create_setup.py` を用意してある。

参考: Utsusemi/contrib/macos/AppleSilicon/create_setenv.py

これは既存のhomebrew環境から上記のような環境変数を設定するスクリプトを作成するものである。

下記のようにスクリプトを実行する。

```
$ python3 create_setup.py /Users/hoge/mlfsoft/manyo
```

ここで、引数 */Users/hoge/mlfsoft/manyo* は万葉ライブラリのインストールパス（いわゆる環境変数 *MANYO_PATH* ）である。すでに環境変数 *MANYO_PATH* が設定されていれば、この引数がなくても動作する。

このスクリプト実行により、設定ファイル *setenv.sh* が作成される。

この作成された *setenv.sh* を用い、環境変数の設定を有効にすることができる。

```
$ source setenv.sh
```

この時、同時に *_setEnvMac* も作成されるが、後で使用する。


## ソースコードの配置
*source* フォルダを作成し、その下に *manyo* , *Utsusemi* などのソースコードを配置する。

```
$ mkdir source
```

## コンパイル及びインストール（手動）
以下の実行には、前述した *必要なC++ライブラリのインストール* 及び *環境変数の設定* を済ませておくことが前提である。

なおインストール先は、環境変数 *MANYO_PATH* である。

### manyoライブラリ
参考: Utsusemi/contrib/macos/AppleSilicon/02compile_manyo.sh

```
cd manyo
cd core
./depend.mac
cd ../MLF
./depend.mac
cd ..
make install -f Makefile.mac NUM_MULTH=2 CXX=clang++
```

### 空蟬C++コード
参考: Utsusemi/contrib/macos/AppleSilicon/03compile_utsusemi.sh

```
cd Utsusemi/manyo
./depend.mac
make install -f Makefile.mac NUM_MULTH=2 CXX=clang++
```

### BL15空蟬C++コード
参考: Utsusemi/contrib/macos/AppleSilicon/04compile_utsusemi-sas.sh

```
cd Utsusemi-SAS/manyo
./depend.mac
make install -f Makefile.mac NUM_MULTH=2 CXX=clang++
```

## コンパイル及びインストール（スクリプト）
前節のコンパイルやPythonパッケージのインストール作業は以下のスクリプトを用いても可能である。

```
Utsusemi/contrib/macos/AppleSilicon/02build_manyo.sh
Utsusemi/contrib/macos/AppleSilicon/03build_utsusemi.sh
Utsusemi/contrib/macos/AppleSilicon/04compile_utsusemi-sas.sh
```

これらを *source* フォルダと同じフォルダ内にコピーして、以下のように配置する。

```
$ ls -F
01build_nexus.sh		03compile_utsusemi.sh              05install_pypack.sh
02compile_manyo.sh		04compile_utsusemi-sas.sh          source/
$ ls source
Utsusemi	Utsusemi-SAS	code		manyo		uGao
```

Manyoライブラリと空蟬のC++コードのインストールを行う。

```
$ ./02build_manyo.sh
$ ./03build_utsusemi.sh
$ ./04build_utsusemi-sas.sh
```

## チェック

```
$ python3
>>> import Manyo
Manyo>>> import Manyo.Utsusemi
Manyo>>>
```

## Python環境の整備

### GUI用のPythonライブラリのインストール

```
python3 -m pip install --upgrade pip
python3 -m pip install scipy matplotlib
python3 -m pip install PySide6
python3 -m pip install PyOpenGL PyOpenGL_accelerate
python3 -m pip install pyqtgraph
```

なお、以下のスクリプトを実行しても同じである。

```
$ Utsusemi/contrib/macos/AppleSilicon/05install_pypack.sh
```

### 実行ファイルの配置
 *Utsusemi/python-utsusemi/bin* フォルダ、もしくはその中のファイルを、適当な場所に（たとえば */Users/hoge/mlfsoft/bin* など）コピーする。

次にcreate_setup.py実行時に作成された *_setEnvMac* をこの *bin* フォルダに上書きコピーする。

### 実行パスの指定

~/.zprofileに *bin* フォルダへのパスを下記のように追記する。下記の例では *bin* フォルダは */Users/hoge/mlfsoft/bin* となっている。

```
export PATH=/Users/hoge/mlfsoft/bin:${PATH}
```

この設定を有効にするためにターミナルに入り直すか、下記を実行する。

```
source ~/.zprofile
```

### チェック
環境設定（アプリ）が開くかどうか確認する。

```
$ EnvironSetting
```

