# ビルド方法 on macos with AppleSilicon

AppleSiliconのmacOS上のHomebrew環境にて、万葉ライブラリのコンパイルに必要な最小限の環境を構築する方法を述べる。詳細はそれぞれのスクリプトを読むか、「ビルド方法（詳細）」 `READMEfull.md` を参照のこと。

## 動作検証環境

|Date|2025/2/2|
| --- | --- |
|macOS|Sonoma 14.7|
|CPU|AppleSilicon|
|Manyo ver.|250117|
|Utsusemi ver.|250129|

## 準備
### Homebrewのインストール
詳細は略す。

### 必要なC++ライブラリのインストール
Homebrewからインストールできるものをインストールする。

```
$ ./00build_dep.sh
```

これを実行した後、インストールしたpython3などを使えるようにするため、一度ターミナルを終了し再度起動すること。

### 環境変数の設定
各種環境変数を設定するためにsetenv.shを環境に合わせて作成する。

この環境変数設定により、HomebrewでインストールしたPython3の場所、他のライブラリなどへのパス、万葉ライブラリのインストール先（ */opt/mlfsoft/manyo* ）などが指定される。

setenv.shを自動的に作成するPythonスクリプトを準備している。このスクリプト( *create_setenv.py* )を万葉ライブラリのインストール先（いわゆる *MANYO_PATH* 環境変数で与えらえるパス）を引数として実行すると、Homebrewから必要なライブラリなどのパスを取得しsetenv.shが作成される。下記のようにスクリプトを実行する。

```
$ python3 create_setup.py /Users/hoge/mlfsoft/manyo
```

ここでは、インストール先は */Users/hoge/mlfsoft/manyo* を指定している。環境変数 *MANYO_PATH* は同様に */Users/hoge/mlfsoft/manyo* となる。

作成された *setenv.sh* を用い、環境変数の設定を有効にする。

```
$ source setenv.sh
```

この時、同時に *_setEnvMac* も作成されるが、後で使用する。

### boost C++ ライブラリのインストール
万葉ライブラリが使用するboostライブラリをインストールする。
homebrewでもインストールできるが、最新版の1.87になると万葉ライブラリのコンパイルに失敗するため、別途ソースコードをダウンロードしてライブラリをビルドする。

```
```


## ソースコード
*source* フォルダを作成し、その下に *manyo* , *Utsusemi* などのソースコードを配置する。

```
$ mkdir source
```

## コンパイル及びインストール
*01build_nexus.sh* , *02build_manyo.sh* , *03build_utsusemi.sh* , *04compile_utsusemi-sas.sh* , *05install_pypack.sh* をコピーして、以下のように配置する。

```
$ ls -F
01build_nexus.sh		03compile_utsusemi.sh              05install_pypack.sh
02compile_manyo.sh		04compile_utsusemi-sas.sh          source/
$ ls source
Utsusemi	Utsusemi-SAS	code		manyo		uGao
```


### NexusFormat
NexusFormatをインストールする。

```
$ ./01build_nexus.sh
```

### Manyoライブラリと空蟬C++コード
Manyoライブラリと空蟬のC++コードのインストールを行う。

```
$ ./02build_manyo.sh
$ ./03build_utsusemi.sh
$ ./04build_utsusemi-sas.sh
```

## チェック

```
$ python3
>>> import Manyo
Manyo>>> import Manyo.Utsusemi
Manyo>>>
```

## Python環境の整備

### Pythonライブラリのインストール

```
$ ./05install_pypack.sh
```

### 実行ファイルの配置
create_setup.py実行時に指定したインストール先（上の例では */Users/hoge/mlfsoft* ）に、 *bin* フォルダをコピーする。

次にcreate_setup.py実行時に作成された *_setEnvMac* をこの *bin* フォルダに上書きコピーする。

### 実行パスの指定

~/.zprofileに下記を追加する。

```
export PATH=/Users/hoge/mlfsoft/bin:${PATH}
```

### チェック
ターミナルに入り直して環境設定が開くかどうか確認する。

```
$ EnvironSetting
```

