%{!?python_sitelib: %define python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}
%global __os_install_post %(echo '%{__os_install_post}' | sed -e 's!/usr/lib[^[:space:]]*/brp-python-bytecompile[[:space:]].*$!!g')

# Get branch/date/commit from archive name
%{!?target_branch: %define target_branch *}
%define _tgt %(basename $(find %{_sourcedir} -name "Utsusemi-%{target_branch}.*.tar.gz" | head -1))
%define _fmt \\(.\\+\\?\\)\\.\\([0-9]\\{6\\}\\)git\\([0-9a-f]\\{8\\}\\)\\.tar\\.gz
%define branch    %(echo %{_tgt} | sed -e "s/^Utsusemi-%{_fmt}$/\\1/")
%define refdate   %(echo %{_tgt} | sed -e 's/^Utsusemi-%{_fmt}$/\\2/')
%define refcommit %(echo %{_tgt} | sed -e 's/^Utsusemi-%{_fmt}$/\\3/')

%if "%{branch}" == "master"
%{!?ver: %define ver 4.0.0}
%else
%{!?ver: %define ver %{branch}}
%endif

%{!?manyo_minver: %define manyo_minver 0.3.7}
%{!?revdate: %define revdate %{refdate}}
%define cvstype git
%{!?revno: %define revno %{refcommit}}

%define sover %{ver}.%{revdate}
%define checkout %{cvstype}%{revno}

%define mlfsoft_path /opt/mlfsoft
%define manyo_path %{mlfsoft_path}/utsusemi
%define install_path %{mlfsoft_path}/utsusemi

%if "%{branch}" == "0.3.7"
%define with_py2 1
%else
%define with_py2 0
%endif

%if %{with_py2}
%define pyver %{python2_version}
%define rc_prefix bashrc
%define ut_prefix /
%define python %{__python2}
%define py_manyo_path %{manyo_path}/lib/python%{python2_version}/site-packages
%define pkg_name utsusemi
%else
%define pyver %{python3_version}
%define rc_prefix bashrc.py3
%define ut_prefix /utsusemi
%define python %{__python3}
%define py_manyo_path %{manyo_path}/lib/python%{python3_version}/site-packages
%define pkg_name utsusemi4
%endif

%{!?threads: %define threads 8}

Summary: Utsusemi processing software for MLF
Name:    %{pkg_name}
Version: %{ver}.%{revdate}
Release: 0.%{checkout}%{?revsubno}%{?dist}
Group:   System Environment/Libraries
License: AS IS
URL:     https://mlfinfo.jp/groups/comp/ja/utsusemi.html
#Source:  Utsusemi-%{version}%{cvstype}%{revno}.tar.gz
Source:  Utsusemi-%{branch}.%{revdate}%{cvstype}%{revno}.tar.gz

# raise RuntimeError at stopping with build error
Patch0:  utsusemi-do_make_Utsusemi.py-stop_on_error.patch
# libUtsusemi location to install
Patch1:  utsusemi-Makefile.patch
# bashrc patch
%if %{with_py2}
Patch2:  utsusemi-bashrc.ALL.patch
%else
Patch2:  utsusemi-bashrc.py3.ALL.patch
%endif

BuildRequires: swig
BuildRequires: utsusemi-deps-nexus-devel hdf5-devel gsl-devel
BuildRequires: fftw-devel >= 3
BuildRequires: boost-devel >= 1.53
BuildRequires: boost-serialization >= 1.53
BuildRequires: boost-filesystem >= 1.53
BuildRequires: boost-system >= 1.53
BuildRequires: utsusemi-deps-manyo-devel >= %{manyo_minver}

# yum-builddepで入らないのでどちらも入れる
# for 0.3.7
BuildRequires: python-devel
BuildRequires: utsusemi-deps-mxml-devel <= 2.10
# for 4.0.0
BuildRequires: python3-devel

Requires: utsusemi-deps-nexus hdf5 gsl fftw >= 3
Requires: boost-serialization >= 1.53
Requires: boost-filesystem >= 1.53
Requires: boost-system >= 1.53
%if %{with_py2}
Requires: python-six
Requires: scipy
Requires: utsusemi-lib = %{version}-%{release}
Requires: utsusemi-deps-mxml <= 2.10
Requires: utsusemi-deps-python2-matplotlib-wx
%else
Requires: python36-pyside
Requires: python36-scipy
Requires: python36-numpy
Requires: utsusemi4-lib = %{version}-%{release}
Requires: utsusemi-deps-python36-matplotlib
%endif

%description
Our software, named "Utsusemi", has already been utilized in
actual users measurements, while we are proceeding with
developments for more effective use of high flux neutrons and
event-recording methods. Especially, we have successfully
demonstrated a measurement of a single crystal of 3D spin system;
several tens of measurements by rotating the sample, and
visualization of the measured data forming intensity maps in
large Q space. This has been achieved by developments of
software to perform automatic devices control (sample rotation
and data acquisition) and to handle huge data for visualization.

%package lib
Summary: Utsusemi library for Manyo
Group: System Environment/Libraries
Provides: libUtsusemi.so()(64bit)
Requires: utsusemi-deps-nexus hdf5 gsl fftw >= 3
Requires: boost-serialization >= 1.53
Requires: boost-filesystem >= 1.53
Requires: boost-system >= 1.53
%if %{with_py2}
Requires: utsusemi-deps-python2-manyo >= %{manyo_minver}
%else
Requires: utsusemi-deps-python36-manyo >= %{manyo_minver}
%endif

%description lib
Utsusemi library

%package devel
Summary: Utsusemi library for Manyo
Group: System Environment/Libraries
Requires: %{pkg_name} = %{version}-%{release}
%if %{with_py2}
Conflicts: utsusemi4-devel
%else
Conflicts: utsusemi-devel
%endif

%description devel
Include files, examples you can use to develop Utsusemi applications.

%package AMR
Summary: BL specific extension of Utsusemi for AMR(AMATERAS)
Group:   System Environment/Libraries
Requires: %{pkg_name} = %{version}-%{release}

%description AMR
BL specific extension of Utsusemi for AMATERAS(BL14)

%package HPN
Summary: BL specific extension of Utsusemi for HPN(PLANET)
Group:   System Environment/Libraries
Requires: %{pkg_name} = %{version}-%{release}

%description HPN
BL specific extension of Utsusemi for PLANET(BL11)

%package SIK
Summary: BL specific extension of Utsusemi for SIK(4SEASONS)
Group:   System Environment/Libraries
Requires: %{pkg_name} = %{version}-%{release}

%description SIK
BL specific extension of Utsusemi for 4SEASONS(BL01)

%package VNR
Summary: BL specific extension of Utsusemi for VNR(SHARAKU)
Group:   System Environment/Libraries
Requires: %{pkg_name} = %{version}-%{release}

%description VNR
BL specific extension of Utsusemi for SHARAKU(BL17)

%prep
%setup -T -c
tar zxvf %{SOURCE0} --strip-components=1
%patch0 -p1
%patch1 -p1
%if %{with_py2}
echo -e "\e[35;1;7m --- Utsusemi %{ver} with Py27 settings --- \e[m"
%else
echo -e "\e[36;1;7m --- Utsusemi %{ver} With Py36 settings --- \e[m"
%endif
sleep 3

%build
#pushd manyo
#DESTDIR=%{buildroot} PKG_SOVER=%{sover} PY_PREFIX=%{py_manyo_path} LIB_OPT="-lMLF -L%{py_manyo_path}" \
#  %{python} do_make_Utsusemi.py make \
#  --dist-name=RH7 --manyo-path=%{manyo_path} --numth=%{threads} --pyver=%{pyver} --rev=%{revdate}

%install
pushd manyo
rm -rf %{buildroot}
DESTDIR=%{buildroot} PKG_SOVER=%{sover} PY_PREFIX=%{py_manyo_path} LIB_OPT="-lMLF -L%{py_manyo_path}" \
  %{python} do_make_Utsusemi.py install \
  --dist-name=RH7 --manyo-path=%{manyo_path} --numth=%{threads} --pyver=%{pyver} --rev=%{revdate}
popd

# Patch bashrc.py3.XXX
patch -p2 python-utsusemi-AMR/%{rc_prefix}.AMR < %{PATCH2}
patch -p2 python-utsusemi-HPN/%{rc_prefix}.HPN < %{PATCH2}
patch -p2 python-utsusemi-SIK/%{rc_prefix}.SIK < %{PATCH2}
patch -p2 python-utsusemi-VNR/%{rc_prefix}.VNR < %{PATCH2}

# Aggregate to manyo directory
mkdir -p %{buildroot}%{py_manyo_path}%{ut_prefix}
cp -af python-utsusemi/* %{buildroot}%{py_manyo_path}%{ut_prefix}
cp -af python-utsusemi-AMR %{buildroot}%{py_manyo_path}%{ut_prefix}/AMR
cp -af python-utsusemi-HPN %{buildroot}%{py_manyo_path}%{ut_prefix}/HPN
cp -af python-utsusemi-SIK %{buildroot}%{py_manyo_path}%{ut_prefix}/SIK
cp -af python-utsusemi-VNR %{buildroot}%{py_manyo_path}%{ut_prefix}/VNR

# Adjust file location
mkdir -p %{buildroot}%{install_path}/share
mv %{buildroot}%{py_manyo_path}%{ut_prefix}/AMR/%{rc_prefix}.AMR %{buildroot}%{install_path}/share
mv %{buildroot}%{py_manyo_path}%{ut_prefix}/HPN/%{rc_prefix}.HPN %{buildroot}%{install_path}/share
mv %{buildroot}%{py_manyo_path}%{ut_prefix}/SIK/%{rc_prefix}.SIK %{buildroot}%{install_path}/share
mv %{buildroot}%{py_manyo_path}%{ut_prefix}/VNR/%{rc_prefix}.VNR %{buildroot}%{install_path}/share
rm -f %{buildroot}%{py_manyo_path}%{ut_prefix}/AMR/bashrc*
rm -f %{buildroot}%{py_manyo_path}%{ut_prefix}/HPN/bashrc*
rm -f %{buildroot}%{py_manyo_path}%{ut_prefix}/SIK/bashrc*
rm -f %{buildroot}%{py_manyo_path}%{ut_prefix}/VNR/bashrc*

# Manually invoke the python byte compile macro for each path that needs byte compilation
%{python} -c 'import compileall; compileall.compile_dir("%{buildroot}%{py_manyo_path}/Manyo/Utsusemi", force=1)'
%{python} -O -c 'import compileall; compileall.compile_dir("%{buildroot}%{py_manyo_path}/Manyo/Utsusemi", force=1)'

%post
test -x /sbin/ldconfig && /sbin/ldconfig || :
rm -f %{py_manyo_path}%{ut_prefix}/ana/Sequencer.py[co]
rm -f %{py_manyo_path}%{ut_prefix}/scripts/SourceSync.py[co]

%postun
test -x /sbin/ldconfig && /sbin/ldconfig || :

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root,-)
%dir %{mlfsoft_path}
%dir %{install_path}
%dir %{py_manyo_path}
%dir %{py_manyo_path}%{ut_prefix}/ana
%dir %{py_manyo_path}%{ut_prefix}/facade
%dir %{py_manyo_path}%{ut_prefix}/scripts
%dir %{py_manyo_path}%{ut_prefix}/vis
%{py_manyo_path}%{ut_prefix}/ana/*
%{py_manyo_path}%{ut_prefix}/facade/*
%{py_manyo_path}%{ut_prefix}/scripts/*
%{py_manyo_path}%{ut_prefix}/vis/*

%if "%{ut_prefix}" != "/"
%dir %{py_manyo_path}%{ut_prefix}
%{py_manyo_path}%{ut_prefix}/__init__.py
%endif

%files AMR
%defattr(-,root,root,-)
%dir %{py_manyo_path}%{ut_prefix}/AMR
%{py_manyo_path}%{ut_prefix}/AMR/*
%{install_path}/share/%{rc_prefix}.AMR

%files HPN
%defattr(-,root,root,-)
%dir %{py_manyo_path}%{ut_prefix}/HPN
%{py_manyo_path}%{ut_prefix}/HPN/*
%{install_path}/share/%{rc_prefix}.HPN

%files SIK
%defattr(-,root,root,-)
%dir %{py_manyo_path}%{ut_prefix}/SIK
%{py_manyo_path}%{ut_prefix}/SIK/*
%{install_path}/share/%{rc_prefix}.SIK

%files VNR
%defattr(-,root,root,-)
%dir %{py_manyo_path}%{ut_prefix}/VNR
%{py_manyo_path}%{ut_prefix}/VNR/*
%{install_path}/share/%{rc_prefix}.VNR

%files lib
%defattr(-, root, root)
%dir %{mlfsoft_path}
%dir %{py_manyo_path}
%dir %{py_manyo_path}/Manyo
%dir %{py_manyo_path}/Manyo/Utsusemi
%{py_manyo_path}/libUtsusemi.so
%{py_manyo_path}/libUtsusemi.so.*
%{py_manyo_path}/Manyo/Utsusemi/*

%files devel
%dir %{install_path}/sample
%dir %{install_path}/include
%dir %{install_path}/include/Utsusemi
%dir %{install_path}/sample/Utsusemi
%{install_path}/include/Utsusemi/*
%{install_path}/sample/Utsusemi/*

%changelog
* Fri Dec 13 2019 Nobuo Okazaki - 0.3.7.191211-0.gite31e54ac
- 空蝉0.3.7および4.0.0をビルドできるようにした
- 存在するソースファイルによって動作が変わるので注意
- 空蝉0.3.7はPython2.7、空蝉4はPython3.6への対応

* Wed Nov 27 2019 Nobuo Okazaki - 4.0.0.191126-0.git77ad0a59
- 空蝉4に対応
- 空蝉4パッケージはPython3以降にのみ対応

* Thu Jan 17 2019 Nobuo Okazaki - 0.3.7.190117-0.git38e71e33
- Values of Version/Release is obtained from filename
- Patch for Makefile has been merged to main stream since 38e71e33

* Thu Jan 17 2019 Nobuo Okazaki - 0.3.7.181219-0.git62c1a0dc
- バージョン命名規則を変更
- リポジトリをgitに変更
- manyo-utsusemiとpython-utsusemiを統合しutsusemiに変更

* Fri Sep 18 2015 Nobuo Okazaki - 0.3.3.0-20150917svn668
- Build with build_manyo.py
- Build with boost-1.54.0

