import Manyo.UtsusemiEventConv2Q as mu

import Manyo
import os
import sys

#wfile = "xml/wfile.xml"
wfile = "xml/wfile_all.xml"
dfile = "xml/dfile.xml"
xfile = "XtalParam6.xml"
daqId = 0
modNo = 0
runNo = 373
withWeight=True
rotInfo="Y:15"
isReadEventData = True
if len(sys.argv)==2:
    flag = sys.argv[1]
    flag = flag.upper()
    if flag=="TRUE":
        isReadEventData = True
    elif flag=="FALSE":
        isReadEventData = False

if isReadEventData:
    if withWeight:
        os.system("rm -rf data/SIK000373_*.evt")
    else:
        os.system("rm -rf data2/SIK000373_*.evt")

tt=mu.UtsusemiEventDataConverterNeunet2QEvent()
tt.SetEi( 45.56, -4.0, 40.0, 18030.0 )
if not tt.SetTextMaskInfo("mask.txt"):
    raise UserWarning,"--- Failed SetTextMaskInfo"
tt.SetWithWeightOutput( withWeight )
tt.SetXtalParamFile( xfile, rotInfo )
if withWeight:
    tt.SetOutputPath( "/home/yinamura/dev/works/180319NewEvt/data" )
else:
    tt.SetOutputPath( "/home/yinamura/dev/works/180319NewEvt/data2" )
tt.LoadParamFiles( str(wfile), str(dfile), "" )
tt.SetDataPath( "/data","", runNo )
#tt.DumpEventToText( "data/SIK000002_00_000.evt", "data/SIK000002_00_000.txt" )
flist = Manyo.MakeStringVector()
for daqId in [0,1]:
    for modNo in range(12):
        if isReadEventData:
            tt.ReadEventData( daqId, modNo )
        flist.append( "data/SIK%06d_%02d_%03d.evt"%(runNo, daqId, modNo) )
        print("---- convert SIK%06d_%02d_%03d.evt"%(runNo, daqId, modNo))
eca=tt.Slice2d( flist, xfile )

import vis.M2Plot as mp
p=mp.M2Plot(eca)
