#ifndef	SASCALCDETECTOREFFI
#define	SASCALCDETECTOREFFI

#include "Header.hh"

//////////////////////////////////
// Efficiency Correction Tools for Analysis on SAS
/////////////////////////////////

//! Function to do correction of the detector efficiency
/*!
 *
 *
 *
 *
 */
#define C_SAS_TMP_BUF_SIZE  (UInt4)(60)
#define C_SAS_DW_DELTA	 (1.0/100.0)
// Lambda
#define	C_SAS_DW_LAMBDA_MAX			 	(15.0f)
#define	C_SAS_DW_LAMBDA_MIN			 	(0.0f)
#define	C_SAS_DW_LAMBDA_GAP			 	C_SAS_DW_DELTA
#define	C_SAS_N_LAMBDA_INTERVAL_NUM		(int)((C_SAS_DW_LAMBDA_MAX - C_SAS_DW_LAMBDA_MIN)/C_SAS_DW_LAMBDA_GAP)

// SEC = ArcCos
#define	C_SAS_DW_SEC_MAX			 	(2.0f)
#define	C_SAS_DW_SEC_MIN			 	(1.0f)
#define	C_SAS_DW_SEC_GAP			 	C_SAS_DW_DELTA
#define	C_SAS_N_SEC_INTERVAL_NUM		(int)((C_SAS_DW_SEC_MAX - C_SAS_DW_SEC_MIN)/C_SAS_DW_SEC_GAP)
class SASCalcDetectorEffi
{
private:
    Double	dwLoadBox[C_SAS_N_LAMBDA_INTERVAL_NUM][C_SAS_N_SEC_INTERVAL_NUM];

public:
    SASCalcDetectorEffi();
    ~SASCalcDetectorEffi();

    bool loadData(std::string _filepath);
    Double PutApproximateVal(double lambda,double sec);
};
#endif
