#ifndef SASP0LAMBDACORRECTION
#define SASP0LAMBDACORRECTION

#include "Header.hh"
#include "CppToPython.hh"
#include "ElementContainerMatrix.hh"
#include "UtsusemiHeader.hh"

//////////////////////////////////
// P0LambdaCorrection
/////////////////////////////////

//! Function of correction with the lambda dependency of polarization
/*!
 *
 */

class P0LambdaCorrection
{
private:

    UInt4 _NumOfMulth;
    void Initialize();
    std::string _MessageTag;
    ElementContainerMatrix* _DAT1;
    ElementContainerMatrix* _DAT2;
    std::vector<Double> _pol_lam;
    std::vector<Double> _pol_val;
    StringTools* _st;

public:
    P0LambdaCorrection();
        //!< Constructor
        /*!<
         *
         */
    P0LambdaCorrection( ElementContainerMatrix* dat1, ElementContainerMatrix* dat2 );
        //!< Constructor
        /*!<
         *  @param dat1 (ElementContainerMatrix) Data for spin flipper on
         *  @param dat2 (ElementContainerMatrix) Data for spin flipper off
         */
    ~P0LambdaCorrection();
        //!< Destructor
        /*!<
         *
         */
    void SetData( ElementContainerMatrix* dat1, ElementContainerMatrix* dat2 );
        //!< Set Data
        /*!<
         *  @param dat1 (ElementContainerMatrix) Data for spin flipper on
         *  @param dat2 (ElementContainerMatrix) Data for spin flipper off
         *  @return None
         */
    bool SetPolarizationTable( std::string _pathToData );
        //!< Set text file path for Polarization table
        /*!<  text format  <lambda>,<polarization>
         *    If the beginning of line is #, ignored
         *  @param _pathToData (std::string) path to text file
         *  @retval true  : succeeded.
         *  @retval false : failed.
         */
    bool Execute( ElementContainerMatrix* _Ip, ElementContainerMatrix* _Im );
        //!< Calcurate coherent scattering and incoherent scattering data from both with given data set of spin flipper on/off
        /*!<
         *
         *  @param _coh (ElementContainerMatrix) given empty data to be stored the coherent data
         *  @param _inc (ElementContainerMatrix) given empty data to be stored the incoherent data
         *  @param _NSF (ElementContainerMatrix) given empty data to be stored the NSF(non-spin-flip) data
         *  @param _SF (ElementContainerMatrix) given empty data to be stored the SF(spin-flip) data
         *  @retval true  : succeeded.
         *  @retval false : failed.
         */

};
#endif
