#ifndef LAMBDADEPENDCORRECTION
#define LAMBDADEPENDCORRECTION

#include "ManipulatorBase.hh"
#include "ElementContainerMatrix.hh"
#include "UtsusemiHeader.hh"
#include "StringTools.hh"

////////////////////////////////////////
// Correct ECM with lambda dependency
////////////////////////////////////////

//! Function to correct ElementContainerMatrix using give lambda dependency
/*!
 *   # Usage
 *   # DAT : ElementContainer, depend_data.txt : lambda dependency text file
 *   # Example of lambda dependency text is below. ( # charactor at head of a line is means ignored line. )
 *   #  # Lambda, Factor
 *   #  0.7, 1.0
 *   #  0.8, 1.2
 *   #  ...
 *   LD = LambdaDependCorrection(DAT)
 *   if LD.SetCurveTextDep("ALL","depend_data.txt"):
 *       if LD.Execute():
 *           .. Succeeded ..
 *       else:
 *           .. Failed ..
 *
 *
 */
class LambdaDependCorrection:
public ManipulatorBase<ElementContainerMatrix>{
private:

protected:
    const std::string _MessageTag;
    std::vector<std::string> _bankNames;
    std::string _depType;
    Map< std::pair< std::string,std::vector<double> > > _depParams;
    StringTools* _st;
    static const std::string DEP_GIVENCURVE;
    static const std::string DEP_SINGLELINE;

    void _addToParams( std::string bank, std::string type, std::vector<double> params );
    double _calFact( double x0, double y0, double x1, double y1, double x );
    bool _debugmode;

public:
    LambdaDependCorrection(ElementContainerMatrix* ecm=NULL);
        //!< Constructor
        /*!<
         *  @param ecm ElementContainerMatrix for the target
         */
    ~LambdaDependCorrection();
        //!< Destructor
        /*!<
         */
    bool SetCurveTextDep( std::string bank, std::string filepath );
        //!< Set parameters for the dependency of given curve
        /*!< function of lambda
         *
         *  @param bank (std::string) bank name
         *  @param filepath (std::string) text file path
         *  @retval true  succeeded.
         *  @retval false failed.
         */
    bool SetSingleLineDep( std::string bank, std::string params );
        //!< Set parameters for single line dependency
        /*!< line defined : A+B*lambda
         *   params = "<A>,<B>"
         *
         *  @param bank (std::string) bank name
         *  @param params (std::string) parameters
         *  @retval true  succeeded.
         *  @retval false failed.
         */
    void ClearParams( std::string bank="ALL" );
    std::vector<std::string> PutPresetBankName(){ return _bankNames; }
    bool Execute(ElementContainerMatrix* _ecm=NULL);
        //!< Execute correction
        /*!<
         *  @retval true  succeeded.
         *  @retval false failed.
         */
    bool CheckBankName(std::string);
};
#endif
