#ifndef SASCONVERTTOPOINT
#define SASCONVERTTOPOINT

#include "Header.hh"
#include "ManipulatorBase.hh"
#include "ElementContainer.hh"
#include "ElementContainerArray.hh"
#include "ElementContainerMatrix.hh"
#include "HeaderBase.hh"
#include "UtsusemiCheckDataProcess.hh"

//////////////////////////////////
// Histogram Bin to Point
/////////////////////////////////

//! Histogram format to points
/*!
 * This makes points data, which means that there is one-to-one correspondence
 * between X-values ans Y-values ( not like Histogram ).
 *
 */
class ConvertToPoint
    : public ManipulatorBase< ElementContainerMatrix >
{
private:
    UtsusemiCheckDataProcess* UCP;
    std::string _MessageTag;
    std::string _ProcessTag;
    void Initialize();

public:
    ConvertToPoint();
        //!< Constructor
        /*!<
         */
    ConvertToPoint( ElementContainerMatrix *ecm );
        //!< Constructor
        /*!<
         *   @param ec   target ElementContainer
         */
    ~ConvertToPoint();
        //!< Destructor
        /*!<
         */
    void Execute( bool isReverse=false );
};
#endif
