#include "EfficiencyCorrectionTakumi.hh"

////////////////////////////////////////
EfficiencyCorrectionTakumi::
EfficiencyCorrectionTakumi(){
    message_tag = "EffCorrTakumi>> ";
    omp_set_num_threads( UtsusemiGetNumOfMulTh() );
}

////////////////////////////////////////
bool EfficiencyCorrectionTakumi::
Execute(std::string filename){
    EmakiDetectorInfoEditorReadout detectorInfo( filename );
    if (! detectorInfo._Status ){
        return false;
    }
    /*
    if (detectorInfo.ImportEfficiency() != 0){
        std::cout << message_tag << "No efficiency parameters!" << std::endl;
        return false;
    }
    */
    ElementContainerMatrix* ecm = Put();
    if (ecm == NULL){
        std::cout << message_tag << "ElementContainerMatrix is not set." << std::endl;
        return false;
    }
    for (Int4 i=0; i<Target->PutSize(); ++i){
        ElementContainerArray* eca=ecm->PutPointer(i);
#pragma omp parallel for
        for (Int4 j=0; j<eca->PutSize(); ++j){
            HeaderBase* hh = eca->PutPointer(j)->PutHeaderPointer();
            Int4 pixelId = hh->PutInt4("PIXELID");
            if (pixelId < detectorInfo.efficiencyParam.size()){
                eca->PutPointer(j)->MulMySelf(detectorInfo.efficiencyParam[pixelId]);
            }
        }
    }
    return true;
}
