# -*- coding: utf-8 -*-

#####################
## Command Sequence of Quesi Elastic Neutron Scattering
#####################

# special reserved word for commands history
HISTORY = None
# reserved words for return value in this.
DAT = None
ECA = None
EC = None
ecaRes = None
ecaDet = None

import Manyo as mm
#import DNA.ana.Reduction.ElasticScanBase as ES
import utsusemi.DNA.ana.Reduction.QensBase as QB
import utsusemi.DNA.ana.Reduction.PeakFitBase as PF
import utsusemi.DNA.ana.Reduction.SearchPathDNA as SPD

#basepath="/usr/local/mlf/DNA/tmp/"
#search_dir="/home/dnaadmin/ana/setup/"
search_dir=SPD.CheckForOutput("setup")
if search_dir=="":
    raise UserWarning("ElasticScan.py >> Not found setup directory.")

NumOfItteration = 1000

plotflug = False

#########################################
#def GetDataOfDNA(runNo=314,HwParam=" ",LambParam=" ",QParam=" ",TimeParam=" ",initFile="GetQEDataOfDNA.ini",outputData="QE",fileTag="_"):
#    """
#    Load EventData and convert to QE map
#    - GetHistogramHW(runNo,dHW,hw_min,hw_max,tof_offset,startTime,endTime)
#    - DoMask(DAT)
#    - ILambdaCorrDNA(dat,ec)
#    - SolidAngleCorrDNA(dat)
#    - CreateQEMap(dat,startQ,endQ,deltaQ)
#
#    @param runNo        (int) Run Number
#    @param HwParam      (string)
#    @param LambParam    (string)
#    @param QParam       (string)
#    @param TimeParam    (string)
#    @param initFile     (string)
#    @param fileTag      (string)   
#    @retval ECM      (ElementContainerMatrix)
#    """
#
#    return ES.GetDataOfDNA(runNo, HwParam, LambParam, QParam, TimeParam, initFile, outputData, fileTag,search_dir)
#
#########################################

def SliceQE(dat=DAT,lowerQ=0.1,upperQ=0.5):
    """
    $B:G>.CM!":GBgCM$rF~NO$7$F!"$=$NHO0O$K4^$^$l$k(BEC$B$rJV$9!#(B
    @param dat       (ElementContaienrArray)
    @param lowerQ    (double) lowerQ
    @param upperQ    (double) upperQ
    @retval ec       (ElementContainer)
    """
    return QB.sliceQE(dat,lowerQ,upperQ)

##########################################

def SetEbinForECA(eca=DAT,initial=-0.1,final=0.1,delta=0.01):
    """
    $B:G>.CM!":GBgCM!"9o$_I}$rF~NO$7$F(BECA$B$r(BE$B%S%K%s%0$r9T$&!#(B
    @param  dat        (ElementContaienrArray)
    @param  initial    (double)
    @param  final      (double)
    @param  delta      (double)
    @retval DAT        (ElementContaienrArray)
    """
    return QB.setEbinForECA(eca,initial,final,delta)

##########################################

def SetEbinForEC(ec=EC,initial=-0.1,final=0.1,delta=0.01):
    """
    $B:G>.CM!":GBgCM!"9o$_I}$rF~NO$7$F(BEC$B$r(BE$B%S%K%s%0$r9T$&!#(B
    @param  ec         (ElementContaienr)
    @param  initial    (double)
    @param  final      (double)
    @param  delta      (double)
    @retval EC         (ElementContaienr)
    """
    return QB.setEbinForEC(ec,initial,final,delta)

##########################################

def SetEbin(ec=EC,initial=-0.1,final=0.1,delta=0.01):
    """
    $B:G>.CM!":GBgCM!"9o$_I}$rF~NO$7$F(BE$B%S%K%s%0$r9T$&!#(B
    @param  ec         (ElementContaienr/Array)
    @param  initial    (double)
    @param  final      (double)
    @param  delta      (double)
    @retval EC         (ElementContaienr/Array)
    """
    return QB.setEbin(ec,initial,final,delta)

##########################################
#
#def SetEbinForECA(eca=DAT,initial=-0.1,final=0.1):
#    """
#    SetEbin
#
#    @param  dat        (ElementContaienrArray)
#    @param  initial    (double)
#    @param  final      (double)
#    @retval DAT        (ElementContaienrArray)
#    """
#    return QB.setEbinForECA(eca,initial,final)
#
##########################################
#
#def SetEbinForEC(ec=EC,initial=-0.1,final=0.1):
#    """
#    SetEbin
#
#    @param  ec         (ElementContaienr)
#    @param  initial    (double)
#    @param  final      (double)
#    @retval EC         (ElementContaienr)
#    """
#    return QB.setEbinForEC(ec,initial,final)
#
##########################################
#
#def SetEbin(ec=EC,initial=-0.1,final=0.1):
#    """
#    SetEbin
#
#    @param  ec         (ElementContaienr/Array)
#    @param  initial    (double)
#    @param  final      (double)
#    @retval EC         (ElementContaienr/Array)
#    """
#    return QB.setEbin(ec,initial,final)
#
##########################################

def SetQbin(dat=ECA,initialQ=0.0,finalQ=1.0,deltaQ=0.1):
    """
    $B:G>.CM!":GBgCM!"9o$_I}$rF~NO$7$F!"(BQ$B%S%K%s%0$r9T$&!#(B
    @param dat    (ElementContaienrArray)
    @param initialQ  (double)
    @param finalQ    (double)
    @param deltaQ    (double)
    @retval DAT   (ElementContaienrArray)
    """
    return QB.setQbin(dat,initialQ,finalQ,deltaQ)

##########################################

def SetQbinbyText(dat=ECA,Q_list_string=" "):
    """
    $B%+%s%^6h@Z$j%F%-%9%H$N%F!<%V%k$r?7$7$$(BQ$B$N6-3&$H$7$F!"(BQ$B%S%K%s%0$r9T$&!#(B
    @param dat    (ElementContaienrArray)
    @param Q_list_string         (string)
    @retval DAT   (ElementContaienrArray)
    """
    return QB.setQbinbyText(dat,Q_list_string)

##########################################

def SelectFittingQbin(dat=ECA,fitlist=" "):
    """
    $B%+%s%^6h@Z$jJ8;zNs$G;XDj$7$?(BBool$B$K$h$j!"(BFitting$B$r9T$&$+$I$&$+$r=q$-9~$`!#(B
    Select Fitting Q bin
    -filtlist is comma-separated-string, t or f
    @param dat        (ElementContaienrArray)
    @param fitlist    (string)
    @retval None
    """
    return QB.selectFittingQbin(dat,fitlist)

##########################################

def CheckQbin(dat=ECA):
    """
    Fitting$B$r9T$&$+$I$&$+$N(BCheck$B!#I8=`=PNO$X=q$-9~$`!#(B
    Check Qbin information
     --retval is Q histogram of EC integrated toward Hw axis

    @param dat    (ElementContaienrArray)
    @retval EC    (ElementContaienr)
    """
    return QB.CheckQbin(dat)

#########################################

def GetIntegralHWData(dat=ECA,emin=0.0,emax=1.0):
    """
    I(Q,E)$B$rF~NO$7!"F~NO$7$?HO0O$K(BE$BJ}8~$K@QJ,$7$?(BI(Q)$B$N?tCM%j%9%H$rJV$9!#(B
    @param dat    (ElementContaienrArray)
    @param emiin   (float)
    @param emax    (float)
    @retval ret    (list)
    """
    return QB.getIntegralHWData(dat,emin,emax)

#########################################

def SetFunction(function="lc dc"):
    """
    $B%U%#%C%F%#%s%04X?t$N@_Dj(B
    Set Fitting Function
    -function is space-separated-stirng
    -function:
     -- Lorentz function = l
     -- Gauss function   = g
     -- convoluted Lorentz function = lc
     -- convoluted Gauss function = gc
     -- convoluted delta function = dc

    @param    function (string)
    @retval   function (string)
    """
    return PF.SetFunction(function)

##########################################

def SetInitialParam(initParam=""):
    """
    $B%U%#%C%F%#%s%0=i4|%Q%i%a!<%?$N@_Dj(B
    Set Initial fitting parameter
    -initParam is comma-separaed-string

    @param    initParam (string)
    @retval   initParam (string)
    """
    return PF.SetInitialParam(initParam)

##########################################

def LoadInitialParam(filename="test.txt"):
    """
    For Utsusemi interface
    - Load Initial Parameter from external text file

    @param    filename
    @retval   initParam (string)
    """
    param,param_ub,parama_lb = QB.LoadFittingParam(filename)
    return param

##########################################

def LoadInitialLBParam(filename="test.txt"):
    """
    For Utsusemi interface
    - Load Initial Parameter(Lower bound) from external text file

    @param    filename
    @retval   initParam (string)
    """
    param,param_ub,param_lb = QB.LoadFittingParam(filename)
    return param_lb

##########################################

def LoadInitialUBParam(filename="test.txt"):
    """
    For Utsusemi interface
    - Load Initial Parameter(Upper bound) from external text file

    @param    filename
    @retval   initParam (string)
    """
    param,param_ub,parama_lb = QB.LoadFittingParam(filename)
    return param_ub

##########################################

def LoadFittingParam(filename="test.txt"):
    """
    - Load Initial Parameter from external text file

    @param    filename
    @retval   initParam (string)
    """
    return QB.LoadFittingParam(filename)

##########################################

def SaveFittingParam(function,param,param_ub,param_lb,link,filename="test.txt"):
    """
    Save Fitting initial Param

    @param    param(str/list)
    @param    param_ub(str/list)
    @param    param_lb(str/list)
    @param    link(str/list)
    @param    filename(str)
    @retval   None
    """
    return QB.saveFittingParam(function,param,param_ub,param_lb,link,filename)

##########################################

def SetResolutionData(ec=EC):
    """
    Set Resolution function by EC, for convolution fitting

    @param    ec (ElementContainer)
    @retval   None
    """
    return PF.SetResolutionData(ec)

##########################################

def PeakConvFitEC(ecDet,ecRes,function,param,param_ub,param_lb,link_value,fit_region="",useDomain=True):
    """
    Peak Convolution Fitting script by using Levmar

    @param ecDet           (ElementContainer)
    @param ecRes           (ElementContainer)
    @param function        (string)
    @param param           (string)
    @param param_lb        (string)
    @param param_ub        (string)
    @param link_value      (string)
    @param useDomain       (bool)
    @retval eca            (ElementContainerArray)
    """
    return QB.peakConvFitEC(ecDet,ecRes,function,param,param_ub,param_lb,link_value,fit_region,useDomain,NumOfItteration,plotflug)

##########################################

def PeakConvFitECA(ecaDet,ecaRes,function,param,param_ub,param_lb,link_value,fit_region="",useDomain=True):
    """
    Peak Convolution Fitting script by using Levmar

    @param ecaDet           (ElementContainerArray)
    @param ecaRes           (ElementContainerArray)
    @param function        (string)
    @param param           (string)
    @param param_lb        (string)
    @param param_ub        (string)
    @param link_value      (string)
    @param useDomain       (bool)
    @retval ecm            (ElementContainerMatrix)
    """
    return QB.peakConvFitECA(ecaDet,ecaRes,function,param,param_ub,param_lb,link_value,fit_region,useDomain,NumOfItteration,plotflug)

##########################################

def PeakConvFit(ecaDet,ecaRes,function,param,param_ub,param_lb,link_value,fit_region="",useDomain=True):
    """
    Peak Convolution Fitting script by using Levmar

    @param ecaDet           (ElementContainerArray)
    @param ecaRes           (ElementContainerArray)
    @param function        (string)
    @param param           (string)
    @param param_lb        (string)
    @param param_ub        (string)
    @param link_value      (string)
    @param useDomain       (bool)
    @retval ecm            (ElementContainerMatrix)
    """
    return QB.peakConvFit(ecaDet,ecaRes,function,param,param_ub,param_lb,link_value,fit_region,useDomain,NumOfItteration,plotflug)

##########################################

def PeakFitEC(ecDet,function,param,param_ub,param_lb,link_value,fit_region="",useDomain=True):
    """
    Peak Fitting script by using Levmar

    @param ecDet           (ElementContainer)
    @param function        (string)
    @param param           (string)
    @param param_lb        (string)
    @param param_ub        (string)
    @param link_value      (string)
    @param useDomain       (bool)
    @retval eca            (ElementContainerArray)
    """
    return QB.peakFitEC(ecDet,function,param,param_ub,param_lb,link_value,fit_region,useDomain,NumOfItteration,plotflug)

##########################################

def PeakFitECA(ecaDet,function,param,param_ub,param_lb,link_value,fit_region="",useDomain=True):
    """
    Peak Fitting script by using Levmar

    @param ecaDet           (ElementContainerArray)
    @param function        (string)
    @param param           (string)
    @param param_lb        (string)
    @param param_ub        (string)
    @param link_value      (string)
    @param useDomain       (bool)
    @retval ecm            (ElementContainerMatrix)
    """
    return QB.peakFitECA(ecaDet,function,param,param_ub,param_lb,link_value,fit_region,useDomain,NumOfItteration,plotflug)

##########################################

def PeakFit(ecaDet,function,param,param_ub,param_lb,link_value,fit_region="",useDomain=True):
    """
    Peak Fitting script by using Levmar

    @param ecaDet           (ElementContainer/Array)
    @param function        (string)
    @param param           (string)
    @param param_lb        (string)
    @param param_ub        (string)
    @param link_value      (string)
    @param useDomain       (bool)
    @retval ecm            (ElementContainerArray/Matrix)
    """
    return QB.peakFit(ecaDet,function,param,param_ub,param_lb,link_value,fit_region,useDomain,NumOfItteration,plotflug)

##########################################

def GetConvFitGuessEC(ecDet,ecRes,function,param,fit_region=""):
    """
    Get convolution fitting Initial parameter function and obseved data

    @param ecDet           (ElementContainer)
    @param ecRes           (ElementContainer)
    @param function        (string)
    @param param           (string)
    @retval eca            (ElementContainerArray)
    """
    return QB.getConvFitGuessEC(ecDet,ecRes,function,param,fit_region,plotflug)

##########################################

def GetConvFitGuessECA(ecaDet,ecaRes,function,param,fit_region=""):
    """
    Get convolution fitting Initial parameter function and obseved data

    @param ecaDet           (ElementContainerArray)
    @param ecaRes           (ElementContainerArray)
    @param function        (string)
    @param param           (string)
    @retval ecm            (ElementContainerMatrix)
    """
    return QB.getConvFitGuessECA(ecaDet,ecaRes,function,param,fit_region,plotflug)


##########################################

def GetConvFitGuess(ecaDet,ecaRes,function,param,fit_region=""):
    """
    Get convolution fitting Initial parameter function and obseved data

    @param ecaDet           (ElementContainer/Array)
    @param ecaRes           (ElementContainer/Array)
    @param function        (string)
    @param param           (string)
    @retval ecm            (ElementContainerArray/Matrix)
    """
    return QB.getConvFitGuess(ecaDet,ecaRes,function,param,fit_region,plotflug)

##########################################

def GetFitGuessEC(ecDet,function,param,fit_region=""):
    """
    Get fitting Initial parameter function and obseved data

    @param ecDet           (ElementContainer)
    @param function        (string)
    @param param           (string)
    @retval eca            (ElementContainerArray)
    """
    return QB.getFitGuessEC(ecDet,function,param,fit_region,plotflug)

##########################################

def GetFitGuessECA(ecaDet,function,param,fit_region=""):
    """
    Get fitting Initial parameter function and obseved data

    @param ecaDet           (ElementContainerArray)
    @param function        (string)
    @param param           (string)
    @retval ecm            (ElementContainerMatrix)
    """
    return QB.getFitGuessECA(ecaDet,function,param,fit_region,plotflug)

##########################################

def GetFitGuess(ecaDet,function,param,fit_region=""):
    """
    Get fitting Initial parameter function and obseved data

    @param ecaDet           (ElementContainer/Array)
    @param function        (string)
    @param param           (string)
    @retval ecm            (ElementContainerArray/Matrix)
    """
    return QB.getFitGuess(ecaDet,function,param,fit_region,plotflug)

##########################################

def GetResultFunction(result_ecm=DAT,Qnum=0):
    """
    Get resolution(entered) function from Result retval

    @param    result_ecm (ElementContainerMatrix/ElementContainerArray)
    @param    Qnum (int)
    @retval   ec (ElementContainer)
    """
    if type(result_ecm) == mm.ElementContainerMatrix:
        return result_ecm(0)(Qnum)
    if type(result_ecm) == mm.ElementContainerArray:
        return result_ecm(0)

##########################################

def GetObservedData(result_ecm=DAT,Qnum=0):
    """
    Get observed(entered) data from Result retval

    @param    result_ecm (ElementContainerMatrix/ElementContainerArray)
    @param    Qnum (int)
    @retval   ec (ElementContainer)
    """
    if type(result_ecm) == mm.ElementContainerMatrix:
        return result_ecm(1)(Qnum)
    if type(result_ecm) == mm.ElementContainerArray:
        return result_ecm(1)

##########################################

def GetInitialFunction(result_ecm=DAT,Qnum=0):
    """
    Get initial fitting function from Result retval

    @param    result_ecm (ElementContainerMatrix/ElementContainerArray)
    @param    Qnum (int)
    @retval   ec (ElementContainer)
    """
    if type(result_ecm) == mm.ElementContainerMatrix:
        return result_ecm(2)(Qnum)
    if type(result_ecm) == mm.ElementContainerArray:
        return result_ecm(2)

##########################################

def GetResidualFunction(result_ecm=DAT,Qnum=0):
    """
    Get residual function [ (fitted - observed)/sigma ] from Result retval

    @param    result_ecm (ElementContainerMatrix/ElementContainerArray)
    @param    Qnum (int)
    @retval   ec (ElementContainer)
    """
    if type(result_ecm) == mm.ElementContainerMatrix:
        return result_ecm(3)(Qnum)
    if type(result_ecm) == mm.ElementContainerArray:
        return result_ecm(3)

##########################################

def GetSigma(result=DAT):
    """
    Get sigma
    sigma = sqrt sum_i [(fitted - observed)**2/sigma_observed] / fitting-data-num
    @param    result (ElementContainerMatrix/ElementContainerArray)
    @retval   val (list.float)
    """
    return QB.getSigma(result)

##########################################

def GetQValue(eca):
    """
    Get Q Value
    @param    eca (ElementContainerArray)
    @retval   val (list)
    """
    return QB.getQValue(eca)

##########################################

def GetFittingParameterEC(result_ecm=DAT,parameter="1",axis="Q"):
    """
    Get Fitting parameter result function for each Q value

    @param result_ecm  (ElementContainerMatrix)
    @param parameter   (int/string)
    @param axis        (string)
    @retval ecOut      (ElementContainer)
    """
    return QB.getFittingParameterEC(result_ecm(0),parameter,axis)

##########################################
#
#def ShowFitResult(result=DAT):
#    """
#    Show Fitting Result, input is fitting result reval
#
#    @param result          (ElementContainerArray/Matrix)
#    """
#    return QB.showFitResult(result)
#
##########################################
#
#def ShowFitResultEC(result=DAT):
#    """
#    Show Fitting Result, input is fitting result reval
#
#    @param result          (ElementContainerArray)
#    """
#    return QB.showFitResultEC(result)
#
##########################################
#
#def ShowFitResultECA(result=DAT):
#    """
#    Show Fitting Result, input is fitting result reval
#
#    @param result          (ElementContainerMatrix)
#    """
#    return QB.showFitResultECA(result)
#
##########################################
#
#def ShowFitGuess(result=DAT):
#    """
#    Show Fitting Guess Result, input is reval of GetFitGuess or GetConvFitGuess
#
#    @param result          (ElementContainerArray/Matrix)
#    """
#    return QB.showFitGuess(result)
#
##########################################
#
#def ShowFitGuessEC(result=DAT):
#    """
#    Show Fitting Guess Result, input is reval of GetFitGuess or GetConvFitGuess
#
#    @param result          (ElementContainerArray)
#    """
#    return QB.showFitGuessEC(result)
#
##########################################
#
#def ShowFitGuessECA(result=DAT):
#    """
#    Show Fitting Guess Result, input is reval of GetFitGuess or GetConvFitGuess
#
#    @param result          (ElementContainerMatrix)
#    """
#    return QB.showFitGuessECA(result)
#
##########################################
#
#def ShowFittingParameterPlot(result=DAT):
#    """
#    Show Fitting parameter Plot, input is reval of GetFittingParameterEC
#
#    @param result          (ElementContainer)
#    """
#    return QB.showFittingParameterPlot(result)
#
##########################################

def GetFitEachResult(result=DAT):
    """
    Get each components of Fitting result function

    @param result          (ElementContainerMatrix)
    """
    return QB.getFitEachResult(result)

##########################################

def ExportCsvFitResult(result=DAT,filename="fitlog.txt"):
    """
    Export Fitting Result to Csv file

    @param result          (ElementContainerArray)
    @param filename        (str)
    """
    return QB.exportCsvFitResult(result,filename)

##########################################

def ExportCsvFitParamResult(result=DAT,filename="fitlog.txt"):
    """
    Export Fitting Param Result to Csv file

    @param result          (ElementContainerArray)
    @param filename        (str)
    """
    return QB.exportCsvFitParamResult(result,filename)

##########################################

def GetFittingParamResult(result=DAT):
    """
    @param result          (ElementContainerArray)
    @param filename        (str)
    @retval (list)
    """
    return QB.getFittingParamResult(result)

##########################################

def SelectQbin(eca,num):
    """
    Select Qbin for Individual Q-bin Fitting

    @param eca          (ElementContainerArray)
    @param num          (int)
    @retval ec          (ElementContainer)
    """
    return QB.selectQbin(eca,num)

##########################################

def GetParamList(function):
    """
    Select Qbin for Individual Q-bin Fitting

    @param function     (str)
    @retval outputText  (list)
    """
    return QB.getParamList(function)

##########################################

def OutputECText(ec, filename="qens.txt"):
    """
    Output EC data to text file

    @param ec                     (ElementContainer)
    @param filename                    (string)
    """
    return QB.OutputECText(ec,filename)

##########################################

def ReadECA(filename=""):
    """
    @param filename  (string)
    @retval eca      (ElementContainerArray)
    """
    return QB.ReadECA(filename)

##########################################

def OutputECA(eca,filepath):
    """
    @param  eca         (ElementContainerArray)
    @param  filepath    (str)
    @retval None
    """
    return QB.OutputECA(eca,filepath)

##########################################

def GetFunctionName(function=""):
    """
    @param function  (string)
    @retval listFuncName  (list)
    """
    return QB.getFunctionName(function)


##########################################

def GetParamName(function=""):
    """
    @param function  (string)

    @retval listParamName  (list)
    """
    return QB.getParamName(function)


##########################################

def ElementContainerToXYList(ec=EC):
    """
    @param ec        (ElementContainer)
    @retval xylist   (list)
    """
    return QB.ElementContainerToXYList(ec)

##########################################

def ElementContainerArrayToXYList2(eca=DAT):
    """
    @param eca        (ElementContainerArray)
    @retval xylist    (list)
    """
    return QB.ElementContainerArrayToXYList2(eca)

##########################################

def GetNumOfEC(eca=DAT):
    """
    @param eca       (ElementContainerArray)
    @retval val      (int)
    """
    return QB.getNumOfEC(eca)

##########################################

def GetUnit(eca=DAT):
    """
    @param eca       (ElementContainerArray)
    @retval val      (list)
    """
    return QB.getUnit(eca)

##########################################

def GetKeyName(eca=DAT):
    """
    @param eca       (ElementContainerArray)
    @retval val      (list)
    """
    return QB.getKeyName(eca)


##########################################

def GetQBoundary(eca):
    """
    @param eca        (ElementContainerArray)
    @retval qlist     (list)
    """
    return QB.getQBoundary(eca)

##########################################

def SetConvolutionRange(eca,rangelist):
    """
    @param eca        (ElementContainerArray)
    @param rangelist  (list)
    @retval eca       (ElementContainerArray)
    """
    return QB.setConvolutionRange(eca,rangelist)

##########################################

def GetBinInformation(eca=DAT):
    """
    @param eca       (ElementContainerArray)
    @retval val      (list)
    """
    return QB.getBinInformation(eca)

##########################################

def GetFittingRawData(eca):
    """
    @param eca        (ElementContainerArray)
    @retval xylist    (list)
    """
    return QB.getFittingRawData(eca)

##########################################

def GetFittingRawDataWithError(eca):
    """
    @param eca        (ElementContainerArray)
    @retval xylist    (list)
    """
    return QB.getFittingRawDataWithError(eca)

##########################################

def GetFittingResultData(ecm=DAT):
    """
    @param ecm        (ElementContainerArray)
    @retval xylist    (list)
    """
    return QB.getFittingResultData(ecm)

##########################################

def GetResidualDistributionData(ecm):
    """
    @param ecm        (ElementContainerMatrix)
    @retval xylist    (list)
    """
    return QB.getResidualDistributionData(ecm)

##########################################

def GetFittingParameterData(result_ecm=DAT,parameter="1",axis="Q"):
    """
    @param ecm        (ElementContainerMatrix)
    @retval xylist    (list)
    """
    return QB.getFittingParameterData(result_ecm(0),parameter,axis)


##########################################

def GetDeltaFuncResolECA(ecaIn):
    """
    @param ecaIn        (ElementContainerArray)
    @retval ecaOut      (ElementContainerArray)
    """
    return QB.getDeltaFuncResolECA(ecaIn)

##########################################

def UsePastExecuteResult(ecmIn,num,resultlist):
    """
    @param ecmIn        (ElementContainerMatrix)
    @param num        (int)
    @param resultlist        (list)
    @retval ecmOut      (ElementContainerMatrix)
    """
    return QB.usePastExecuteResult(ecmIn,num,resultlist)

##########################################

def ChceckZeroYValueForECA(eca):
    """
    @param  eca         (ElementContainerArray)
    @retval ecaNew      (ElementContainerArray)
    """
    return QB.chceckZeroYValueForECA(eca)

##########################################

def ImportDaveFormat(filepath):
    """
    @param  filepath    (str)
    @retval eca         (ElementContainerArray)
    """
    return QB.importDaveFormat(filepath)

##########################################

def ExportDaveFormat(eca,filepath):
    """
    @param  eca         (ElementContainerArray)
    @param  filepath    (str)
    @retval None
    """
    return QB.exportDaveFormat(eca,filepath)

##########################################

def ImportTextFormat(filepath):
    """
    @param  filepath    (str)
    @retval eca         (ElementContainerArray)
    """
    return QB.importTextFormat(filepath)

##########################################

def ExportTextFormat(eca,filepath):
    """
    @param  eca         (ElementContainerArray)
    @param  filepath    (str)
    @retval None
    """
    return QB.exportTextFormat(eca,filepath)

##########################################

# Dictionary for entry the name of functions
_functions = {
                "SliceQE":SliceQE,
                "SetQbin":SetQbin,
                "SetQbinbyText":SetQbinbyText,
                "SetEbin":SetEbin,
                "SelectFittingQbin":SelectFittingQbin,
                "CheckQbin":CheckQbin,
                "SetFunction":SetFunction,
                "SetInitialParam":SetInitialParam,
                "LoadInitialParam":LoadInitialParam,
                "LoadInitialUBParam":LoadInitialUBParam,
                "LoadInitialLBParam":LoadInitialLBParam,
                "PeakConvFit":PeakConvFit,
                "PeakFit":PeakFit,
                "GetConvFitGuess":GetConvFitGuess,
                "GetFitGuess":GetFitGuess,
                "GetResultFunction":GetResultFunction,
                "GetObservedData":GetObservedData,
                "GetResidualFunction":GetResidualFunction,
                "GetInitialFunction":GetInitialFunction,
                "GetSigma":GetSigma,
                "GetFittingParameterEC":GetFittingParameterEC,
                "GetFitEachResult":GetFitEachResult,
                "ExportCsvFitResult":ExportCsvFitResult,
                "SelectQbin":SelectQbin,
                "OutputECText":OutputECText,
                "ReadECA":ReadECA             }
                #"GetDataOfDNA":GetDataOfDNA,
                #"ShowFitResult":ShowFitResult,
                #"ShowFitGuess":ShowFitGuess,
                #"ShowFittingParameterPlot":ShowFittingParameterPlot,

