#!/usr/bin/python
# -*- coding: utf-8 -*-

import time
import os
import Manyo as mm
import math

import utsusemi.DNA.ana.Reduction.FunctionBase as FuncBase

# special reserved word for commands history
HISTORY = None

# reserved words for return value in this.
DAT = None
ecs = None
EC = None
EC1 = None
EC2 = None
ret = None
ECA = None

################################################################################################################

def Gaussian(param1=1.0,param2=0.0,param3=0.5,initial_bin=-2.0,final_bin=2.0,delta_bin=0.05,errFact=-1.0):
    """
    @param param1        (float) hight
    @param param2        (float) center
    @param param3        (float) fwhm
    @param initial_bin   (float)
    @param final_bin     (float)
    @param delta_bin     (float)
    @param errFact       (float)
    @retval EC (ElementContainer)
    """
    return FuncBase.Gaussian(param1,param2,param3,initial_bin,final_bin,delta_bin,errFact)

################################################################################################################

def Lorentzian(param1=1.0,param2=0.0,param3=0.5,initial_bin=-2.0,final_bin=2.0,delta_bin=0.05,errFact=-1.0):
    """
    @param param1        (float)
    @param param2        (float)
    @param param3        (float)
    @param initial_bin   (float)
    @param final_bin     (float)
    @param delta_bin     (float)
    @param errFact       (float)
    @retval EC (ElementContainer)
    """
    return FuncBase.Lorentzian(param1,param2,param3,initial_bin,final_bin,delta_bin,errFact)

################################################################################################################

def Function(function="g g",param="",initial_bin=-2.0,final_bin=2.0,delta_bin=0.05,errFact=-1.0):
    """
    @function          (string)
    @param param       (string) 
     "1.0,-0.5,0.3,0.5,1.0,0.4"
    @param initial_bin (float)
    @param final_bin   (float)
    @param delta_bin   (float)
    @param errFact       (float)
    @retval EC (ElementContainer)
    """
    return FuncBase.Function(function,param,initial_bin,final_bin,delta_bin,errFact)

################################################################################################################

def NumpyHammingWindow(ec0=EC):
    """
    @param ec0            (ElementContainer)
    @retval EC           (ElementContainer)
    """
    return FuncBase.NumpyHammingWindow(ec0)

################################################################################################################

def NumpyHanningWindow(ec0=EC):
    """
    @param ec0            (ElementContainer)
    @retval EC           (ElementContainer)
    """
    return FuncBase.NumpyHanningWindow(ec0)

################################################################################################################

def NumpyBlackmanWindow(ec0=EC):
    """
    @param ec0            (ElementContainer)
    @retval EC           (ElementContainer)
    """
    return FuncBase.NumpyBlackmanWindow(ec0)

################################################################################################################

def NumpyBartlettWindow(ec0=EC):
    """
    @param ec0            (ElementContainer)
    @retval EC           (ElementContainer)
    """
    return FuncBase.NumpyBartlettWindow(ec0)

################################################################################################################

def RotationX(ec0=EC,number=100):
    """
    @param ec0            (ElementContainer)
    @param number         (int)
    @retval EC            (ElementContainer)
    """
    return FuncBase.RotationX(ec0,number)

################################################################################################################

def HalfRotationX(ec0=EC):
    """
    @param ec0            (ElementContainer)
    @retval EC            (ElementContainer)
    """
    return FuncBase.HalfRotationX(ec0)

################################################################################################################

def AddZeroUpper(ec0=EC,number=100):
    """
    @param ec0            (ElementContainer)
    @param number         (int)
    @retval EC            (ElementContainer)
    """
    return FuncBase.AddZeroUpper(ec0,number)

################################################################################################################

def AddZeroLower(ec0=EC,number=100):
    """
    @param ec0            (ElementContainer)
    @param number         (int)
    @retval EC            (ElementContainer)
    """
    return FuncBase.AddZeroLower(ec0,number)

################################################################################################################

def AddZero(ec0=EC,number=100):
    """
    @param ec0            (ElementContainer)
    @param number         (int)
    @retval EC            (ElementContainer)
    """
    return FuncBase.AddZero(ec0,number)

################################################################################################################

def AddSreiesSamaEC(ec0=EC,number=10):
    """
    @param ec0            (ElementContainer)
    @param number         (int)
    @retval EC            (ElementContainer)
    """
    return FuncBase.AddSreiesSamaEC(ec0,number)

################################################################################################################



def ErrorValueMultiplyConstant(ec0=EC,constant=100):
    """
    @param ec0            (ElementContainer)
    @param constant         (int)
    @retval EC            (ElementContainer)
    """
    return FuncBase.ErrorValueMultiplyConstant(ec0,constant)


################################################################################################################

# Dictionary for entry the name of functions
_functions = {
               "Gaussian":Gaussian,
               "Lorentzian":Lorentzian,
               "Function":Function,
               "NumpyHammingWindow":NumpyHammingWindow,
               "NumpyHanningWindow":NumpyHanningWindow,
               "NumpyBlackmanWindow":NumpyBlackmanWindow,
               "NumpyBartlettWindow":NumpyBartlettWindow,
               "AddZeroUpper":AddZeroUpper,
               "AddZeroLower":AddZeroLower,
               "AddZero":AddZero,
               "AddSreiesSamaEC":AddSreiesSamaEC,
               "RotationX":RotationX,
               "HalfRotationX":HalfRotationX,
               "ErrorValueMultiplyConstant":ErrorValueMultiplyConstant
             }
         
