import numpy
#-------------------------------------------------------------------------------------------------
def EcmIntensity2TwoLayerArray(dat):
    xn = dat.PutTableSize()
    yn = dat.Put(0).PutTableSize()
    ecxy=[]
    for i in range(xn):
        eca=dat.PutPointer(i)
        ecy=[]
        for j in range(yn):
            ec=eca.PutPointer(j)
            yv=numpy.array(ec.PutYList())
            ev=numpy.array(ec.PutEList())
            sumval=numpy.sum(yv[ev>0])
            ecy.append(sumval)
        ecxy.append(ecy)
    v=numpy.array(ecxy)
    return v
#-------------------------------------------------------------------------------------------------
def PylabPlotTwoLayerArray(varray, xregion, yregion, zregion):

    import pylab

    hv   = len(varray)/2
    v_up = varray[:hv]
    v_up = numpy.array(v_up)
    v_up = numpy.transpose(v_up)

    v_down = varray[hv:]
    v_down = [ ve[-1::-1] for ve in v_down[-1::-1] ]
    v_down = numpy.array(v_down)
    v_down = numpy.transpose(v_down)

    Z = numpy.vstack((v_up,v_down))

    pylab.figure(figsize=(10,4))

    #x = numpy.linspace(0, len(Z[0]), len(Z[0])+1)
    #y = numpy.linspace(0, len(Z), len(Z)+1)
    #X, Y = numpy.meshgrid(x, y)
    #pylab.pcolor(X, Y, Z)
    xc = numpy.linspace(0, len(Z[0]), len(Z[0]))
    yc = numpy.linspace(0, len(Z), len(Z))

    minval=zregion[0]
    maxval=zregion[1]

    div   =(maxval-minval)/1000.0
    pylab.contourf(xc,yc,Z,numpy.arange(minval,maxval,div),extend="both")

    pylab.xlabel("Psd No.")
    pylab.ylabel("Pixel No.")

    pylab.colorbar()
    pylab.xlim(xregion)
    pylab.ylim(yregion)

    pylab.show()

